/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.abilitydata;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.ability.AbilityService;
import com.tcbj.crm.abilitydata.AbilityDataCondition;
import com.tcbj.crm.abilitydata.AbilityDataService;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.Ability;
import com.tcbj.crm.entity.AbilityData;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/abilitydata"})
public class AbilityDataController
extends BaseController {
    @Autowired
    private AbilityDataService service;
    @Autowired
    private AbilityService abilityService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AbilityDataCondition condition, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        Map<String, Ability> map = this.initMap(e.getCurrentPartner().getId(), condition.getYear());
        Page page = this.service.getPage(pageno, condition);
        List abilityDatas = page.getList();
        for (AbilityData abilityData : abilityDatas) {
            if (map.get(abilityData.getAbilityId()) == null) continue;
            abilityData.into(map.get(abilityData.getAbilityId()));
        }
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "abilitydata/list.ftl";
    }

    private Map<String, Ability> initMap(String partnerId, Integer year) {
        HashMap<String, Ability> map = new HashMap<String, Ability>();
        List<Ability> abilities = this.abilityService.getAbilitys(partnerId, year);
        for (Ability ability : abilities) {
            map.put(ability.getId(), ability);
        }
        return map;
    }

    @RequestMapping(value={"batchedit.do"}, method={RequestMethod.GET})
    public String editsGet() {
        return "abilitydata/batchedit.ftl";
    }

    @RequestMapping(value={"/editAbility.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editGifts(AbilityDataCondition condition, int pageno) {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        Map<String, Ability> map = this.initMap(e.getCurrentPartner().getId(), condition.getYear());
        Page page = this.service.getPage(pageno, condition);
        List abilityDatas = page.getList();
        for (AbilityData abilityData : abilityDatas) {
            if (map.get(abilityData.getAbilityId()) == null) continue;
            abilityData.into(map.get(abilityData.getAbilityId()));
        }
        return page;
    }

    @RequestMapping(value={"/editAbility.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPostGrd(@Valid @RequestBody AbilityDataCondition wrap) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<AbilityData> abilityDatas = wrap.getAbilityData();
        this.service.update(abilityDatas, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("date", (Object)DateUtils.formartDate((Date)new Date(), (String)"yyyy"));
        return "abilitydata/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String addPost(Integer year, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        String url = "";
        List<IUploadFile> filelist = this.uploadFile(request, "abilitydata");
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<AbilityData> list = new ArrayList<AbilityData>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(year, list, url);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        this.service.save(list, em);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String ediGet(String id, Model model, HttpServletRequest request) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        AbilityData abilityData = this.service.get(id);
        Ability ability = this.abilityService.findById(abilityData.getAbilityId());
        if (StringUtils.isNotNull(ability)) {
            abilityData.setPrototypeName(ability.getPrototypeName());
        }
        model.addAttribute("master", (Object)abilityData);
        return "abilitydata/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody AbilityData targetData, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        targetData.fillInitData(e);
        this.service.update(targetData);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.service.delete(id);
        return "redirect:/abilitydata/list.do";
    }

    public List<AdjustStockUtil> getFileReadyExcel(Integer year, List<AbilityData> list, String url) {
        Employee emp = this.getCurrentEmployee();
        LinkedList<List<Object>> readExcelList = new LinkedList();
        readExcelList = ExcelHandle.readExcel(url);
        List<AdjustStockUtil> msglist = this.service.validate(year, readExcelList, emp, list);
        return msglist;
    }
}

