/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.AccountCondition;
import com.tcbj.crm.account.AccountService;
import com.tcbj.crm.account.EasCustDocSummaryDto;
import com.tcbj.crm.account.EasCustProductDto;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.EasCustAmountV;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.ExcelUtil;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/account"})
public class AccountController
extends BaseController {
    @Autowired
    AccountService accountService;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/myList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String myList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        List<Partner> tempList = this.clientService.getSuppliers(e.getCurrentPartner().getId());
        condition.setSupplierId(tempList.get(0).getId());
        Page page = this.accountService.getMyAccountListFromEas(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        if (tempList.size() > 0) {
            model.addAttribute("defaulSupplierId", (Object)tempList.get(0).getId());
        } else {
            model.addAttribute("defaulSupplierId", (Object)"");
        }
        return "account/myList.ftl";
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        Page page = this.accountService.getCusAccountListFromEas(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        return "account/list.ftl";
    }

    @RequestMapping(value={"/viewItme.do"}, method={RequestMethod.GET})
    public String viewItme(AccountCondition condition, Model model, HttpServletRequest request) {
        EasCustDocSummaryDto dto = new EasCustDocSummaryDto(condition.getSupplierId(), condition.getApplyerId(), condition.getYearMounth(), this.getCurrentEmployee());
        model.addAttribute("dto", (Object)dto);
        model.addAttribute("condition", (Object)condition);
        return "account/viewItmes.ftl";
    }

    private BigDecimal loadDetail(AccountCondition condition, Model model) {
        Customer customer = this.clientService.getCustomer(condition.getSupplierId(), condition.getApplyerId());
        condition.setCustomer(customer);
        EasCustAmountV easCustAmountV = this.accountService.getEasCustAmountV(condition);
        model.addAttribute("account", (Object)easCustAmountV);
        model.addAttribute("condition", (Object)condition);
        return easCustAmountV.getBeginningAmt();
    }

    @RequestMapping(value={"/viewProductItem.do"}, method={RequestMethod.GET})
    public String viewProductItem(AccountCondition condition, Model model, HttpServletRequest request) {
        EasCustProductDto dto = new EasCustProductDto(condition, this.getCurrentEmployee());
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("dto", (Object)dto);
        return "account/viewProductItem.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(AccountCondition condition, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.accountService.saveHistory(condition, me);
        if ("1".equals(condition.getDi())) {
            return this.redirect("/account/myList.do");
        }
        return this.redirect("/account/list.do");
    }

    @RequestMapping(value={"/accountHistory.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String accountHistory(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        Page page = this.accountService.getAccountList(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        return "account/history.ftl";
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET})
    public void exportExcel(AccountCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        EasCustDocSummaryDto dto = new EasCustDocSummaryDto(condition.getSupplierId(), condition.getApplyerId(), condition.getYearMounth(), this.getCurrentEmployee());
        ExcelUtil.exportExcel(response, dto, String.valueOf(condition.getYearMounth()) + "\u5bf9\u8d26\u660e\u7ec6.xls");
    }
}

