/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.AccountCondition;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.SystemOrgService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.AmountRead;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.util.PropertyManager;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.EasCustAmountV;
import com.tcbj.crm.view.EasCustDocDetailV;
import com.tcbj.crm.view.EasCustDocSummaryV;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountService")
public class AccountService {
    private static final Object EasCustAmountV = null;
    @Autowired
    BaseDao baseDao;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    SystemOrgService systemOrgService;

    private Page sendRequestToEasByPage(String url, String sql, String[] tabNames, int pageno, Map<String, Object> sqlParam) {
        HashMap<String, Object> postParam = new HashMap<String, Object>();
        HashMap<String, String> fieldType = new HashMap<String, String>();
        String countSql = "select count(*) as rowCount from (" + sql + ")";
        for (String key : sqlParam.keySet()) {
            Object o = sqlParam.get(key);
            if (!StringUtils.isNotNull(o) || !Date.class.isAssignableFrom(o.getClass())) continue;
            fieldType.put(key, "java.util.Date");
            sqlParam.put(key, DateUtils.formartDate((Date)((Date)o), (String)"yyyy-MM-dd"));
        }
        postParam.put("middleTable", tabNames);
        postParam.put("pageSize", Constant.DEFAULT_ROWS);
        postParam.put("mapParams", sqlParam);
        postParam.put("fieldType", fieldType);
        postParam.put("sql", countSql);
        List countList = (List)EasRequestHelper.getInstance().sendRequest(url, postParam);
        postParam.put("sql", sql);
        postParam.put("currentPage", pageno);
        List result = (List)EasRequestHelper.getInstance().sendRequest(url, postParam);
        Page p = new Page(null, 0, Constant.DEFAULT_ROWS, 0);
        if (Beans.isNotEmpty((Object)countList) && Beans.isNotEmpty((Object)result)) {
            int count = Integer.valueOf(((Map)countList.get(0)).get("ROWCOUNT").toString());
            p = new Page(result, pageno, Constant.DEFAULT_ROWS, count);
        }
        return p;
    }

    public Page getMyAccountListFromEas(int pageno, AccountCondition condition, Employee me) {
        return this.getCommonAccountListFromEas(pageno, condition, me, true);
    }

    public Page getCusAccountListFromEas(int pageno, AccountCondition condition, Employee me) {
        return this.getCommonAccountListFromEas(pageno, condition, me, false);
    }

    public Page getCommonAccountListFromEas(int pageno, AccountCondition condition, Employee me, boolean isMine) {
        String parent = me.getCurrentPartner().getParPartnerId();
        if (!isMine && Beans.isNotEmpty((Object)parent)) {
            return new Page(null, 0, Constant.DEFAULT_ROWS, 0);
        }
        String supplierId = "";
        supplierId = isMine ? (Beans.isNotEmpty((Object)Cache.getApplyer(me.getCurrentPartner().getId())) ? Cache.getApplyer(me.getCurrentPartner().getId()).getSupplierId() : me.getCurrentPartner().getId()) : me.getCurrentPartner().getId();
        HashMap<String, Object> sqlParam = new HashMap<String, Object>();
        String easOrgId = this.systemOrgService.getEasOrgIdByCrmOrgId(me.getCurrentPartner().getOrganizationid());
        StringBuilder sql = new StringBuilder("select bostype,area,cusnum as customerNo,cusname as customerName,pd as yearMonth,startAmt as beginningAmt,curIssAmt as currentReceiveAmt,curRecAmt as currentPaidInAmt,").append("yIssAmt as curYearReceiveAmt,yIssAmt as curYearReceiveAmt,yRecAmt as curYearPaidInAmt,endAmt as endAmount,crdAmt as creditAmt,curAmt as creditBalanceAmt").append(" from template_custbillamount where 1=1 ");
        sql.append(" and orgId = :orgId ");
        sqlParam.put("orgId", easOrgId);
        EmployeePartner par = me.getCurrentPartner();
        String orgId = par.getOrganizationid();
        if (!par.getId().equals(orgId)) {
            Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)par.getId()));
            String clientAppNo = "";
            if (partner != null) {
                clientAppNo = partner.getClientAppNo();
            }
            sql.append(" and cusnum=:cusnum ");
            sqlParam.put("cusnum", clientAppNo);
        } else {
            String sb = this.personnelservice.getFRegionsByUserId(me.getId());
            StringBuffer hql = new StringBuffer();
            hql.append("select p.clientAppNo from Partner p,Customer c where p.id = c.applyerId and p.clientAppNo is not null");
            hql.append(" and (c.bigAreaCode in ( ").append(sb).append(") or c.areaCode in ( ").append(sb).append(" ))");
            List list = this.baseDao.findEntity(hql.toString(), Object.class);
            List idList = (List)StringUtils.disList(list);
            if (idList.size() > 0) {
                String ids = StringUtils.listToString(idList, "','");
                sql.append(" and cusnum in('").append(ids).append("')");
            }
        }
        if (Beans.isNotEmpty((Object)condition.getDateStart())) {
            sql.append(" and startDate >= :startDate");
            sqlParam.put("startDate", condition.getMonthFirst());
        }
        if (Beans.isNotEmpty((Object)condition.getDateEnd())) {
            sql.append(" and endDate <= :endDate");
            sqlParam.put("endDate", condition.getMonthLast());
        }
        if (Beans.isEmpty((Object)condition.getDateStart()) && Beans.isEmpty((Object)condition.getDateEnd())) {
            sql.append(" and startDate >= :startDate");
            sqlParam.put("startDate", DateUtils.getCurrentYearFirst());
            sql.append(" and endDate <= :endDate");
            sqlParam.put("endDate", DateUtils.getCurrentYearLast());
        }
        sql.append(" order by area,cusnum,pd");
        Page p = this.sendRequestToEasByPage(String.valueOf(PropertyManager.getProperty("eas_stock")) + "queryCustBillAmount", sql.toString(), new String[]{"TEMPLATE_CUSTBILLAMOUNT"}, pageno, sqlParam);
        ArrayList<EasCustAmountV> list = new ArrayList<EasCustAmountV>();
        if (Beans.isNotEmpty((Object)p.getList())) {
            for (Object o : p.getList()) {
                Map m = (Map)o;
                EasCustAmountV account = new EasCustAmountV();
                Beans.copy((Object)account, (Map)m);
                account.setLeftAmt(account.getEndAmount());
                account.setSupplierId(supplierId);
                account.setApplyerId(this.getApplyerIdByExtCode(account.getCustomerNo()));
                list.add(account);
            }
        }
        p.setList(list);
        return p;
    }

    private String getApplyerIdByExtCode(String extCode) {
        if (Beans.isNotEmpty((Object)Cache.getCustomerByExtCode(extCode.substring(extCode.lastIndexOf(".") + 1)))) {
            return Cache.getCustomerByExtCode(extCode.substring(extCode.lastIndexOf(".") + 1)).getApplyerId();
        }
        return "";
    }

    public Page getMyAccountList(int pageno, AccountCondition condition, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)me.getCurrentPartner().getId()));
        hql.append(" from EasCustAmountV e, Customer c  where  e.applyerId = c.applyerId  ");
        hql.append(" and e.applyerId=? ");
        args.add(partner.getId());
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            hql.append(" and e.supplierId=? ");
            args.add(condition.getSupplierId());
        }
        if (Beans.isNotEmpty((Object)condition.getDateStart())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') >= ?");
            args.add(condition.getMonthFirst());
        }
        if (Beans.isNotEmpty((Object)condition.getDateEnd())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') <= ?");
            args.add(condition.getMonthLast());
        }
        if (Beans.isEmpty((Object)condition.getDateStart()) && Beans.isEmpty((Object)condition.getDateEnd())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') >= ?");
            args.add(DateUtils.getCurrentYearFirst());
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') <= ?");
            args.add(DateUtils.getCurrentYearLast());
        }
        hql.append(" order by to_date(e.yearMonth,'yyyy-mm') desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<EasCustAmountV> tempList = new ArrayList<EasCustAmountV>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            EasCustAmountV eas = (EasCustAmountV)obj[0];
            Customer customer = (Customer)obj[1];
            eas.setLeftAmt(eas.getEndAmount());
            eas.setCustomer(customer);
            tempList.add(eas);
            ++i;
        }
        page.setList(tempList);
        return page;
    }

    public List<Object[]> getAreaAmountVListByMonth(String type, String month) {
        List<Object[]> allList = this.getFactBackAmountByMonth(type, month);
        return allList;
    }

    private List<Object[]> getGiftAndMaterAmountByMonth(String type, String month) {
        String select = "";
        String group = "";
        if ("area".equals(type)) {
            select = " , cu.REGIONID ";
            group = " group by cu.REGIONID ";
        } else if ("bigArea".equals(type)) {
            select = " , cu.DISTRICTID ";
            group = " group by cu.DISTRICTID ";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(c.DOC_AMT) ");
        sql.append(select);
        sql.append(" from ");
        sql.append(" CX_EAS_CUST_DOC_SUMMARY_V c , ");
        sql.append(" CX_AWK_PRTNR_ACCOUNTLIST_VIEW cu, ");
        sql.append(" CX_EAS_CUST_DOC_DETAIL_V p, ");
        sql.append(" CX_AWK_PRODLIST_VIEW v ");
        sql.append(" where ");
        sql.append(" c.doc_num = p.doc_num and c.CUSTOMER_NUMBER = cu.PartnerId and ");
        sql.append(" v.row_id = p.product_id and ");
        sql.append(" c.doc_type = '\u6536\u6b3e\u5355'  and ");
        sql.append(" ( v.OrderProdType = 'GIFT' OR v.OrderProdType = 'NMATERIAL' ) and ");
        sql.append(" c.DOC_YYYYMM = ? ");
        sql.append(group);
        sql.append(" order by c.DOC_YYYYMM desc ");
        List list = this.baseDao.findBySql(sql.toString(), new Object[]{month});
        return list;
    }

    private List<Object[]> getFactBackAmountByMonth(String type, String month) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum(e.CURRENT_PAID_IN_AMT) ");
        String select = "";
        String group = "";
        if ("area".equals(type)) {
            select = " , c.REGIONID ";
            group = " group by c.REGIONID ";
        } else if ("bigArea".equals(type)) {
            select = " , c.DISTRICTID ";
            group = " group by c.DISTRICTID ";
        }
        hql.append(select);
        hql.append(" from CX_EAS_CUST_AMOUNT_V e , CX_AWK_PRTNR_ACCOUNTLIST_VIEW c where e.CUSTOMER_NUMBER = c.PartnerId ");
        hql.append(" and e.YEAR_MONTH = ? ");
        hql.append(group);
        hql.append(" order by e.YEAR_MONTH desc ");
        List object = this.baseDao.findBySql(hql.toString(), new Object[]{month});
        return object;
    }

    public Page getListByPage(int pageno, AccountCondition condition, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String regionStr = this.personnelService.getFRegionsByUserId(me.getId());
        hql.append(" from EasCustAmountV e , Customer c  where e.supplierId=c.supplierId and e.applyerId=c.applyerId and e.supplierId=? ");
        args.add(me.getCurrentPartner().getId());
        hql.append(" and c.areaCode in ( ").append(regionStr).append(" )");
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and e.applyerId=? ");
            args.add(condition.getApplyerId());
        }
        if (Beans.isNotEmpty((Object)condition.getDateStart())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') >= ?");
            args.add(condition.getMonthFirst());
        }
        if (Beans.isNotEmpty((Object)condition.getMonthLast())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') <= ?");
            args.add(condition.getMonthLast());
        }
        if (Beans.isEmpty((Object)condition.getDateStart()) && Beans.isEmpty((Object)condition.getDateEnd())) {
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') >= ?");
            args.add(DateUtils.getCurrentYearFirst());
            hql.append(" and to_date(e.yearMonth,'yyyy-mm') <= ?");
            args.add(DateUtils.getCurrentYearLast());
        }
        hql.append(" order by to_date(e.yearMonth,'yyyy-mm') desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<EasCustAmountV> tempList = new ArrayList<EasCustAmountV>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            EasCustAmountV eas = (EasCustAmountV)obj[0];
            Customer customer = (Customer)obj[1];
            eas.setLeftAmt(eas.getEndAmount());
            eas.setCustomer(customer);
            tempList.add(eas);
            ++i;
        }
        page.setList(tempList);
        return page;
    }

    public List<EasCustDocSummaryV> getEasCustDocSummaryVList(AccountCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from EasCustDocSummaryV e where e.supplierId=? and e.applyerId =? and e.docYyyymm=? order by e.docDate ");
        args.add(condition.getSupplierId());
        args.add(condition.getApplyerId());
        args.add(condition.getYearMounth());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), EasCustDocSummaryV.class);
    }

    public List<EasCustDocSummaryV> getAnnualEasCustDocSummaryList(String orgId, String applyerId, int year) {
        HashMap<String, Object> postParam = new HashMap<String, Object>();
        HashMap<String, String> sqlParam = new HashMap<String, String>();
        HashMap<String, String> fieldType = new HashMap<String, String>();
        String easOrgId = this.systemOrgService.getEasOrgIdByCrmOrgId(orgId);
        StringBuffer hql = new StringBuffer();
        hql.append(" select to_char(bizDate,'yyyy-mm') as docDate, ftype as docType,billId,billNum as docNum,b.fnumber as cusnum,b.FNAME_L2 cusname,a.remark as remark,sum(ISSAMT) as ISSAMT,sum(RECAMT) as RECAMT ");
        hql.append(" from TC_RPT_CRD_ISSREC2 a left join t_bd_customer b on a.CUSID = b.fid left join T_BD_GeneralAsstActType d on b.CFQUYUID = d.fid left join T_ORG_BaseUnit o on a.orgId = o.fid where 1=1 ");
        hql.append(" and bizdate >= :startDate  and bizdate <= :endDate and b.fnumber = :custNo and o.fnumber = :orgId");
        hql.append(" group by billId, billNum, b.fnumber, b.FNAME_L2, ftype, bizDate, a.remark order by bizdate");
        Date df = DateUtils.getYearFirst((int)year);
        Date dl = DateUtils.getYearLast((int)year);
        sqlParam.put("startDate", DateUtils.dateToStr((Date)df, (String)"yyyy-MM-dd"));
        sqlParam.put("endDate", DateUtils.dateToStr((Date)dl, (String)"yyyy-MM-dd"));
        sqlParam.put("custNo", Cache.getApplyer(applyerId).getExtCode());
        sqlParam.put("orgId", easOrgId);
        fieldType.put("startDate", "java.util.Date");
        fieldType.put("endDate", "java.util.Date");
        postParam.put("middleTable", new String[]{"TC_RPT_CRD_ISSREC2", "T_BD_CUSTOMER", "T_BD_GENERALASSTACTTYPE", "T_ORG_BASEUNIT"});
        postParam.put("pageSize", Constant.DEFAULT_ROWS);
        postParam.put("mapParams", sqlParam);
        postParam.put("fieldType", fieldType);
        postParam.put("sql", hql.toString());
        List result = (List)EasRequestHelper.getInstance().sendRequest(PropertyManager.getProperty("eas_accountDetail_url"), postParam);
        ArrayList<EasCustDocSummaryV> list = new ArrayList<EasCustDocSummaryV>();
        if (Beans.isNotEmpty((Object)result)) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Map o;
                Map m = o = (Map)iterator.next();
                EasCustDocSummaryV v = new EasCustDocSummaryV();
                Beans.copy((Object)v, (Map)m);
                list.add(v);
            }
        }
        return list;
    }

    public List<EasCustDocDetailV> getEasCustDocDetailVList(AccountCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from EasCustDocDetailV e where e.supplierId=? and e.applyerId =? and e.docYyyymm=? ");
        args.add(condition.getSupplierId());
        args.add(condition.getApplyerId());
        args.add(condition.getYearMounth());
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), EasCustDocDetailV.class);
        for (EasCustDocDetailV detail : list) {
            if (!StringUtils.isNotNull(detail.getProductId())) continue;
            Product product = this.productService.get(detail.getProductId());
            detail.setProduct(product);
        }
        return list;
    }

    public void saveHistory(AccountCondition condition, Employee me) {
        AmountRead amountRead = new AmountRead();
        amountRead.fillInitData(me);
        amountRead.setApplyerId(condition.getApplyerId());
        amountRead.setSupplierId(condition.getSupplierId());
        amountRead.setYearMonth(condition.getYearMounth());
        this.baseDao.save((Object)amountRead);
    }

    public Page getAccountList(int pageno, AccountCondition condition, Employee e) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from AmountRead where 1=1  and supplierId=? ");
        args.add(e.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getYearMounth())) {
            hql.append(" and yearMonth =? ");
            args.add(condition.getYearMounth());
        }
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public EasCustAmountV getEasCustAmountV(AccountCondition condition) {
        StringBuilder sql = new StringBuilder("select bostype,area,cusnum as customerNo,cusname as customerName,pd as yearMonth,startAmt as beginningAmt,curIssAmt as currentReceiveAmt,curRecAmt as currentPaidInAmt,").append("yIssAmt as curYearReceiveAmt,yIssAmt as curYearReceiveAmt,yRecAmt as curYearPaidInAmt,endAmt as endAmount,crdAmt as creditAmt,curAmt as creditBalanceAmt").append(" from template_custbillamount where 1=1 ");
        sql.append(" and pd = :yearMonth");
        sql.append(" and cusnum = :customerNo");
        HashMap<String, Object> sqlParam = new HashMap<String, Object>();
        sqlParam.put("yearMonth", condition.getYearMounth());
        sqlParam.put("customerNo", Cache.getApplyer(condition.getApplyerId()).getExtCode());
        new HashMap();
        Page p = this.sendRequestToEasByPage(String.valueOf(PropertyManager.getProperty("eas_stock")) + "queryCustBillAmount", sql.toString(), new String[]{"TEMPLATE_CUSTBILLAMOUNT"}, 1, sqlParam);
        EasCustAmountV account = new EasCustAmountV();
        if (Beans.isNotEmpty((Object)p.getList())) {
            Map m = (Map)p.getList().get(0);
            Beans.copy((Object)account, (Map)m);
            account.setLeftAmt(account.getEndAmount());
            account.setApplyerId(condition.getApplyerId());
            account.setSupplierId(condition.getSupplierId());
        }
        return account;
    }

    public List<EasCustDocDetailV> getEasCustProductList(String orgId, String docNum) {
        String easOrgId = this.systemOrgService.getEasOrgIdByCrmOrgId(orgId);
        StringBuilder sql = new StringBuilder("select fseq,orgId,billnum as docNum, bizdate as docDate,fhelpcode as productCode, materialName as productName, fmodel as productSpec,qty as quantity,price as salePrice,amount as lineAmount  from v_custproductbill where orgId =:orgId and billnum =:billnum order by fseq");
        HashMap<String, String> sqlParam = new HashMap<String, String>();
        sqlParam.put("orgId", easOrgId);
        sqlParam.put("billnum", docNum);
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("middleTable", new String[]{"V_CUSTPRODUCTBILL"});
        requestParam.put("mapParams", sqlParam);
        requestParam.put("sql", sql);
        List result = (List)EasRequestHelper.getInstance().sendRequest(PropertyManager.getProperty("eas_product_url"), requestParam);
        ArrayList<EasCustDocDetailV> list = new ArrayList<EasCustDocDetailV>();
        if (Beans.isNotEmpty((Object)result)) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Map o;
                Map m = o = (Map)iterator.next();
                EasCustDocDetailV v = new EasCustDocDetailV();
                Beans.copy((Object)v, (Map)m);
                list.add(v);
            }
        }
        return list;
    }
}

