/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.AccountCondition;
import com.tcbj.crm.account.EasCustDto;
import com.tcbj.crm.view.EasCustDocDetailV;
import com.tcbj.crm.view.Employee;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EasCustProductDto
extends EasCustDto {
    private List<EasCustDocDetailV> list;
    private Map<String, String> docTypeMap = new HashMap(){
        {
            this.put("1", "\u9500\u552e\u53d1\u7968");
            this.put("2", "\u6536\u6b3e\u5355");
        }
    };
    private String docType;
    private String docNum;

    public EasCustProductDto(AccountCondition condition, Employee employee) {
        super(condition.getSupplierId(), condition.getApplyerId(), condition.getYearMounth(), employee);
        this.docType = condition.getDocType();
        this.docNum = condition.getDocNum();
        this.initList();
    }

    private void initList() {
        String orgId = this.employee.getCurrentPartner().getOrganizationid();
        List<EasCustDocDetailV> list = this.accountService.getEasCustProductList(orgId, this.docNum);
        this.list = list;
    }

    public List<EasCustDocDetailV> getList() {
        return this.list;
    }

    public String getSummary() {
        BigDecimal sumary = new BigDecimal("0");
        for (EasCustDocDetailV detail : this.list) {
            sumary = sumary.add(detail.getLineAmount());
        }
        return sumary.stripTrailingZeros().toPlainString();
    }

    public String getDocType() {
        return this.docTypeMap.get(this.docType);
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getDocNum() {
        return this.docNum;
    }

    public void setDocNum(String docNum) {
        this.docNum = docNum;
    }

    public void setList(List<EasCustDocDetailV> list) {
        this.list = list;
    }
}

