/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.activity;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.activity.ActivityCondition;
import com.tcbj.crm.activity.ActivityService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.view.CampaignlistV;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/activity"})
public class ActivityController
extends BaseController {
    @Autowired
    ActivityService activityService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(ActivityCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        condition.setPartnerId(emp.getCurrentPartner().getId());
        Page page = this.activityService.getActivityPage(condition);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "activity/list.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(String id, Model model) {
        CampaignlistV activity = this.activityService.getActivity(id);
        model.addAttribute("activity", (Object)activity);
        model.addAttribute("RowGridData1", (Object)JSON.toJSONString(activity.getGiftList()));
        model.addAttribute("RowGridData2", (Object)JSON.toJSONString(activity.getFormList()));
        model.addAttribute("RowGridData3", (Object)JSON.toJSONString(activity.getAccountList()));
        return "activity/view.ftl";
    }
}

