/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.adjuststorage;

import com.tcbj.crm.adjuststock.AdjustStockCondition;
import com.tcbj.crm.adjuststock.AdjustStockRowCondition;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.entity.AdjustStock;
import com.tcbj.crm.entity.AdjustStockDetails;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adjustStorageService")
public class AdjustStorageService {
    @Autowired
    BaseDao baseDao;

    public void del(String id) {
        Object[] args = new Object[]{id};
        String hql = "delete AdjustStockDetails where adjustStockId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete AdjustStock where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public Page findAdjustStocks(AdjustStockCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o.id from AdjustStock o,AdjustStockDetails d where o.partnerId = ? ");
        args.add(condition.getPartnerId());
        hql.append(" and o.adjustType <> 'STORE_ADJUST' and o.id = d.adjustStockId ");
        if (StringUtils.isNotEmpty(condition.getAdjustNumber())) {
            hql.append(" and o.adjustNumber like ?");
            args.add("%" + condition.getAdjustNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            hql.append(" and o.state = ?");
            args.add(condition.getState());
        }
        if (StringUtils.isNotNull(condition.getStartDate())) {
            hql.append(" and o.createDt >= ?");
            args.add(condition.getStartDate());
        }
        if (StringUtils.isNotNull(condition.getEndDateHQL())) {
            hql.append(" and o.createDt < ?");
            args.add(condition.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(condition.getShopId())) {
            hql.append(" and d.shopId = ?");
            args.add(condition.getShopId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            hql.append(" and d.productId = ?");
            args.add(condition.getProductId());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object obj : list) {
            set.add((String)obj);
        }
        if (set.size() > 0) {
            String pf = " ";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql2 = " from AdjustStock p where p.adjustType <> 'STORE_ADJUST' and p.id in ( " + pf + ")";
            hql2 = String.valueOf(hql2) + " order by createDt asc ";
            Page page = this.baseDao.search(hql2, set.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public Page getPageAdjustStockDetailss(AdjustStockRowCondition condition) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from AdjustStockDetails a where a.adjustStockId= ? ";
        args.add(condition.getId());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql = String.valueOf(hql) + " and a.shopId = ? ";
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            hql = String.valueOf(hql) + " and a.productId = ? ";
            args.add(condition.getProductId());
        }
        return this.baseDao.search(hql, args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
    }

    public List<AdjustStockDetails> getAdjustStockDetailss(String id) {
        String hql = "from AdjustStockDetails where adjustStockId = ?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, AdjustStockDetails.class);
    }

    public AdjustStock get(String id) {
        AdjustStock obj = (AdjustStock)this.baseDao.get(AdjustStock.class, (Serializable)((Object)id));
        return obj;
    }

    private Map<String, ShopView> getShopMap(String parentId) {
        HashMap<String, ShopView> map = new HashMap<String, ShopView>();
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from ShopView where parentDealerId=?");
        args.add(parentId);
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class);
        for (ShopView shop : list) {
            map.put(shop.getShopNumber(), shop);
        }
        return map;
    }

    private Map<String, Customer> getCustomerMap(String parentId) {
        HashMap<String, Customer> map = new HashMap<String, Customer>();
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? ");
        Object[] args = new Object[]{parentId};
        List list = this.baseDao.findEntity(sb.toString(), args, Customer.class);
        for (Customer customer : list) {
            map.put(customer.getApplyerCode(), customer);
        }
        return map;
    }

    private Map<String, Storage> getStorageMap() {
        HashMap<String, Storage> storageMap = new HashMap<String, Storage>();
        StringBuffer hql = new StringBuffer();
        hql.append(" from Storage s");
        List list = this.baseDao.findEntity(hql.toString(), Storage.class);
        for (Storage storage : list) {
            storageMap.put(String.valueOf(storage.getSupplierNo()) + "_" + storage.getStorageCode(), storage);
        }
        return storageMap;
    }

    private Map<String, Product> getProductMap(String partnerId) {
        StringBuffer hql = new StringBuffer();
        HashMap<String, Product> map = new HashMap<String, Product>();
        hql.append(" from Product a ,PartnerProductREL c where a.id=c.productId and c.supplierId=? ");
        List list = this.baseDao.findEntity(hql.toString(), new Object[]{partnerId}, Object[].class);
        for (Object[] objs : list) {
            Product product = (Product)objs[0];
            PartnerProductREL pprel = (PartnerProductREL)objs[1];
            map.put(String.valueOf(pprel.getPartnerNo()) + "_" + product.getNo(), product);
        }
        return map;
    }

    public List<AdjustStockUtil> validate(List<List<Object>> readExcelList, Employee emp, List<AdjustStockDetails> list) {
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        Map<String, ShopView> shopMap = this.getShopMap(emp.getCurrentPartner().getId());
        Map<String, Customer> customerMap = this.getCustomerMap(emp.getCurrentPartner().getId());
        Map<String, Storage> storageMap = this.getStorageMap();
        Map<String, Product> productMap = this.getProductMap(emp.getCurrentPartner().getId());
        int j = 0;
        while (j < readExcelList.size()) {
            List<Object> data = readExcelList.get(j);
            String result = null;
            String message = null;
            AdjustStockDetails adjustStockDetails = new AdjustStockDetails();
            int i = 0;
            while (i < data.size()) {
                switch (i) {
                    case 0: {
                        message = this.validateShop(data.get(i), shopMap, customerMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97/\u5ba2\u6237\u7f16\u53f7 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setShopId(customerMap.get(data.get(i).toString()).getApplyerId());
                        break;
                    }
                    case 1: {
                        message = this.validateStore(data.get(i), (String)data.get(0), storageMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ed3\u5e93\u7f16\u53f7 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setStorageId(storageMap.get(String.valueOf((String)data.get(0)) + "_" + (String)data.get(i)).getId());
                        break;
                    }
                    case 2: {
                        message = this.validateProduct(data.get(i), (String)data.get(0), productMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u7f16\u7801 \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setProductId(productMap.get(String.valueOf((String)data.get(0)) + "_" + (String)data.get(i)).getId());
                        break;
                    }
                    case 3: {
                        adjustStockDetails.setProductBatch((String)data.get(i));
                        break;
                    }
                    case 4: {
                        message = ValidataUtils.validataDoubleOrNull((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ef7\u683c \uff1a" + message;
                            break;
                        }
                        if (data.get(i) == null || "".equals(String.valueOf(data.get(i)).trim())) {
                            adjustStockDetails.setPrice(0.0);
                            break;
                        }
                        adjustStockDetails.setPrice(Double.parseDouble(String.valueOf(data.get(i)).trim()));
                        break;
                    }
                    case 5: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u6570\u91cf \uff1a" + message;
                            break;
                        }
                        adjustStockDetails.setAdjustQuantity(Double.valueOf(String.valueOf(data.get(i)).trim()));
                        break;
                    }
                }
                ++i;
            }
            if (result != null) {
                msglist.add(new AdjustStockUtil("\u7b2c" + (j + 2) + "\u884c:" + result));
            }
            list.add(adjustStockDetails);
            ++j;
        }
        return msglist;
    }

    private String validateProduct(Object object, String id, Map<String, Product> productMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (productMap.get(String.valueOf(id) + "_" + code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    private String validateStore(Object object, String id, Map<String, Storage> storageMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (storageMap.get(String.valueOf(id) + "_" + code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    private String validateShop(Object object, Map<String, ShopView> shopMap, Map<String, Customer> customerMap) {
        if (object == null || "".equals(String.valueOf(object).trim())) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String code = (String)object;
        if (shopMap.get(code) == null && customerMap.get(code) == null) {
            return "\u975e\u6cd5\u7684\u6570\u636e" + code;
        }
        return null;
    }

    public boolean validateFileName(String partnerId, String fileName) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from AdjustStock where adjustType <> 'STORE_ADJUST' and partnerId =? and fileName =? ");
        AdjustStock adjustStock = (AdjustStock)this.baseDao.findFirstEntity(hql.toString(), new Object[]{partnerId, fileName}, AdjustStock.class);
        return StringUtils.isNotNull(adjustStock);
    }
}

