/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allot;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.allot.QyAllotCondition;
import com.tcbj.crm.allot.QyAllotRowCondition;
import com.tcbj.crm.allot.QyAllotService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.entity.QyAllot;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/allot"})
public class QyAllotController
extends BaseController {
    @Autowired
    QyAllotService service;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) {
        QyAllot allot = new QyAllot();
        model.addAttribute("master", (Object)allot);
        return "allot/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String addPost(@ModelAttribute(value="cxqyallot") QyAllot cxqyallot, @RequestParam(value="mediaFile", required=false) MultipartFile file, BindingResult errors, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Employee e = this.getCurrentEmployee();
        String rtn = null;
        boolean isName = this.service.validateName(cxqyallot.getAllotName(), null, e.getCurrentPartner().getId());
        if (isName) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(cxqyallot.getAllotName()) + " \u8be5\u540d\u79f0\u5728\u672c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6362\u5176\u4ed6\u540d\u79f0"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        List<AdjustStockUtil> msglist = this.getFileReadExcel(list, request);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        cxqyallot.setSupplierId(e.getCurrentPartner().getId());
        cxqyallot.fillInitData(e);
        cxqyallot.setCxQyAllotRowList(list);
        this.service.save(cxqyallot, e);
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.GET})
    public String savePet(Model model, HttpServletRequest request) {
        QyAllot allot = new QyAllot();
        model.addAttribute("master", (Object)allot);
        return "allot/save.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result savePost(@Valid @RequestBody QyAllot cxqyallot, BindingResult errors, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.validateName(cxqyallot.getAllotName(), null, me.getCurrentPartner().getId());
        this.validateOnly(cxqyallot.getCxQyAllotRowList(), me.getCurrentPartner().getId());
        this.service.save(cxqyallot, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, HttpServletRequest request, QyAllotCondition condition) {
        Employee e = this.getCurrentEmployee();
        condition.setSupplierId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        model.addAttribute("page", (Object)this.service.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "allot/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        QyAllot cxqyallot = this.service.get(id);
        model.addAttribute("master", (Object)cxqyallot);
        return "allot/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody QyAllot cxqyallot) throws Exception {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(cxqyallot.getDelIds())) {
            String[] stringArray = cxqyallot.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.deleteRow(id);
                ++n2;
            }
        }
        this.service.update(cxqyallot, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id) {
        this.service.delete(id);
        return "redirect:/allot/list.do";
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        QyAllot cxqyallot = this.service.get(id);
        model.addAttribute("master", (Object)cxqyallot);
        model.addAttribute("JSONString", (Object)JSON.toJSONString(cxqyallot.getCxQyAllotRowList()));
        return "allot/look.ftl";
    }

    private List<AdjustStockUtil> getFileReadExcel(List<QyAllotRow> list, HttpServletRequest request) {
        List<IUploadFile> filelist = this.uploadFile(request, "allot");
        List<List<Object>> readExcelList = new LinkedList<List<Object>>();
        String fileUrl = "";
        if (filelist.size() > 0) {
            fileUrl = filelist.get(0).getRealPath();
            readExcelList = ExcelHandle.readExcel(fileUrl);
        }
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        this.validateExcel(readExcelList, list, msglist);
        return msglist;
    }

    public void validateEmpty(List<List<Object>> readExcelList, List<AdjustStockUtil> msglist) {
        int j = 1;
        for (List<Object> objectslist : readExcelList) {
            String message = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            boolean is = false;
            if ("".equals(objectslist.get(0).toString()) || objectslist.get(0).toString() == null) {
                message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(1).toString()) || objectslist.get(1).toString() == null) {
                message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(2).toString()) || objectslist.get(2).toString() == null) {
                message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            } else if (!StringUtils.match(objectslist.get(2).toString())) {
                message = String.valueOf(message) + "\u9650\u8d2d\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57;";
                is = true;
            }
            if (!is) continue;
            AdjustStockUtil asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
    }

    public void validateExcel(List<List<Object>> readExcelList, List<QyAllotRow> list, List<AdjustStockUtil> msglist) {
        AdjustStockUtil asu;
        Employee em = this.getCurrentEmployee();
        this.validateEmpty(readExcelList, msglist);
        if (msglist.size() > 0) {
            return;
        }
        int j = 1;
        String message = "\u5728\u7b2c" + j + "\u884c\uff0c";
        for (List<Object> objectslist : readExcelList) {
            ++j;
            QyAllotRow adju = new QyAllotRow();
            boolean is = false;
            Customer customer = this.clientService.getCodeAndSupplier(objectslist.get(0).toString(), em.getCurrentPartner().getId());
            if (customer == null) {
                message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u5c5e\u4e8e\u672c\u7ec4\u7ec7;";
                is = true;
            } else {
                adju.setApplyerId(customer.getApplyerId());
                Product product = this.productService.getCodeAndProduct(objectslist.get(1).toString(), customer.getApplyerId());
                if (product != null) {
                    adju.setProductId(product.getId());
                    adju.setUnits(product.getUnitName());
                    adju.setNorms(product.getSpec());
                } else {
                    message = String.valueOf(message) + "\u8be5\u4ea7\u54c1\u7f16\u53f7\u4e0d\u5c5e\u4e8e" + objectslist.get(0).toString() + "\u7f16\u53f7\u7684\u5ba2\u6237;";
                    is = true;
                }
            }
            if ("".equals(objectslist.get(2).toString())) {
                adju.setQuotaNumber(0.0);
            } else {
                adju.setQuotaNumber(Double.valueOf(objectslist.get(2).toString()));
            }
            if (is) {
                asu = new AdjustStockUtil();
                asu.setMessage(message);
                msglist.add(asu);
            }
            list.add(adju);
        }
        if (msglist.size() > 0) {
            return;
        }
        Map<String, String> map = this.service.getQyAllotRows(em.getCurrentPartner().getId());
        for (List list2 : readExcelList) {
            if (map.get(String.valueOf(list2.get(0).toString()) + "_" + list2.get(1).toString()) == null) continue;
            message = String.valueOf(list2.get(0).toString()) + "\u7684" + list2.get(1).toString() + "\u4ea7\u54c1\u5728\u672c\u7ec4\u7ec7\u6709\u91cd\u590d\u6570\u636e\uff01";
            AdjustStockUtil asu2 = new AdjustStockUtil();
            asu2.setMessage(message);
            msglist.add(asu2);
        }
        if (msglist.size() > 0) {
            return;
        }
        List<Object[]> list3 = this.productService.getPartnerProducts(em.getCurrentPartner().getId());
        HashMap<String, Double> productsMap = new HashMap<String, Double>();
        for (Object[] objects : list3) {
            if (StringUtils.isNotNull(em.getCurrentPartner().getParPartnerId())) {
                productsMap.put(((Product)objects[0]).getId(), ((PartnerProduct)objects[1]).getDivideQuantity());
                continue;
            }
            productsMap.put(((Product)objects[0]).getId(), ((Product)objects[0]).getMinUnit());
        }
        j = 1;
        for (QyAllotRow allotRow : list) {
            ++j;
            allotRow.setMinUnit((Double)productsMap.get(allotRow.getProductId()));
            if (allotRow.getMinUnit() == null || allotRow.getMinUnit() == 0.0 || allotRow.getQuotaNumber() % allotRow.getMinUnit() == 0.0) continue;
            message = "\u7b2c" + j + "\u884c\u7684\u914d\u8d27\u6570\u91cf\u5fc5\u987b\u662f\u4ea7\u54c1\u6700\u5c0f\u5305\u88c5\u6570\u7684\u500d\u6570\uff01";
            asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
        if (msglist.size() > 0) {
            return;
        }
    }

    public void validateOnly(List<QyAllotRow> rowList, String partnerId) {
        Map<String, String> map = this.service.getQyAllotRows(partnerId);
        for (QyAllotRow qyAllotRow : rowList) {
            if (map.get(String.valueOf(qyAllotRow.getApplyerNo()) + "_" + qyAllotRow.getProductNo()) == null) continue;
            throw new AppException("0010", String.valueOf(qyAllotRow.getApplyerName()) + "\u7684" + qyAllotRow.getProductName() + "\u4ea7\u54c1\u5728\u672c\u7ec4\u7ec7\u6709\u91cd\u590d\u6570\u636e\uff01");
        }
    }

    public void checkShopNumber(List<AdjustStockUtil> msglist, Object ages, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        if ("".equals(ages) || ages == null) {
            util.setMessage(str);
            msglist.add(util);
        }
    }

    public void setMessage(List<AdjustStockUtil> msglist, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        util.setMessage(str);
        msglist.add(util);
    }

    public void packageMap(Map<String, List<QyAllotRow>> map, List<QyAllotRow> allotRows) {
        for (QyAllotRow qyAllotRow : allotRows) {
            List<QyAllotRow> nslist = map.get(qyAllotRow.getApplyerId());
            if (nslist == null) {
                nslist = new ArrayList<QyAllotRow>();
                map.put(qyAllotRow.getApplyerId(), nslist);
            }
            nslist.add(qyAllotRow);
        }
    }

    public void validateName(String name, String id, String partnerId) {
        boolean isName = this.service.validateName(name, id, partnerId);
        if (isName) {
            throw new AppException("1304", name);
        }
    }

    @RequestMapping(value={"/getQyAllotRows.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getQyAllotRows(QyAllotRowCondition condition) {
        Employee em = this.getCurrentEmployee();
        condition.setUserId(em.getId());
        condition.setSupplierId(em.getCurrentPartner().getId());
        Page page = this.service.getPageQyAllotRows(condition);
        QyAllot qyAllot = this.service.getQyAllotById(condition.getId());
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        List obgs = page.getList();
        for (QyAllotRow q : obgs) {
            PartnerProduct p = this.productService.getPartnerProduct(qyAllot.getSupplierId(), q.getProductId());
            if (StringUtils.isNotNull(p)) {
                q.setMinUnit(p.getDivideQuantity());
            } else {
                q.setMinUnit(1.0);
            }
            list.add(q);
        }
        page.setList(list);
        return page;
    }
}

