/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allot;

import com.tcbj.crm.allot.QyAllotCondition;
import com.tcbj.crm.allot.QyAllotRowCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.QyAllot;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qyAllotService")
public class QyAllotService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public QyAllot get(String id) {
        QyAllot q = (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
        Object[] args = new Object[]{q.getId()};
        List list = this.baseDao.findEntity("from QyAllotRow where allotId = ?", args, QyAllotRow.class);
        q.setCxQyAllotRowList(list);
        return q;
    }

    public QyAllot getQyAllotById(String id) {
        return (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
    }

    public void save(QyAllot obj, Employee me) {
        obj.fillInitData(me);
        obj.setSupplierId(me.getCurrentPartner().getId());
        this.baseDao.save((Object)obj);
        try {
            List<QyAllotRow> list = obj.getCxQyAllotRowList();
            for (QyAllotRow cxQyAllotRow : list) {
                cxQyAllotRow.fillInitData(me);
                cxQyAllotRow.setAllotId(obj.getId());
            }
            this.baseDao.save(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Page getList(int pageno, QyAllotCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o.id from QyAllot o,QyAllotRow r where o.supplierId = ?");
        args.add(condition.getSupplierId());
        hql.append(" and o.id = r.allotId ");
        if (StringUtils.isNotEmpty(condition.getAllotName())) {
            hql.append(" and o.allotName like ? ");
            args.add("%" + condition.getAllotName() + "%");
        }
        if (StringUtils.isNotNull(condition.getStartDate())) {
            hql.append(" and o.startDate >= ?");
            args.add(condition.getStartDate());
        }
        if (StringUtils.isNotNull(condition.getEndDateHQL())) {
            hql.append(" and o.startDate < ?");
            args.add(condition.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and r.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            hql.append(" and r.productId = ? ");
            args.add(condition.getProductId());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object obj : list) {
            set.add((String)obj);
        }
        if (set.size() > 0) {
            String pf = " ";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql2 = " from QyAllot p where p.id in ( " + pf + ")";
            hql2 = String.valueOf(hql2) + " order by createDt desc ";
            Page page = this.baseDao.search(hql2, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public void update(QyAllot obj, Employee me) {
        obj.fillInitData(me);
        obj.setSupplierId(me.getCurrentPartner().getId());
        this.baseDao.update((Object)obj);
        try {
            List<QyAllotRow> list = obj.getCxQyAllotRowList();
            for (QyAllotRow cxQyAllotRow : list) {
                cxQyAllotRow.setAllotId(obj.getId());
                cxQyAllotRow.fillInitData(me);
                if (StringUtils.isNotEmpty(cxQyAllotRow.getId())) {
                    this.baseDao.update((Object)cxQyAllotRow);
                    continue;
                }
                this.baseDao.save((Object)cxQyAllotRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(String id) {
        QyAllot qyAllot = (QyAllot)this.baseDao.get(QyAllot.class, (Serializable)((Object)id));
        qyAllot.setEndDate(DateUtils.now());
    }

    public void deleteRow(String id) {
        this.baseDao.deleteById(QyAllotRow.class, (Serializable)((Object)id));
    }

    public List<QyAllotRow> getList(String applyerId, String supplierId, Date findDate) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer();
        hql.append("from QyAllot p,QyAllotRow a where a.allotId = p.id ");
        if (StringUtils.isNotEmpty(supplierId)) {
            hql.append(" and p.supplierId = ?");
            args.add(supplierId);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            hql.append(" and a.applyerId = ?");
            args.add(applyerId);
        }
        hql.append(" and p.startDate <= ? and nvl(p.endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        hql.append(" order by p.startDate asc ");
        List objects = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        for (Object[] obj : objects) {
            QyAllotRow qyrow = (QyAllotRow)obj[1];
            QyAllot qy = (QyAllot)obj[0];
            qyrow.setStartDate(qy.getStartDate());
            qyrow.setEndDate(qy.getEndDate());
            list.add(qyrow);
        }
        return list;
    }

    public Page getPageQyAllotRows(QyAllotRowCondition condition) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regions = this.personnelService.getFRegionsByUserId(condition.getUserId());
        sb.append("from QyAllotRow q,Customer c where q.allotId=? ");
        args.add(condition.getId());
        sb.append(" and c.applyerId = q.applyerId ");
        sb.append(" and (c.bigAreaCode in ( ");
        sb.append(regions);
        sb.append(") or c.areaCode in ( ");
        sb.append(regions);
        sb.append(" ))");
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sb.append(" and q.applyerId=? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getProductId())) {
            sb.append(" and q.productId=? ");
            args.add(condition.getProductId());
        }
        Page page = this.baseDao.search(sb.toString(), args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
        ArrayList<QyAllotRow> list = new ArrayList<QyAllotRow>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((QyAllotRow)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public Map<String, String> getQyAllotRows(String partnerId) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer hql = new StringBuffer();
        hql.append("from QyAllot p,QyAllotRow a where a.allotId = p.id ");
        if (StringUtils.isNotEmpty(partnerId)) {
            hql.append(" and p.supplierId = ?");
            args.add(partnerId);
        }
        hql.append(" and p.startDate <= ? and nvl(p.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        List objects = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object[] obj : objects) {
            QyAllotRow row = (QyAllotRow)obj[1];
            QyAllot allot = (QyAllot)obj[0];
            map.put(String.valueOf(row.getApplyerNo()) + "_" + row.getProductNo(), allot.getAllotName());
        }
        return map;
    }

    public boolean validateName(String name, String id, String partnerId) {
        QyAllot qyAllot;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        sb.append("from QyAllot where supplierId = ? and allotName = ? ");
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            sb.append(" and id != ? ");
            args.add(id);
        }
        return StringUtils.isNotNull(qyAllot = (QyAllot)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), QyAllot.class));
    }
}

