/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.allotorder;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.allotorder.AllotMainCondition;
import com.tcbj.crm.allotorder.AllotMainService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.AuditService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.AllotDetails;
import com.tcbj.crm.entity.AllotMain;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/allotorder"})
public class AllotMainController
extends BaseController {
    @Autowired
    AllotMainService service;
    @Autowired
    AuditService auditService;

    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") AllotMainCondition condition, Model model) {
        this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(condition.getState())) {
            condition.getStates().add(condition.getState());
        }
        this.findAllotMains(condition, "order by state,lastUpdateDt ", model);
        return "allotorder/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadAllotMain(id, model);
        EmployeePartner partner = this.getCurrentEmployee().getCurrentPartner();
        this.getOrg(model, partner);
        model.addAttribute("partner", (Object)partner);
        return "allotorder/apply.ftl";
    }

    private void getOrg(Model model, EmployeePartner partner) {
        List<ShopView> shopList = this.service.getShopList(partner, 1);
        model.addAttribute("shopList", shopList);
    }

    private void getStorageList(Model model, EmployeePartner partner) {
        String partnerId = partner.getId();
        List<Storage> storageList = this.service.getAllotStorage(partnerId);
        model.addAttribute("storageList", storageList);
    }

    @ResponseBody
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    public Result apply_do(@Valid @RequestBody AllotMain allotMain, BindingResult errors, HttpServletRequest request) {
        AllotMain oldAllotMain;
        Employee me = this.getCurrentEmployee();
        allotMain.fillInitData(me);
        if (StringUtils.isNotEmpty(allotMain.getId()) && !(oldAllotMain = this.service.getSimpleAllotMain(allotMain.getId())).getState().equals(TCBJEnum.AuditState.draft.getValue())) {
            allotMain.setState(oldAllotMain.getState());
        }
        if (allotMain.isToAudit()) {
            allotMain.setState(TCBJEnum.AuditState.audit.getValue());
        } else if (allotMain.isToApprove()) {
            allotMain.setState(TCBJEnum.AuditState.approve.getValue());
        }
        for (AllotDetails item : allotMain.getAllotDetailss()) {
            item.fillInitData(me);
        }
        this.service.saveOrUpdate(allotMain);
        if (allotMain.isToAudit() || allotMain.isToApprove()) {
            AuditInfo auditInfo = new AuditInfo(allotMain.getId(), "AllotMain", allotMain.getState(), null, me.getId(), DateUtils.now());
            this.auditService.add(auditInfo);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        this.loadAllotMain(id, model);
        return "allotorder/approve.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    public Result approve_do(@Valid @RequestBody AuditInfo auditInfo, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.service.getSimpleAllotMain(auditInfo.getBusinessId());
        if (auditInfo.isAgreen()) {
            this.service.updateState(auditInfo.getBusinessId(), TCBJEnum.AuditState.approvePass.getValue());
        } else {
            this.service.updateState(auditInfo.getBusinessId(), TCBJEnum.AuditState.approveNoPass.getValue());
        }
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessType("AllotMain");
        this.auditService.add(auditInfo);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/approves.do"})
    public String approves(@ModelAttribute(value="condition") AllotMainCondition condition, Model model) {
        this.getCurrentEmployee();
        if (condition.getState() == null || condition.getState().equals("dealing")) {
            condition.getStates().add(TCBJEnum.AuditState.approve.getValue());
        } else if (condition.getState().equals("dealed")) {
            condition.getStates().add(TCBJEnum.AuditState.approvePass.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        } else {
            condition.getStates().add(TCBJEnum.AuditState.approve.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approvePass.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        }
        this.findAllotMains(condition, "order by state", model);
        return "allotorder/approves.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadAllotMain(id, model);
        return "allotorder/audit.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    public Result audit_do(@Valid @RequestBody AllotMain allotMain, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        allotMain.fillInitData(me);
        this.service.getSimpleAllotMain(allotMain.getId());
        if (allotMain.isToApprove()) {
            allotMain.setState(TCBJEnum.AuditState.approve.getValue());
        } else {
            allotMain.setState(TCBJEnum.AuditState.auditNoPass.getValue());
        }
        for (AllotDetails item : allotMain.getAllotDetailss()) {
            item.fillInitData(me);
        }
        this.service.saveOrUpdate(allotMain);
        AuditInfo auditInfo = new AuditInfo(allotMain.getId(), "AllotMain", allotMain.getState(), null, me.getId(), DateUtils.now());
        this.auditService.add(auditInfo);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/audits.do"})
    public String audits(@ModelAttribute(value="condition") AllotMainCondition condition, Model model) {
        this.getCurrentEmployee();
        if (condition.getState() == null || condition.getState().equals("dealing")) {
            condition.getStates().add(TCBJEnum.AuditState.audit.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        } else if (condition.getState().equals("dealed")) {
            condition.getStates().add(TCBJEnum.AuditState.auditNoPass.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approve.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approvePass.getValue());
        } else {
            condition.getStates().add(TCBJEnum.AuditState.audit.getValue());
            condition.getStates().add(TCBJEnum.AuditState.auditNoPass.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approve.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approvePass.getValue());
            condition.getStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        }
        this.findAllotMains(condition, "order by state,lastUpdateDt ", model);
        return "allotorder/audits.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        this.service.del(id);
        return "redirect:applys.do?conscope=session";
    }

    private void findAllotMains(AllotMainCondition condition, String orderby, Model model) {
        condition = (AllotMainCondition)this.wrapCondition(condition, "AllotMain");
        Employee me = this.getCurrentEmployee();
        Page page = this.service.findAllotMains(condition);
        model.addAttribute("me", (Object)me);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
    }

    private AllotMain loadAllotMain(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        AllotMain allotMain = null;
        if (StringUtils.isEmpty(id)) {
            allotMain = new AllotMain();
            allotMain.fillInitData(me);
        } else {
            allotMain = this.service.get(id);
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("allotMain", (Object)allotMain);
        model.addAttribute("allotDetailsItems", (Object)JSON.toJSONString(allotMain.getAllotDetailss()));
        return allotMain;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        this.loadAllotMain(id, model);
        model.addAttribute("auditInfos", this.auditService.find(id));
        return "allotorder/view.ftl";
    }
}

