/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.aplfine;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Aplfine;
import com.tcbj.crm.entity.AplfineHis;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="aplfineService")
public class AplfineService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public Aplfine get(String id) {
        return (Aplfine)this.baseDao.get(Aplfine.class, (Serializable)((Object)id));
    }

    public void save(Aplfine obj) {
        this.baseDao.save((Object)obj);
    }

    public List<Object[]> getserialList(AplfineCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("from AplfineHis a,Aplfine b where a.aplfineId=b.id and b.id=? order by a.createDt ");
        return this.baseDao.findEntity(HQL.toString(), new Object[]{condition.getId()}, Object[].class);
    }

    public Page getList(int pageno, AplfineCondition condition) {
        String regions = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Aplfine o,Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and o.partnerId=? and o.applyerId=a.applyerId and a.supplierId=o.partnerId ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(condition.getEm().getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getFineNumber())) {
            HQL.append(" and o.fineNumber like ? ");
            args.add("%" + condition.getFineNumber() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        HQL.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        List list = page.getList();
        ArrayList<Aplfine> aplfines = new ArrayList<Aplfine>();
        for (Object[] obj : list) {
            aplfines.add((Aplfine)obj[0]);
        }
        page.setList(aplfines);
        return page;
    }

    public List<Aplfine> getList(String orgid, String date) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Aplfine o where partnerId = ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(orgid);
        if (StringUtils.isNotEmpty(date)) {
            HQL.append(" and o.fineNumber like ? ");
            args.add("%" + date + "%");
        }
        HQL.append(" order by lastUpdateDt desc ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Aplfine.class);
    }

    public void update(Aplfine obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        Aplfine aplfine = (Aplfine)this.baseDao.get(Aplfine.class, (Serializable)((Object)id));
        aplfine.setEndDate(DateUtils.now());
        this.baseDao.update((Object)aplfine);
    }

    public List<Aplfine> getlist(String supplierId, String applyerId, Date findDate) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Aplfine o where partnerId = ? and applyerId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(supplierId);
        args.add(applyerId);
        HQL.append(" and startDate <= ? and nvl(endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        HQL.append(" order by lastUpdateDt ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Aplfine.class);
    }

    public double getAplfineValue(String supplierId, String applyerId, Date findDate) {
        List<Aplfine> list = this.getlist(supplierId, applyerId, findDate);
        double sum = 0.0;
        for (Aplfine a : list) {
            sum = MathUtils.add((Double)sum, (Double)MathUtils.sub((Double)a.getFineMoney(), (Double)a.getWithheldMoney()));
        }
        return sum;
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from AplfineHis r where r.orderId = ? and r.state = '1' ", new Object[]{orderId}, AplfineHis.class);
        for (AplfineHis r : list) {
            String rebateId = r.getAplfineId();
            Aplfine aplfine = (Aplfine)this.baseDao.get(Aplfine.class, (Serializable)((Object)rebateId));
            if (aplfine != null) {
                this.baseDao.executeHQL(" update Aplfine set withheldMoney = ? where id = ?", new Object[]{MathUtils.sub((Double)aplfine.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())), aplfine.getId()});
            }
            this.baseDao.executeHQL(" update AplfineHis set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate) {
        double useed = 0.0;
        List<Aplfine> list = this.getlist(supplierId, applyerId, orderDate);
        for (Aplfine r : list) {
            if (useed == useSum) break;
            double c = MathUtils.format((Double)orderSum);
            if (c > MathUtils.sub((Double)r.getFineMoney(), (Double)r.getWithheldMoney())) {
                c = MathUtils.sub((Double)r.getFineMoney(), (Double)r.getWithheldMoney());
            }
            if (MathUtils.add((Double)useed, (Double)c) > useSum) {
                c = MathUtils.sub((Double)useSum, (Double)useed);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)c));
            useed = MathUtils.add((Double)useed, (Double)c);
            this.baseDao.update((Object)r);
            AplfineHis aplfineHis = new AplfineHis();
            operaterId = operaterId == null ? "0-1" : operaterId;
            aplfineHis.setCreatorId(operaterId);
            aplfineHis.setLastUpdatorId(operaterId);
            aplfineHis.setOrderId(orderId);
            aplfineHis.setOrderNo(orderNo);
            aplfineHis.setAplfineId(r.getId());
            aplfineHis.setWithheldMoney(String.valueOf(c));
            aplfineHis.setState(1);
            this.baseDao.save((Object)aplfineHis);
        }
    }
}

