/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.base;

import com.tcbj.crm.base.BaseCondition;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.base.SystemError;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.upload.UploadFileImpl;
import com.tcbj.crm.util.ServletContextUtils;
import com.tcbj.crm.view.Employee;
import com.tcbj.spring.mvc.convert.NumberConvertEditor;
import com.tcbj.util.SessionUtils;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class BaseController {
    @InitBinder
    protected void initBaseBinder(WebDataBinder binder) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)sdf, true));
        binder.registerCustomEditor(Byte.TYPE, (PropertyEditor)new NumberConvertEditor(Byte.class));
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new NumberConvertEditor(Byte.TYPE));
        binder.registerCustomEditor(Short.TYPE, (PropertyEditor)new NumberConvertEditor(Short.TYPE));
        binder.registerCustomEditor(Short.class, (PropertyEditor)new NumberConvertEditor(Short.class));
        binder.registerCustomEditor(Integer.TYPE, (PropertyEditor)new NumberConvertEditor(Integer.TYPE));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new NumberConvertEditor(Integer.class));
        binder.registerCustomEditor(Long.TYPE, (PropertyEditor)new NumberConvertEditor(Long.TYPE));
        binder.registerCustomEditor(Long.class, (PropertyEditor)new NumberConvertEditor(Long.class));
        binder.registerCustomEditor(Float.TYPE, (PropertyEditor)new NumberConvertEditor(Float.TYPE));
        binder.registerCustomEditor(Float.class, (PropertyEditor)new NumberConvertEditor(Float.class));
        binder.registerCustomEditor(Double.TYPE, (PropertyEditor)new NumberConvertEditor(Double.TYPE));
        binder.registerCustomEditor(Double.class, (PropertyEditor)new NumberConvertEditor(Double.class));
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new NumberConvertEditor(BigDecimal.class));
        binder.registerCustomEditor(BigInteger.class, (PropertyEditor)new NumberConvertEditor(BigInteger.class));
    }

    protected Employee getCurrentEmployee() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return SessionUtils.getEmployee(request);
    }

    protected BaseCondition wrapCondition(BaseCondition con, String key) {
        if (con == null || StringUtils.isEmpty((Object)con.getConscope())) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            Object obj = request.getSession().getAttribute(key);
            if (obj != null) {
                request.getSession().removeAttribute(key);
            }
        } else if (con.getConscope().equals("new")) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            request.getSession().setAttribute(key, (Object)con);
        } else if (con.getConscope().equals("session")) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            Object obj = request.getSession().getAttribute(key);
            if (obj == null) {
                return con;
            }
            return (BaseCondition)obj;
        }
        return con;
    }

    protected Result getErrorResult(BindingResult errors) {
        Result result = new Result();
        result.setStatus("-1");
        ApplicationContext ac = ServletContextUtils.getContext();
        SystemError se = new SystemError(SystemError.FIELD_ERROR);
        List fes = errors.getFieldErrors();
        for (FieldError fe : fes) {
            String msg = ac.getMessage(fe.getCode(), null, null);
            se.addInfo(fe.getField(), msg);
        }
        result.setError(se);
        return result;
    }

    protected Result getErrorResult(Object data) {
        Result result = new Result();
        SystemError se = new SystemError(SystemError.FIELD_ERROR);
        se.addInfo("e", data.toString());
        result.setStatus("-1");
        result.setError(se);
        return result;
    }

    protected Result getSuccessResult(Object data) {
        Result result = new Result();
        result.setStatus("200");
        result.setData(data);
        return result;
    }

    protected String redirect(String path) {
        return "redirect:" + path;
    }

    protected Map<String, IUploadFile> uploadFileToMap(HttpServletRequest request, String path) {
        HashMap<String, IUploadFile> map = new HashMap<String, IUploadFile>();
        List<IUploadFile> list = this.uploadFile(request, path);
        for (IUploadFile file : list) {
            map.put(file.getFieldName(), file);
        }
        return map;
    }

    protected List<IUploadFile> uploadFile(HttpServletRequest request, String path) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map map = multipartRequest.getFileMap();
        Set keys = map.keySet();
        Iterator it = keys.iterator();
        ArrayList<IUploadFile> result = new ArrayList<IUploadFile>();
        while (it.hasNext()) {
            File f;
            String newName;
            String fileType;
            MultipartFile file;
            String filedName;
            block15: {
                filedName = (String)it.next();
                file = (MultipartFile)map.get(filedName);
                if (file.getSize() == 0L) continue;
                String fileName = file.getOriginalFilename();
                fileType = "";
                if (fileName.lastIndexOf(".") > 0) {
                    fileType = fileName.substring(fileName.lastIndexOf("."));
                }
                newName = new StringBuffer(path).append("/").append(UUID.randomUUID().toString()).append(fileType).toString();
                File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!(f = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + newName)).exists()) {
                    OutputStream out = null;
                    try {
                        try {
                            f.createNewFile();
                            out = new BufferedOutputStream(new FileOutputStream(f));
                            out.write(file.getBytes());
                            out.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                out.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            UploadFileImpl uf = new UploadFileImpl();
            uf.setName(file.getOriginalFilename());
            uf.setFieldName(filedName);
            uf.setRealPath(f.getPath());
            uf.setSize(file.getSize());
            uf.setWebPath(newName);
            uf.setContentType(file.getContentType());
            uf.setSuffix(fileType);
            result.add(uf);
        }
        return result;
    }
}

