/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.budget;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.budget.BudgetExcelService;
import com.tcbj.crm.budget.BudgetItemCondition;
import com.tcbj.crm.budget.BudgetService;
import com.tcbj.crm.budget.ExcelVaildateService;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/budget"})
public class BudgetExcelController
extends BaseController {
    @Autowired
    ExcelVaildateService excelVaildateService;
    @Autowired
    BudgetService budgetService;
    @Autowired
    BudgetExcelService budgetExcelService;

    @RequestMapping(value={"/orgExcel.do"}, method={RequestMethod.GET})
    public String addGet(BudgetItemCondition con, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("con", (Object)con);
        return "budget/orgExcel.ftl";
    }

    @RequestMapping(value={"/orgExcel.do"}, method={RequestMethod.POST})
    public String addPost(BudgetItemCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "budget");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<BudgetItem> list = new ArrayList<BudgetItem>();
        List<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        switch (con.getExcel()) {
            case 1: {
                msglist = this.excelVaildateService.readOrgByExcel(url, em, list, con);
                break;
            }
            case 2: {
                msglist = this.excelVaildateService.readChannelByExcel(url, em, list, con);
                break;
            }
            case 3: {
                msglist = this.excelVaildateService.readBigAreaByExcel(url, em, list, con);
                break;
            }
            case 4: {
                msglist = this.excelVaildateService.readAreaByExcel(url, em, list, con);
                break;
            }
            case 5: {
                msglist = this.excelVaildateService.readEmployeeByExcel(url, em, list, con);
                break;
            }
            case 6: {
                msglist = this.excelVaildateService.readCustomerByExcel(url, em, list, con);
                break;
            }
        }
        return this.excelReturn(con, list, msglist, filelist, model);
    }

    public String excelReturn(BudgetItemCondition con, List<BudgetItem> list, List<AdjustStockUtil> msglist, List<IUploadFile> filelist, Model model) {
        String rtn = null;
        if (list.size() < 1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        this.budgetExcelService.saveOrgList(list);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:" + con.getBudgetId() + "&budgetState=" + con.getBudgetState()));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

