/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.cache;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.view.CampaignlistV;
import com.tcbj.crm.view.CurrencyType;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ProductCategory;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tcbjcache")
public class Cache {
    public static Logger logger = LoggerFactory.getLogger(Cache.class);
    @Autowired
    private BaseDao baseDao;
    private static List<CurrencyType> currencyTypes = new ArrayList<CurrencyType>();
    private static Map<String, String> types = new HashMap<String, String>();
    private static Map<String, List<DictionaryItem>> dictionarys = new HashMap<String, List<DictionaryItem>>();
    private static Map<String, Partner> partners = new HashMap<String, Partner>();
    private static Map<String, Partner> partnersByNo = new HashMap<String, Partner>();
    private static Map<String, PartnerContact> employees = new HashMap<String, PartnerContact>();
    private static Map<String, Product> products = new HashMap<String, Product>();
    private static Map<String, Product> product = new HashMap<String, Product>();
    private static Map<String, Storage> storages = new HashMap<String, Storage>();
    private static Map<String, Customer> customers = new HashMap<String, Customer>();
    private static Map<String, Customer> customerByExtCode = new HashMap<String, Customer>();
    private static Map<String, Customer> customerByIdMap = new HashMap<String, Customer>();
    private static Map<String, Customer> customersMap = new HashMap<String, Customer>();
    private static Map<String, Region> region = new HashMap<String, Region>();
    private static Map<String, Position> positions = new HashMap<String, Position>();
    private static Map<String, ChannelType> channelType = new HashMap<String, ChannelType>();
    private static Map<String, ProductCategory> productCategorys = new HashMap<String, ProductCategory>();
    private static Map<String, CampaignlistV> campaigns = new HashMap<String, CampaignlistV>();
    private static Map<String, PartnerContact> employeeMap = new HashMap<String, PartnerContact>();
    private static Map<String, ProductGiftView> giftMap = new HashMap<String, ProductGiftView>();
    private static Map<String, PartnerShop> partnerShopMap = new HashMap<String, PartnerShop>();
    private static String siebelUser = null;
    private static String siebelPwd = null;
    private static String siebelUrl = null;
    private static String cacheJSON = null;

    static {
        logger.info("======================testing logger======================");
        types.put("CONTACT_TYPE", "\u804c\u4f4d\u5206\u7c7b");
        types.put("TCBJ_ABILITY_TYPE", "\u80fd\u529b\u9879\u539f\u5f62");
        types.put("TCBJ_PERSON_TYPE_CD", "\u7c7b\u578b");
        types.put("TCBJ_PURCHASE_MODE", "\u8d2d\u9500\u6a21\u5f0f");
        types.put("TCBJ_SETTLEMENT_MODE", "\u7ed3\u7b97\u65b9\u5f0f");
        types.put("TCBJ_CREDIT_LEVEL", "\u4fe1\u7528\u7b49\u7ea7");
        types.put("TCBJ_ORDER_TYPE", "\u9ed8\u8ba4\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_RETURN_ORDER_TYPE", "\u9ed8\u8ba4\u9000\u8d27\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_SHIPMENT_PRIORITY", "\u53d1\u8d27\u4f18\u5148\u7ea7");
        types.put("TCBJ_SALES_TAX_CODE", "\u9500\u552e\u7a0e\u7801");
        types.put("TCBJ_BILL_TYPE", "\u5f00\u7968\u7c7b\u578b");
        types.put("TCBJ_STORE_TYPE", "\u95e8\u5e97\u7c7b\u578b");
        types.put("TCBJ_STORE_SUBTYPE", "\u95e8\u5e97\u5206\u7c7b");
        types.put("COUNTRY", "\u56fd\u5bb6");
        types.put("STATE_ABBREV", "\u7701");
        types.put("TCBJ_CITY", "\u57ce\u5e02");
        types.put("COUNTY", "\u53bf");
        types.put("TCBJ_RECEIVE_DATE_TYPE", "\u6536\u8d27\u65f6\u95f4");
        types.put("LOY_PART_CATEGORY_TYPE", "\u7ec4\u7ec7\u5206\u7c7b");
        types.put("TCBJ_PARTNER_LEVEL", "\u7ecf\u9500\u5546\u7b49\u7ea7");
        types.put("TCBJ_RECEIVE_TYPE", "\u5e93\u5b58\u63a5\u6536\u65b9\u5f0f ");
        types.put("BIG_REGION", "\u5927\u533a");
        types.put("REGION", "\u533a\u57df");
        types.put("YON", "\u662f\u5426");
        types.put("ADDR_TYPE", "\u5730\u5740\u7c7b\u578b");
        types.put("SEX_MF", "\u6027\u522b");
        types.put("TCBJ_NOTICE_SYS", "\u53d1\u5e03\u7cfb\u7edf");
        types.put("TCBJ_EAS_ORDER_TYPE", "\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_SHIPMENT_TYPE", "\u4ea4\u8d27\u65b9\u5f0f");
        types.put("TCBJ_UNIT_TYPE", "\u8ba1\u91cf\u5355\u4f4d");
        types.put("TCBJ_NOTICE_TYPE", "\u516c\u544a\u7c7b\u578b");
        types.put("TCBJ_STORE_TYPE", "\u95e8\u5e97\u7c7b\u578b");
        types.put("TCBJ_STORE_SUBTYPE", "\u95e8\u5e97\u5206\u7c7b");
        types.put("TCBJ_BUS_MODE", "\u95e8\u5e97\u4e1a\u52a1\u6a21\u5f0f");
        types.put("TCBJ_PROMOTION_MODE", "\u4fc3\u9500\u6a21\u5f0f");
        types.put("TCBJ_ROLE_CTL_VALUE", "\u63a7\u5236\u8303\u56f4");
        types.put("TCBJ_FINE_TYPE", "\u91d1\u989d\u7c7b\u578b");
        types.put("TCBJ_ACTION_TYPE", "\u63d0\u9192\u7c7b\u578b");
        types.put("TCBJ_CONTROL_SOURCE_TYPE", "\u63a7\u5236\u6e90");
        types.put("TCBJ_PRODUCT_TYPE", "\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_SUB_TYPE", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        types.put("TCBJ_CONTROL_CONTENT", "\u63a7\u5236\u5185\u5bb9");
        types.put("TCBJ_GIFT_SOURCE_TYPE", "\u8d60\u54c1\u6765\u6e90");
        types.put("TCBJ_CHECK_TYPE", "\u68c0\u67e5\u7c7b\u578b");
        types.put("TCBJ_CHECK_METHOD", "\u68c0\u67e5\u65b9\u5f0f");
        types.put("TCBJ_TERMIMAL_LEVEL", "\u7ec8\u7aef\u7b49\u7ea7");
        types.put("TCBJ_SUBINV_OWNER_TYPE", "\u4ed3\u5e93\u5f52\u5c5e");
        types.put("TCBJ_SUBINV_TYPE", "\u4ed3\u5e93\u7c7b\u578b");
        types.put("TCBJ_MOVE_ORDER_TYPE", "\u8c03\u62e8\u7c7b\u578b");
        types.put("TCBJ_SURVEY_TYPE", "\u8c03\u7814\u95ee\u5377\u7c7b\u578b");
        types.put("TCBJ_DUE_DAYS", "\u5230\u671f\u5929\u6570");
        types.put("TCBJ_SHIPMENT_TYPE", "\u4ea4\u8d27\u65b9\u5f0f");
        types.put("TCBJ_MODIFY_TYPE", "\u8c03\u6574\u7c7b\u578b");
        types.put("TCBJ_COEFFICIENT_TYPE", "\u7cfb\u6570\u7c7b\u578b");
        types.put("TCBJ_MODIFY_METHOD", "\u8c03\u6574\u65b9\u5f0f");
        types.put("TCBJ_PARTNER_LEVEL", "\u7ecf\u9500\u5546\u7b49\u7ea7");
        types.put("TCBJ_FREEGIFT_CTRL_MODE", "\u8d60\u54c1\u63a7\u5236\u65b9\u5f0f");
        types.put("TCBJ_DISCOUNT_PRODUCT_TYPE", "\u6298\u6263\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRICE_DECIMAL_DIGITS", "\u4ef7\u683c\u5c0f\u6570\u4f4d");
        types.put("TCBJ_MISC_ORDER_TYPE", "\u8c03\u5e93\u5355\u7c7b\u578b");
        types.put("TCBJ_PACT_TARGET_TYPE", "\u5408\u540c\u76ee\u6807\u7c7b\u578b");
        types.put("TCBJ_PACT_TARGET_SUB_TYPE", "\u5408\u540c\u76ee\u6807\u5b50\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_TYPE", "\u4ea7\u54c1\u7c7b\u578b");
        types.put("TCBJ_PRODUCT_SUB_TYPE", "\u4ea7\u54c1\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_SOURCE_TYPE", "\u8d44\u6e90\u7c7b\u578b");
        types.put("TCBJ_PACT_SOURCE_SUB_TYPE", "\u8d44\u6e90\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_ACTIVE_TYPE", "\u6d3b\u52a8\u7c7b\u578b");
        types.put("TCBJ_PACT_ACTIVE_SUB_TYPE", "\u6d3b\u52a8\u5b50\u7c7b\u578b");
        types.put("TCBJ_PACT_PLAN_SHAPE", "\u8ba1\u5212\u6295\u5165\u5f62\u5f0f");
        types.put("TCBJ_EXPENSE_TYPE", "\u8d39\u7528\u7c7b\u578b");
        types.put("TCBJ_PACT_EXPENSE_TYPE", "\u8d39\u7528\u5b50\u7c7b\u578b");
        types.put("APPLY_SCOPE", "\u7533\u8bf7\u8303\u56f4\u63a7\u5236");
        types.put("STORE_TYPE", "\u4e13\u67dc\u7533\u8bf7\u7c7b\u578b");
        types.put("TRAIN_TYPE", "\u57f9\u8bad\u7c7b\u522b");
        types.put("BUDGET_TARGET", "\u8d39\u7528\u5bf9\u8c61");
        types.put("BUDGET_TYPE", "\u8d39\u7528\u7c7b\u578b");
        types.put("TCBJ_MEM_ORD_STATUS", "\u8ba2\u5355\u72b6\u6001");
        types.put("TCBJ_EXCHANGE_ORDER_TYPE", "\u8ba2\u5355\u7c7b\u578b");
        types.put("TCBJ_MEM_ORD_DEL_STATUS", "\u53d1\u9001\u72b6\u6001");
        types.put("TCBJ_MEM_ORD_METHOD", "\u5151\u6362\u65b9\u5f0f ");
        types.put("TCBJ_MEM_RDM_STATUS", "\u5151\u6362\u72b6\u6001");
        types.put("IMPL_PHASE", "\u4ea7\u54c1\u72b6\u6001");
        types.put("YOW", "\u6709\u65e0");
        types.put("TCBJ_ORDER_SHIP_TYPE", "\u53d1\u8d27\u72b6\u6001");
    }

    @PostConstruct
    public void init() {
        this.initEnums();
        this.initCurrencyTypes();
        this.initPartners();
        this.initEmployees();
        this.initProduct();
        this.initStorages();
        this.initCampaigns();
        this.initCustomers();
        this.initRegion();
        this.initPositions();
        this.initChannelType();
        this.initProductCategorys();
        this.initProductGift();
        this.initPartnerShop();
        cacheJSON = null;
    }

    public void initProductGift() {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ProductGiftView");
        List gifts = this.baseDao.findEntity(hql.toString(), ProductGiftView.class);
        for (ProductGiftView gift : gifts) {
            giftMap.put(gift.getId(), gift);
        }
    }

    public static ProductGiftView getGift(String productId) {
        return giftMap.get(productId);
    }

    public void initRegionData() {
        this.initChannelType();
        this.initRegion();
        this.initStorages();
    }

    public static Map<String, Region> getRegion() {
        return region;
    }

    public static Map<String, Storage> getStorages() {
        return storages;
    }

    public static Map<String, PartnerContact> getEmployees() {
        return employees;
    }

    public void initCustomers() {
        customersMap.clear();
        customerByIdMap.clear();
        customerByExtCode.clear();
        HashMap<String, Customer> tmp = new HashMap<String, Customer>();
        List _customers = this.baseDao.findEntity("from Customer ", Customer.class);
        for (Customer c : _customers) {
            customerByIdMap.put(c.getId(), c);
            tmp.put(c.getApplyerId(), c);
            customersMap.put(c.getUnionId(), c);
            if (!StringUtils.isNotEmpty(c.getExtCode()) || c.getExtCode().lastIndexOf(".") <= -1) continue;
            customerByExtCode.put(c.getExtCode().substring(c.getExtCode().lastIndexOf(".") + 1), c);
        }
        customers = tmp;
    }

    public static Customer getCustomer(String unionId) {
        return customersMap.get(unionId);
    }

    public static Customer getCustomerById(String id) {
        return customerByIdMap.get(id);
    }

    public void initPartnerShop() {
        partnerShopMap.clear();
        HashMap<String, PartnerShop> tmp = new HashMap<String, PartnerShop>();
        List _PartnerShop = this.baseDao.findEntity("from PartnerShop ", PartnerShop.class);
        for (PartnerShop c : _PartnerShop) {
            tmp.put(c.getId(), c);
        }
        partnerShopMap = tmp;
    }

    public static PartnerShop getPartnerShop(String no) {
        return partnerShopMap.get(no);
    }

    public void initCampaigns() {
        HashMap<String, CampaignlistV> tmp = new HashMap<String, CampaignlistV>();
        List _campaign = this.baseDao.findEntity("from CampaignlistV ", CampaignlistV.class);
        for (CampaignlistV c : _campaign) {
            tmp.put(c.getId(), c);
        }
        campaigns.clear();
        campaigns = tmp;
    }

    public static String getCampaignName(String id) {
        CampaignlistV campaign = campaigns.get(id);
        if (campaign == null) {
            return null;
        }
        return campaign.getCampaignName();
    }

    public static Product getNo(String id) {
        Product p = product.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public void initStorages() {
        HashMap<String, Storage> tmp = new HashMap<String, Storage>();
        List _storages = this.baseDao.findEntity("from Storage ", Storage.class);
        for (Storage s : _storages) {
            tmp.put(s.getId(), s);
        }
        storages.clear();
        storages = tmp;
    }

    public void initProduct() {
        HashMap<String, Product> tmp = new HashMap<String, Product>();
        HashMap<String, Product> tmps = new HashMap<String, Product>();
        List _product = this.baseDao.findEntity("from Product ", Product.class);
        for (Product p : _product) {
            tmps.put(p.getId(), p);
            tmp.put(p.getNo(), p);
        }
        product.clear();
        product = tmp;
        products.clear();
        products = tmps;
    }

    public void initPositions() {
        HashMap<String, Position> tmp = new HashMap<String, Position>();
        List _positions = this.baseDao.findEntity("from Position", Position.class);
        for (Position p : _positions) {
            tmp.put(p.getId(), p);
        }
        positions.clear();
        positions = tmp;
    }

    public void initEmployees() {
        employeeMap.clear();
        HashMap<String, PartnerContact> tmp = new HashMap<String, PartnerContact>();
        List _employees = this.baseDao.findEntity("from PartnerContact", PartnerContact.class);
        for (PartnerContact e : _employees) {
            tmp.put(e.getId(), e);
            if (!"1-1JK1".equals(e.getPartnerId())) continue;
            employeeMap.put(e.getContactName(), e);
        }
        employees.clear();
        employees = tmp;
    }

    public static String getEmployeeId(String name) {
        if (employeeMap.get(name) != null) {
            return employeeMap.get(name).getId();
        }
        return null;
    }

    public void initChannelType() {
        HashMap<String, ChannelType> tmp = new HashMap<String, ChannelType>();
        List _channelType = this.baseDao.findEntity("from ChannelType", ChannelType.class);
        for (ChannelType e : _channelType) {
            tmp.put(e.getId(), e);
        }
        channelType.clear();
        channelType = tmp;
    }

    public void initProductCategorys() {
        HashMap<String, ProductCategory> tmp = new HashMap<String, ProductCategory>();
        List pcs = this.baseDao.findEntity("from ProductCategory", ProductCategory.class);
        for (ProductCategory pc : pcs) {
            tmp.put(pc.getId(), pc);
        }
        productCategorys.clear();
        productCategorys = tmp;
    }

    public void initRegion() {
        HashMap<String, Region> tmp = new HashMap<String, Region>();
        List list = this.baseDao.findEntity("from Region", Region.class);
        for (Region region2 : list) {
            tmp.put(region2.getId(), region2);
        }
        region.clear();
        region = tmp;
        for (Region partner : region.values()) {
            Region parent = region.get(partner.getParentId());
            if (parent == null) continue;
            parent.getChildList().add(partner);
        }
    }

    public void initPartners() {
        partnersByNo.clear();
        HashMap<String, Partner> tmp = new HashMap<String, Partner>();
        List _partners = this.baseDao.findEntity("from Partner", Partner.class);
        for (Partner p : _partners) {
            tmp.put(p.getId(), p);
            partnersByNo.put(p.getNo(), p);
        }
        partners.clear();
        partners = tmp;
        for (Partner partner : partners.values()) {
            Partner parent = partners.get(partner.getParentPartnerId());
            if (parent == null) continue;
            parent.getChildPartner().add(partner);
        }
    }

    public static List<Partner> getPartnersBySupplierId(String supplierId) {
        ArrayList<Partner> _partners = new ArrayList<Partner>();
        for (String key : partners.keySet()) {
            Partner partner = partners.get(key);
            if (StringUtils.isEmpty(partner.getParentPartnerId()) || !partner.getParentPartnerId().equals(supplierId)) continue;
            _partners.add(partner);
        }
        return _partners;
    }

    public static Partner getPartnerByNo(String no) {
        return partnersByNo.get(no);
    }

    public static String getPositionName(String id) {
        Position p = positions.get(id);
        if (p == null) {
            return "";
        }
        return p.getPostName();
    }

    public static String getChannelTypeName(String id) {
        ChannelType p = channelType.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static String getChannelTypeId(String id) {
        ChannelType p = channelType.get(id);
        if (p == null) {
            return "";
        }
        return p.getId();
    }

    public static String getApplyerName(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return "";
        }
        return p.getApplyerName();
    }

    public static Customer getApplyer(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static String getApplyerCode(String id) {
        Customer p = customers.get(id);
        if (p == null) {
            return "";
        }
        return p.getApplyerCode();
    }

    public static String getStorageName(String storageId) {
        Storage storage = storages.get(storageId);
        if (storage == null) {
            return null;
        }
        return storage.getStorageName();
    }

    public static String getStorageCode(String storageId) {
        Storage storage = storages.get(storageId);
        if (storage == null) {
            return null;
        }
        return storage.getStorageCode();
    }

    private void initCurrencyTypes() {
        List tmp = this.baseDao.findEntity("from CurrencyType", CurrencyType.class);
        currencyTypes.clear();
        currencyTypes = tmp;
    }

    public static Customer getCustomerByExtCode(String extCode) {
        return customerByExtCode.get(extCode);
    }

    private void initEnums() {
        StringBuffer hql = new StringBuffer();
        hql.append("from DictionaryItem where activeFlg='Y' and ");
        hql.append(" type in ( ");
        int count = 1;
        for (String key : types.keySet()) {
            hql.append("'");
            hql.append(key);
            hql.append("'");
            if (count++ >= types.size()) continue;
            hql.append(",");
        }
        hql.append(" ) ");
        hql.append(" order by orderBy ");
        List items = this.baseDao.findEntity(hql.toString(), DictionaryItem.class);
        DictionaryItem item_15 = new DictionaryItem("item_15", "1", "\u4e13\u67dc\u4e00", "STORE_TYPE", "");
        DictionaryItem item_16 = new DictionaryItem("item_16", "2", "\u4e13\u67dc\u4e8c", "STORE_TYPE", "");
        DictionaryItem item_17 = new DictionaryItem("item_17", "3", "\u67dc\u4e09", "STORE_TYPE", "");
        items.add(item_15);
        items.add(item_16);
        items.add(item_17);
        DictionaryItem item_11 = new DictionaryItem("item_11", "1", "\u5ba2\u6237", "APPLY_SCOPE", "");
        DictionaryItem item_12 = new DictionaryItem("item_12", "2", "\u7ec4\u7ec7", "APPLY_SCOPE", "");
        DictionaryItem item_13 = new DictionaryItem("item_13", "3", "\u5ba2\u6237\u53ca\u7ec4\u7ec7", "APPLY_SCOPE", "");
        DictionaryItem item_14 = new DictionaryItem("item_14", "4", "\u65e0", "APPLY_SCOPE", "");
        items.add(item_14);
        items.add(item_13);
        items.add(item_12);
        items.add(item_11);
        DictionaryItem item_6 = new DictionaryItem("item_6", "Y", "\u662f", "YON", "");
        DictionaryItem item_7 = new DictionaryItem("item_7", "N", "\u5426", "YON", "");
        items.add(item_6);
        items.add(item_7);
        DictionaryItem item_20 = new DictionaryItem("item_20", "1", "\u8425\u517b\u57f9\u8bad", "TRAIN_TYPE", "");
        DictionaryItem item_21 = new DictionaryItem("item_21", "2", "\u8679\u819c\u57f9\u8bad", "TRAIN_TYPE", "");
        items.add(item_20);
        items.add(item_21);
        DictionaryItem item_22 = new DictionaryItem("item_22", "1", "\u6709", "YOW", "");
        DictionaryItem item_23 = new DictionaryItem("item_23", "2", "\u65e0", "YOW", "");
        items.add(item_22);
        items.add(item_23);
        DictionaryItem item_24 = new DictionaryItem("item_24", "0", "\u7ec4\u7ec7", "BUDGET_TYPE", "");
        DictionaryItem item_25 = new DictionaryItem("item_25", "1", "\u6e20\u9053", "BUDGET_TYPE", "");
        DictionaryItem item_26 = new DictionaryItem("item_26", "2", "\u5927\u533a", "BUDGET_TYPE", "");
        DictionaryItem item_27 = new DictionaryItem("item_27", "3", "\u533a\u57df", "BUDGET_TYPE", "");
        items.add(item_24);
        items.add(item_25);
        items.add(item_26);
        items.add(item_27);
        DictionaryItem item_28 = new DictionaryItem("item_28", "0", "\u5408\u540c\u5185", "BUDGET_TARGET", "");
        DictionaryItem item_29 = new DictionaryItem("item_29", "1", "OTC", "BUDGET_TARGET", "");
        DictionaryItem item_30 = new DictionaryItem("item_30", "2", "\u5927\u533a", "BUDGET_TARGET", "");
        DictionaryItem item_31 = new DictionaryItem("item_31", "3", "\u5546\u8d85", "BUDGET_TARGET", "");
        DictionaryItem item_32 = new DictionaryItem("item_32", "4", "\u7535\u5546", "BUDGET_TARGET", "");
        DictionaryItem item_33 = new DictionaryItem("item_33", "5", "\u76f4\u8425", "BUDGET_TARGET", "");
        items.add(item_28);
        items.add(item_29);
        items.add(item_30);
        items.add(item_31);
        items.add(item_32);
        items.add(item_33);
        DictionaryItem item_9 = new DictionaryItem("PRODUCT", "PRODUCT", "\u4ea7\u54c1", "TCBJ_DISCOUNT_PRODUCT_TYPE", "");
        DictionaryItem item_10 = new DictionaryItem("GIFT", "GIFT", "\u8d60\u54c1", "TCBJ_DISCOUNT_PRODUCT_TYPE", "");
        items.add(item_9);
        items.add(item_10);
        HashMap<String, List<DictionaryItem>> tmp = new HashMap<String, List<DictionaryItem>>();
        for (String type : types.keySet()) {
            ArrayList<DictionaryItem> dis = (ArrayList<DictionaryItem>)tmp.get(type);
            if (dis == null) {
                dis = new ArrayList<DictionaryItem>();
            }
            tmp.put(type, dis);
            for (DictionaryItem item : items) {
                if (item.getType() == null || !item.getType().equals(type)) continue;
                dis.add(item);
            }
        }
        dictionarys.clear();
        dictionarys = tmp;
    }

    public static Map<String, ProductCategory> getProductCategorys() {
        return productCategorys;
    }

    public static ProductCategory getProductCategory(String id) {
        if (Cache.getProductCategorys() == null) {
            return null;
        }
        return Cache.getProductCategorys().get(id);
    }

    public static List<CurrencyType> getCurrencyTypes() {
        return currencyTypes;
    }

    public static String getCurrencyTypeName(String code) {
        for (CurrencyType type : currencyTypes) {
            if (!type.getCurcyCd().equals(code)) continue;
            return type.getName();
        }
        return "";
    }

    public static List<DictionaryItem> getItems(String type) {
        return dictionarys.get(type);
    }

    public static String getItemName(String type, String itemCode) {
        List<DictionaryItem> items = Cache.getItems(type);
        if (items == null) {
            return "";
        }
        for (DictionaryItem item : items) {
            if (!item.getName().equals(itemCode)) continue;
            return item.getVal();
        }
        return "";
    }

    public static DictionaryItem getItem(String type, String itemCode) {
        List<DictionaryItem> items = Cache.getItems(type);
        if (items == null) {
            return null;
        }
        for (DictionaryItem item : items) {
            if (!item.getName().equals(itemCode)) continue;
            return item;
        }
        return null;
    }

    public static String getPartnerName(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static Map<String, Partner> getPartners() {
        return partners;
    }

    public static Partner getPartner(String id) {
        return partners.get(id);
    }

    public static String getPartnerNo(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getNo();
    }

    public static String getPartnerSaleChannelTypeCode(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getSaleChannelTypeName();
    }

    public static String getPartnerCSN(String id) {
        Partner p = partners.get(id);
        if (p == null) {
            return "";
        }
        return p.getClientAppNo();
    }

    public static String getEmployeeName(String id) {
        PartnerContact e = employees.get(id);
        if (e == null) {
            return "";
        }
        return e.getContactName();
    }

    public static String getEmployeeNo(String id) {
        PartnerContact e = employees.get(id);
        if (e == null) {
            return "";
        }
        return e.getNo();
    }

    public static String getRegionsName(String id) {
        Region p = region.get(id);
        if (p == null) {
            return "";
        }
        return p.getRegionName();
    }

    public static Region getRegions(String id) {
        Region p = region.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static String getProductName(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getName();
    }

    public static String getProductType(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getType();
    }

    public static String getProductUnit(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getUnitName();
    }

    public static String getProductNo(String id) {
        Product p = products.get(id);
        if (p == null) {
            return "";
        }
        return p.getNo();
    }

    public static Product getProduct(String id) {
        Product p = products.get(id);
        if (p == null) {
            return null;
        }
        return p;
    }

    public static Product getProductByNo(String no) {
        for (String key : products.keySet()) {
            Product p = products.get(key);
            if (!StringUtils.isNotEmpty(p.getNo()) || !p.getNo().equals(no)) continue;
            return p;
        }
        return null;
    }

    public String getEnumJSON() {
        if (cacheJSON != null) {
            return cacheJSON;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ___dictionarys = ");
        HashMap<String, List<DictionaryItem>> tmp = new HashMap<String, List<DictionaryItem>>();
        for (String key : dictionarys.keySet()) {
            List<DictionaryItem> items = dictionarys.get(key);
            if ("COUNTRY".equals(key) || "STATE_ABBREV".equals(key) || "TCBJ_CITY".equals(key) || "COUNTY".equals(key)) continue;
            tmp.put(key, items);
        }
        sb.append(JSON.toJSONString(tmp));
        sb.append(";");
        sb.append("var ___currencytype = ");
        sb.append(JSON.toJSONString(currencyTypes));
        sb.append(";");
        cacheJSON = sb.toString();
        return cacheJSON;
    }

    public String getEmployeeJSON(String partnerId) {
        if (StringUtils.isEmpty(partnerId)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ___employees = ");
        List cs = this.baseDao.findEntity("from PartnerContact where partnerId='" + partnerId + "'", PartnerContact.class);
        sb.append(JSON.toJSONString((Object)cs));
        sb.append(";");
        return sb.toString();
    }

    public static String getSiebelUrl() {
        return siebelUrl;
    }

    static void setSiebelUrl(String siebelUrl) {
        if (StringUtils.isNotEmpty(Cache.siebelUrl)) {
            return;
        }
        Cache.siebelUrl = siebelUrl;
    }

    public static String getSiebelUser() {
        return siebelUser;
    }

    static void setSiebelUser(String siebelUser) {
        if (StringUtils.isNotEmpty(Cache.siebelUser)) {
            return;
        }
        Cache.siebelUser = siebelUser;
    }

    public static String getSiebelPwd() {
        return siebelPwd;
    }

    static void setSiebelPwd(String siebelPwd) {
        if (StringUtils.isNotEmpty(Cache.siebelPwd)) {
            return;
        }
        Cache.siebelPwd = siebelPwd;
    }
}

