/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.channelType;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.channelType.ChannelTypeCondition;
import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/channelType"})
public class ChannelTypeController
extends BaseController {
    @Autowired
    ChannelTypeService channelTypeService;
    @Autowired
    Cache cache;

    @RequestMapping(value={"list.do"})
    public String get_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ChannelTypeCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setPartnerId(em.getCurrentPartner().getId());
        Page page = this.channelTypeService.getList(con, pageno);
        model.addAttribute("con", (Object)con);
        model.addAttribute("page", (Object)page);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "channelType/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String get_add(ChannelType channelType, Model model) {
        model.addAttribute("channelType", (Object)channelType);
        model.addAttribute("date", (Object)DateUtils.now());
        return "channelType/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add(@Valid @RequestBody ChannelType channelType, BindingResult errors, HttpServletRequest request, Model model) {
        Employee em = this.getCurrentEmployee();
        boolean isExist = this.channelTypeService.isName(em.getCurrentPartner().getId(), channelType.getName(), null);
        if (isExist) {
            throw new AppException("5107");
        }
        channelType.setPartnerId(em.getCurrentPartner().getId());
        this.channelTypeService.savetp(channelType);
        this.cache.initChannelType();
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String get_edit(String id, Model model) {
        ChannelType channelType = this.channelTypeService.getById(id);
        model.addAttribute("channelType", (Object)channelType);
        model.addAttribute("id", (Object)id);
        return "channelType/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit(@Valid @RequestBody ChannelType channelType, BindingResult errors, HttpServletRequest request, Model model) {
        Employee em = this.getCurrentEmployee();
        boolean isExist = this.channelTypeService.isName(em.getCurrentPartner().getId(), channelType.getName(), channelType.getId());
        if (isExist) {
            throw new AppException("5107");
        }
        this.channelTypeService.update(channelType);
        this.cache.initChannelType();
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, Model model) {
        ChannelType channelType = this.channelTypeService.getById(id);
        model.addAttribute("channelType", (Object)channelType);
        return "channelType/view.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(String id, Model model) {
        ChannelType channelType = this.channelTypeService.getById(id);
        channelType.setEndDt(DateUtils.now());
        this.channelTypeService.update(channelType);
        return "redirect:list.do";
    }
}

