/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.channelType;

import com.tcbj.crm.channelType.ChannelTypeCondition;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="channelTypeService")
public class ChannelTypeService {
    @Autowired
    BaseDao baseDao;

    public ChannelType getById(String id) {
        return (ChannelType)this.baseDao.get(ChannelType.class, (Serializable)((Object)id));
    }

    public void savetp(ChannelType channelType) {
        this.baseDao.save((Object)channelType);
    }

    public void update(ChannelType channelType) {
        this.baseDao.update((Object)channelType);
    }

    public Page getList(ChannelTypeCondition con, int pageno) {
        String hql = "from ChannelType c where 1=1 ";
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(con.getName())) {
            hql = String.valueOf(hql) + "and c.name like ?";
            args.add("%" + con.getName() + "%");
        }
        if (StringUtils.isNotEmpty(con.getPartnerId())) {
            hql = String.valueOf(hql) + " and c.partnerId = ? ";
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getStartDt())) {
            hql = String.valueOf(hql) + "and c.startDt >= ?";
            args.add(con.getStartDt());
        }
        if (StringUtils.isNotNull(con.getEndDateHQL())) {
            hql = String.valueOf(hql) + "and c.endDt < ?";
            args.add(con.getEndDateHQL());
        }
        hql = String.valueOf(hql) + " order by c.created ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<ChannelType> getChannelTypes(String partnerId) {
        String hql = " from ChannelType c where c.partnerId = ? and startDt < ? and (endDt > ? or endDt is null) ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId, new Date(), new Date()}, ChannelType.class);
    }

    public boolean isName(String partnerId, String name, String id) {
        List cts;
        boolean isExist = false;
        String hql = "from ChannelType c where 1=1 ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(partnerId)) {
            hql = String.valueOf(hql) + "and c.partnerId = ?";
            args.add(partnerId);
        }
        if (StringUtils.isNotEmpty(name)) {
            hql = String.valueOf(hql) + "and c.name = ? ";
            args.add(name);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and c.id != ?";
            args.add(id);
        }
        if ((cts = this.baseDao.findEntity(hql, args.toArray(), ChannelType.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public void addChannelTypeAndBigRegionAndRegion(String partnerId, Employee em) {
        ChannelType ct = new ChannelType();
        ct.setPartnerId(partnerId);
        ct.setName("\u9ed8\u8ba4\u6e20\u9053");
        ct.setStartDt(new Date());
        ct.fillInitData(em);
        this.baseDao.save((Object)ct);
        Region rg = new Region();
        rg.fillInitData(em);
        rg.setChannelCode(ct.getId());
        rg.setParentId(ct.getId());
        rg.setStartDate(new Date());
        rg.setOrgId(partnerId);
        rg.setRegionName("\u9ed8\u8ba4\u5927\u533a");
        rg.setRegionCode(String.valueOf(partnerId) + ".MRDQ");
        this.baseDao.save((Object)rg);
        Region region = new Region();
        region.fillInitData(em);
        region.setChannelCode(ct.getId());
        region.setParentId(rg.getId());
        region.setStartDate(new Date());
        region.setOrgId(partnerId);
        region.setRegionName("\u9ed8\u8ba4\u533a\u57df");
        region.setRegionCode(String.valueOf(partnerId) + ".MRQY");
        this.baseDao.save((Object)region);
    }
}

