/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.competition;

import com.tcbj.crm.competition.CompetitionCondition;
import com.tcbj.crm.entity.CompetCost;
import com.tcbj.crm.entity.Competition;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.trainapply.ApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.AxisFault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="competitionService")
public class CompetitionService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    ApplyService applyService;

    public Competition get(String id) {
        Competition competition = this.getCompetition(id);
        competition.setCompetCosts(this.getCompetCost(id));
        competition.setShoppeApplyFiles(this.getShoppeApplyFile(id));
        return competition;
    }

    public Competition getCompetition(String id) {
        return (Competition)this.baseDao.get(Competition.class, (Serializable)((Object)id));
    }

    public List<CompetCost> getCompetCost(String competitionId) {
        return this.baseDao.findEntity("from CompetCost where competitionId = ?", new Object[]{competitionId}, CompetCost.class);
    }

    public List<ShoppeApplyFile> getShoppeApplyFile(String applyId) {
        return this.baseDao.findEntity("from ShoppeApplyFile where applyId = ?", new Object[]{applyId}, ShoppeApplyFile.class);
    }

    public void del(String id) {
        this.baseDao.deleteById(Competition.class, (Serializable)((Object)id));
        this.baseDao.executeHQL("delete CompetCost where competitionId=?", new Object[]{id});
        this.baseDao.executeHQL("delete ShoppeApplyFile where applyId=?", new Object[]{id});
    }

    public void update(String id) {
        Competition competition = this.getCompetition(id);
        competition.setState("9");
        this.baseDao.update((Object)competition);
    }

    public Page getPage(CompetitionCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Competition where 1=1 and state <> '9' and partnerId = ? ");
        args.add(con.getPartnerId());
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void save(Competition competition, List<IUploadFile> filelist, Employee me) {
        this.baseDao.save((Object)competition);
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(competition.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
        for (CompetCost competCost : competition.getCompetCosts()) {
            competCost.setCompetitionId(competition.getId());
            competCost.fillInitData(me);
        }
        this.baseDao.save(competition.getCompetCosts());
        try {
            this.applyService.addCompetition(competition);
        }
        catch (AxisFault e) {
            e.printStackTrace();
        }
    }

    public void update(Competition competition, List<IUploadFile> filelist, Employee me, CompetitionCondition com) {
        String[] ids;
        String[] fileids;
        this.baseDao.update((Object)competition);
        String[] stringArray = fileids = com.getFileId().split(",");
        int n = fileids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete ShoppeApplyFile where id= ?", args);
            }
            ++n2;
        }
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(competition.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
        String[] stringArray2 = ids = com.getDelIds().split(",");
        int n3 = ids.length;
        int n4 = 0;
        while (n4 < n3) {
            String id = stringArray2[n4];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete CompetCost where id= ?", args);
            }
            ++n4;
        }
        for (CompetCost competCost : competition.getCompetCosts()) {
            competCost.setCompetitionId(competition.getId());
            competCost.fillInitData(me);
            if (StringUtils.isEmpty(competCost.getId())) {
                this.baseDao.save((Object)competCost);
                continue;
            }
            this.baseDao.update((Object)competCost);
        }
    }

    public Partner getPartner(String id) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
        return partner;
    }
}

