/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dataupload;

import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.dataupload.DataUploadCondition;
import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataUploadService")
public class DataUploadService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private ClientService clientService;

    public Page getProducts(DataUploadCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Product  where orgId=? ");
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotBlank((String)condition.getProductName())) {
            hql.append("and  name like ?");
            args.add("%" + condition.getProductName() + "%");
        }
        if (StringUtils.isNotBlank((String)condition.getProductNo())) {
            hql.append("and no like ?");
            args.add("%" + condition.getProductNo() + "%");
        }
        hql.append(" order by no asc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public Product getProduct(String productId) {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)productId));
    }

    public void saveUpload(List<IUploadFile> uploadFilelist, DataUpload dataUplad, Employee me) {
        DataUpload data = null;
        for (IUploadFile file : uploadFilelist) {
            data = new DataUpload();
            data.fillInitData(me);
            data.setParamsId(dataUplad.getParamsId());
            data.setEnclosureName(file.getName());
            data.setEnclosureType(dataUplad.getEnclosureType());
            data.setEnclosurePath(file.getWebPath());
            data.setEnclosureValue(me.getCurrentPartner().getId());
            this.baseDao.save((Object)data);
        }
    }

    public List<DataUpload> findUploadProducts(String type, String paramsId) {
        String hql = " from DataUpload where paramsId=? and enclosureType=? order by created desc ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(paramsId);
        args.add(type);
        return this.baseDao.findEntity(hql, args.toArray(), DataUpload.class);
    }

    public DataUpload getDataUpload(String id) {
        return (DataUpload)this.baseDao.get(DataUpload.class, (Serializable)((Object)id));
    }

    public Page findLicense(DataUploadCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from DataUpload where 1=1 and enclosureType='license' and (paramsId =? or paramsId=?)");
        args.add(me.getCurrentPartner().getId());
        args.add(me.getCurrentPartner().getParPartnerId());
        if (StringUtils.isNotBlank((String)condition.getName())) {
            hql.append(" and enclosureName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        hql.append(" order by created desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findCriterion(DataUploadCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from DataUpload where 1=1 and enclosureType='criterion' and (paramsId =? or enclosureValue =? )  ");
        args.add(me.getCurrentPartner().getId());
        args.add(me.getCurrentPartner().getParPartnerId());
        if (StringUtils.isNotBlank((String)condition.getName())) {
            hql.append(" and enclosureName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        hql.append(" order by created desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findCooperation(DataUploadCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from DataUpload where 1=1 and enclosureType='criterion' and paramsId=?  ");
        args.add(me.getCurrentPartner().getParPartnerId());
        if (StringUtils.isNotBlank((String)condition.getName())) {
            hql.append(" and enclosureName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        hql.append(" order by created desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void deleteFile(String id) {
        String hql = " DELETE FROM DataUpload where id = ?";
        this.baseDao.executeHQL(hql, new Object[]{id});
    }

    public Page viewMoreByType(DataUploadCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from DataUpload where 1=1 and enclosureType=? and (paramsId =? or enclosureValue =? )  ");
        args.add(condition.getType());
        args.add(me.getCurrentPartner().getId());
        args.add(me.getCurrentPartner().getParPartnerId());
        if (StringUtils.isNotBlank((String)condition.getName())) {
            hql.append(" and enclosureName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        hql.append(" order by created desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }
}

