/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.design;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.competition.CompetitionService;
import com.tcbj.crm.design.DesignCondition;
import com.tcbj.crm.design.DesignService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Design;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.trainapply.ApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/design"})
public class DesignController
extends BaseController {
    @Autowired
    DesignService designService;
    @Autowired
    CompetitionService competitionService;
    @Autowired
    ApplyService applyService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelservice;

    @RequestMapping(value={"/list.do"})
    public String get_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, DesignCondition des, Model model) {
        Employee em = this.getCurrentEmployee();
        des.setApplyerId(em.getId());
        Page page = this.designService.getPage(des, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("des", (Object)des);
        return "design/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Design design, Model model) {
        Employee em = this.getCurrentEmployee();
        Contact contact = new Contact();
        try {
            contact = this.personnelservice.get(em.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Customer customer = this.clientService.getCustomer(em.getCurrentPartner().getOrganizationid(), em.getCurrentPartner().getId());
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("contact", (Object)contact);
        model.addAttribute("design", (Object)design);
        model.addAttribute("em", (Object)em);
        model.addAttribute("date", (Object)DateUtils.now());
        return "design/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String add_post(Design design, String state, Model model, HttpServletRequest request) throws AxisFault {
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        List<IUploadFile> filelist = this.uploadFile(request, "design");
        design.fillInitData(em);
        design.setState(state);
        if (!"".equals(design.getId()) && design.getId() != null) {
            this.designService.update(design, filelist, em);
        } else {
            design.setCodeNo(this.orderNoService.maxNo(em.getCurrentPartner().getNo(), "pmsj"));
            this.designService.save(design, filelist, em);
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        String id = "";
        if ("8".equals(state)) {
            String path = request.getSession().getServletContext().getRealPath("/");
            id = this.applyService.addDesign(design, em.getName(), path);
            if ("".equals(id)) {
                rtn = JSON.toJSONString((Object)this.getSuccessResult("false:"));
                design.setState("0");
                this.designService.updateState(design);
            }
        }
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        Design design = this.designService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(design.getId());
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("design", (Object)design);
        return "design/edit.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, Model model) {
        Design design = this.designService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(design.getId());
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("design", (Object)design);
        return "design/view.ftl";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, Model model) {
        this.designService.delete(id);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/design.do"})
    public String get_design(@RequestParam(value="code", required=false) String code, @RequestParam(value="rowId", required=false) String rowId, @RequestParam(value="url", required=false) String url, @RequestParam(value="item", required=false) String item, Model model) {
        model.addAttribute("code", (Object)code);
        model.addAttribute("url", (Object)url);
        model.addAttribute("item", (Object)item);
        model.addAttribute("rowId", (Object)rowId);
        return "design/design.ftl";
    }
}

