/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dimension;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.competition.CompetitionService;
import com.tcbj.crm.dimension.DimensionCondition;
import com.tcbj.crm.dimension.DimensionService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Dimension;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.trainapply.ApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/dimension"})
public class DimensionController
extends BaseController {
    @Autowired
    DimensionService dimensionService;
    @Autowired
    CompetitionService competitionService;
    @Autowired
    ApplyService applyService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelservice;

    @RequestMapping(value={"/list.do"})
    public String get_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, DimensionCondition des, Model model) {
        Employee em = this.getCurrentEmployee();
        des.setApplyerId(em.getId());
        Page page = this.dimensionService.getPage(des, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("applyer", (Object)em.getName());
        model.addAttribute("des", (Object)des);
        return "dimension/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Dimension dimension, Model model) {
        Employee em = this.getCurrentEmployee();
        Contact contact = new Contact();
        try {
            contact = this.personnelservice.get(em.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Customer customer = this.clientService.getCustomer(em.getCurrentPartner().getOrganizationid(), em.getCurrentPartner().getId());
        model.addAttribute("contact", (Object)contact);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("dimension", (Object)dimension);
        model.addAttribute("em", (Object)em);
        model.addAttribute("date", (Object)DateUtils.now());
        return "dimension/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String add_post(Dimension dimension, String state, DimensionCondition con, Model model, HttpServletRequest request) throws AxisFault {
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        List<IUploadFile> filelist = this.uploadFile(request, "dimension");
        dimension.fillInitData(em);
        dimension.setState(state);
        if (!"".equals(dimension.getId()) && dimension.getId() != null) {
            con.setFileId(dimension.getFileId());
            this.dimensionService.update(dimension, filelist, con, em);
        } else {
            dimension.setCodeNo(this.orderNoService.maxNo(em.getCurrentPartner().getNo(), "swsj"));
            this.dimensionService.save(dimension, filelist, em);
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        String id = "";
        if ("8".equals(state)) {
            String path = request.getSession().getServletContext().getRealPath("/");
            id = this.applyService.addDimension(dimension, em.getName(), path);
            if ("".equals(id)) {
                rtn = JSON.toJSONString((Object)this.getSuccessResult("false:"));
                dimension.setState("0");
                this.dimensionService.updateState(dimension);
            }
        }
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        Dimension dimension = this.dimensionService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(dimension.getId());
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("dimension", (Object)dimension);
        return "dimension/edit.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.POST})
    public String edit_post(Dimension dimension, BindingResult errors, DimensionCondition con, Model model, HttpServletRequest request) {
        String rtn = null;
        dimension.fillInitData(this.getCurrentEmployee());
        List<IUploadFile> filelist = this.uploadFile(request, "dimension");
        this.dimensionService.update(dimension, filelist, con, this.getCurrentEmployee());
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, Model model) {
        Dimension dimension = this.dimensionService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(dimension.getId());
        List<ShoppeApplyFile> oaFile = this.competitionService.getShoppeApplyFile("5" + dimension.getId());
        model.addAttribute("oaFile", oaFile);
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("dimension", (Object)dimension);
        return "dimension/view.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(String id, Model model) {
        Dimension dimension = this.dimensionService.getById(id);
        this.dimensionService.update(dimension, null, null, null);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, Model model) {
        this.dimensionService.delete(id);
        return "redirect:list.do";
    }
}

