/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.employee;

import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="employeeService")
public class EmployeeService {
    private static String defaultPwd = "111111";
    private static Map<String, Employee> employees = new HashMap<String, Employee>();
    @Autowired
    private BaseDao baseDao;

    @PostConstruct
    public void init() {
        String HQL = "from Employee";
        this.baseDao.findEntity(HQL, Employee.class);
    }

    public List<PartnerContact> find(String partnerId) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from PartnerContact where partnerId=? ");
        args.add(partnerId);
        HQL.append(" and nvl(startDate,?) <= ? and nvl(endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), PartnerContact.class);
    }

    public void save(Employee entity) {
        entity.setPassword(defaultPwd);
        this.baseDao.save((Object)entity);
    }

    public Employee get(long id) {
        return (Employee)this.baseDao.get(Employee.class, (Serializable)Long.valueOf(id));
    }

    public Employee getEmployeeCache(Long id) {
        return employees.get(id.toString());
    }

    public void update(Employee entity) {
    }

    public void delete(Long id) {
        this.baseDao.delete((Object)this.get(id));
        employees.remove(id.toString());
    }

    public void resetPwd(long id) {
        Object[] args = new Object[]{defaultPwd, id};
        this.baseDao.executeHQL("update Employee set password=? where id=?", args);
    }

    public boolean updatePwd(long id, String oldPwd, String newPwd) {
        Employee e = this.get(id);
        if (e == null || !e.getPassword().equals(oldPwd)) {
            return false;
        }
        Object[] args = new Object[]{newPwd, id};
        this.baseDao.executeHQL("update Employee set password=? where id=?", args);
        return true;
    }

    public boolean accountIsExist(Long companyId, String account, Long employeeId) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(companyId);
        args.add(account);
        String hql = "from Employee where companyId=? and account=?";
        if (employeeId != null) {
            hql = String.valueOf(hql) + " and id!=? ";
            args.add(employeeId);
        }
        return this.baseDao.exist(hql, args.toArray());
    }

    public boolean employeeIsUsed(Long companyId, Long employeeId) {
        this.get(employeeId);
        return false;
    }
}

