/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.employee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.MD5.MD5;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.employee.SaveRole;
import com.tcbj.crm.entity.ContactPartner;
import com.tcbj.crm.entity.ContactPosition;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.RoleC;
import com.tcbj.crm.entity.RoleUse;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.role.RoleService;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.siebel.service.ContactsSiebelService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/employee"})
public class PersonnelController
extends BaseController {
    @Autowired
    PersonnelService service;
    @Autowired
    RegionService cxregionmainservice;
    @Autowired
    ClientService clientService;
    @Autowired
    RoleService roleService;
    @Autowired
    ContactsSiebelService contactsSiebelService;
    @Autowired
    ShopService shopService;
    @Autowired
    PartnerShopService partnerShopService;
    @Autowired
    Cache tcbjcache;

    @RequestMapping(value={"/list.do"})
    public String List(@RequestParam(value="orgId", required=false) String orgId, String no, @RequestParam(value="contactName", required=false) String contactName, @RequestParam(value="mobile", required=false) String mobile, @RequestParam(value="pageno", required=false) Integer pageno, Model model, String partnerId) throws Exception {
        if (pageno == null || pageno == 0) {
            pageno = 1;
        }
        Page page = this.service.getPts(orgId, contactName, mobile, no, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("contactName", (Object)contactName);
        model.addAttribute("mobile", (Object)mobile);
        model.addAttribute("no", (Object)no);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/list.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String get(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id", required=false) String id, Model model) throws Exception {
        Contact emp = this.service.get(id);
        Employee ep = this.service.getEP(id);
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("emp", (Object)emp);
        model.addAttribute("region", (Object)JSON.toJSONStringWithDateFormat(emp.getRegion(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("position", (Object)JSON.toJSONStringWithDateFormat(emp.getPosition(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/view.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(@RequestParam(value="orgId", required=false) String orgId, Model model, String partnerId) throws Exception {
        Contact ep = new Contact();
        Employee e = this.getCurrentEmployee();
        String ee = e.getCurrentPartner().getOrganizationid();
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("ee", (Object)ee);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("date", (Object)DateUtils.now());
        model.addAttribute("region", (Object)JSON.toJSONString(ep.getRegion()));
        model.addAttribute("position", (Object)JSON.toJSONString(ep.getPosition()));
        model.addAttribute("partner", (Object)JSON.toJSONStringWithDateFormat(ep.getPartner(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("shopJSON", (Object)JSON.toJSONStringWithDateFormat(ep.getShop(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getAdd(@Valid @RequestBody Contact ep, BindingResult errors, HttpServletRequest request, Model model) throws Exception {
        ep.setEmpno(ep.getEmpno().trim());
        Employee em = this.getCurrentEmployee();
        ep.setPartnerOrgId(em.getCurrentPartner().getOrganizationid());
        this.service.findContactByEmpNo(ep);
        if (ep.getPersontype().equals("\u5916\u90e8")) {
            ep.setPersontype("External");
        }
        ep.fillInitData(em);
        ep.setMf(ep.getMfName());
        ep.setPersontype(ep.getPersontypeName());
        ep.setRoletype(ep.getRoletypeName());
        ep.setState("insert");
        String userId = null;
        if (StringUtils.isNotEmpty((String)ep.getPartnerId())) {
            ArrayList<PartnerShop> pts = new ArrayList<PartnerShop>();
            PartnerShop pt = this.partnerShopService.get(ep.getOrgId());
            if ("Partner".equals(pt.getOrgtype())) {
                pt.setName(pt.getName());
                pt.setId(pt.getId());
                pts.add(pt);
                userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, pts, null, ep.getPartnerId());
            } else {
                ArrayList<ShopView> sps = new ArrayList<ShopView>();
                ShopView sp = this.shopService.getShopView(pt.getId());
                sps.add(sp);
                userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, null);
            }
        } else {
            ArrayList<ShopView> sps = new ArrayList<ShopView>();
            ShopView sp = this.shopService.getShopView(ep.getOrgId());
            sps.add(sp);
            userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, ep.getPartnerId());
        }
        for (ContactRegion region : ep.getRegion()) {
            region.setUserId(userId);
            region.fillInitData(em);
        }
        for (ContactPosition position : ep.getPosition()) {
            position.setUserId(userId);
            position.fillInitData(em);
        }
        for (ContactShop shop : ep.getShop()) {
            shop.setUserId(userId);
            shop.fillInitData(em);
        }
        for (ContactPartner partner : ep.getPartner()) {
            partner.setUserId(userId);
            partner.fillInitData(em);
        }
        this.service.addRegion(ep.getRegion(), ep.getPartner(), ep.getShop(), ep.getPosition());
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="id") String id, String partnerId, Model model) throws Exception {
        Employee em = this.getCurrentEmployee();
        Contact ep = this.service.get(id);
        Employee emp = this.service.getEP(ep.getId());
        String ee = em.getCurrentPartner().getOrganizationid();
        model.addAttribute("emp", (Object)emp);
        model.addAttribute("ep", (Object)ep);
        model.addAttribute("ee", (Object)ee);
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("region", (Object)JSON.toJSONStringWithDateFormat(ep.getRegion(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("position", (Object)JSON.toJSONStringWithDateFormat(ep.getPosition(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "employee/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result update(@Valid @RequestBody Contact ep, Employee emp, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        ep.fillInitData(e);
        ep.setPartnerOrgId(e.getCurrentPartner().getOrganizationid());
        ep.setEmpno(ep.getEmpno().trim());
        this.service.findContactByEmpNo(ep);
        if (ep.getPersontype() == null) {
            ep.setPersontype("External");
        }
        ep.setPersontype(ep.getPersontypeName());
        ep.setRoletype(ep.getRoletypeName());
        ep.setState("update");
        String userId = null;
        if (StringUtils.isNotEmpty((String)ep.getPartnerId())) {
            ArrayList<PartnerShop> pts = new ArrayList<PartnerShop>();
            PartnerShop pt = this.partnerShopService.get(ep.getOrgId());
            if ("Partner".equals(pt.getOrgtype())) {
                pt.setName(pt.getName());
                pt.setId(pt.getId());
                pts.add(pt);
                userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, pts, null, ep.getPartnerId());
            } else {
                ArrayList<ShopView> sps = new ArrayList<ShopView>();
                ShopView sp = this.shopService.getShopView(pt.getId());
                sps.add(sp);
                userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, null);
            }
        } else {
            ArrayList<ShopView> sps = new ArrayList<ShopView>();
            ShopView sp = this.shopService.getShopView(ep.getOrgId());
            sps.add(sp);
            userId = this.contactsSiebelService.addOrUpdateContactsToSiebel(ep, null, sps, ep.getPartnerId());
        }
        if (ep.getAccount() != null) {
            emp.setId(ep.getId());
            emp.setAccount(ep.getAccount());
            emp.setPassword(ep.getPassword());
            this.contactsSiebelService.updateUserToSiebel(emp);
        }
        for (ContactRegion region : ep.getRegion()) {
            region.setUserId(userId);
            region.fillInitData(e);
        }
        for (ContactPosition position : ep.getPosition()) {
            position.setUserId(userId);
            position.fillInitData(e);
        }
        for (ContactShop shop : ep.getShop()) {
            shop.setUserId(userId);
            shop.fillInitData(e);
        }
        for (ContactPartner partner : ep.getPartner()) {
            partner.setUserId(userId);
            partner.fillInitData(e);
        }
        this.service.updateRegionAndPosition(ep);
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Contact ep = this.service.get(id);
        ep.setPartnerOrgId(e.getCurrentPartner().getOrganizationid());
        ep.setState("update");
        this.contactsSiebelService.delContactsToSiebel(ep);
        return "redirect:list.do?orgId=" + orgId + "&partnerId=" + partnerId;
    }

    private void refreshOnThread() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PersonnelController.this.tcbjcache.initEmployees();
            }
        };
        thread.start();
    }

    @RequestMapping(value={"upPassword.do"}, method={RequestMethod.GET})
    public String get_ps(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Employee ep, Model model) throws Exception {
        Contact c = this.service.get(id);
        Employee em = this.service.getEP(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("c", (Object)c);
        model.addAttribute("id", (Object)id);
        model.addAttribute("em", (Object)em);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/upPassword.ftl";
    }

    @RequestMapping(value={"/upPassword.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result post_ps(@RequestBody Employee ep, Model model) throws Exception {
        ep.setContactId(MD5.GetMD5Code(ep.getContactId()));
        Employee em = this.service.getEP(ep.getId());
        if (!ep.getPassword().equals(ep.getRepeatPwd())) {
            throw new AppException("0010", "\u786e\u8ba4\u5bc6\u7801\u548c\u65b0\u5bc6\u7801\u4e0d\u76f8\u540c,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (!em.getPassword().equals(ep.getContactId())) {
            throw new AppException("0010", "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ep.setPassword(MD5.GetMD5Code(ep.getPassword()));
        this.contactsSiebelService.updateUserToSiebel(ep);
        this.refreshOnThread();
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/openAccount.do"})
    public String create(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id, Employee ep, Model model) throws Exception {
        Contact c = this.service.get(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("c", (Object)c);
        model.addAttribute("id", (Object)id);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/openAccount.ftl";
    }

    @RequestMapping(value={"/saveAccount.do"})
    @ResponseBody
    public Result saveCreate(@RequestBody Employee ep, Model model) throws Exception {
        this.validateAccount(ep.getAccount());
        Contact ct = this.service.get(ep.getContactId());
        ep.setId(ct.getId());
        ep.setPassword(MD5.GetMD5Code(ep.getPassword()));
        this.contactsSiebelService.addUserToSiebel(ep);
        this.refreshOnThread();
        return this.getSuccessResult(ep.getOrgId());
    }

    @RequestMapping(value={"/reset.do"})
    @ResponseBody
    public Result reset(@RequestBody PartnerContact pc, Model model) throws Exception {
        Employee em = this.service.getEP(pc.getId());
        em.setPassword(MD5.GetMD5Code(Constant.DEFAULT_PASSWORD));
        this.contactsSiebelService.updateUserToSiebel(em);
        this.refreshOnThread();
        return this.getSuccessResult(pc.getOrgId());
    }

    @RequestMapping(value={"/openRole.do"}, method={RequestMethod.GET})
    public String addRole(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id", required=false) String id, Model model) throws Exception {
        List<RoleUse> rus;
        Employee e = this.getCurrentEmployee();
        if (e.getCurrentPartner().getOrganizationid().equals(orgId)) {
            rus = this.roleService.getRole(e.getCurrentPartner().getOrganizationid());
            model.addAttribute("rus", rus);
        } else {
            rus = this.roleService.getByOrgId(e.getCurrentPartner().getOrganizationid());
            model.addAttribute("rus", rus);
        }
        List<RoleC> rcs = this.service.getRCS(id);
        HashMap<String, RoleC> roleMap = new HashMap<String, RoleC>();
        int i = 0;
        while (i < rcs.size()) {
            roleMap.put(rcs.get(i).getRoleId(), rcs.get(i));
            ++i;
        }
        model.addAttribute("roleMap", roleMap);
        model.addAttribute("id", (Object)id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partnerId", (Object)partnerId);
        return "employee/openRole.ftl";
    }

    @RequestMapping(value={"/saveRole.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@RequestBody SaveRole a, Model model) throws Exception {
        this.service.delete(a.getId());
        String[] ruIds = a.getRuId().split(",");
        int i = 0;
        while (i < ruIds.length) {
            String ruId = ruIds[i];
            if (!StringUtils.isEmpty((String)ruId)) {
                Employee e = this.getCurrentEmployee();
                RoleC rc = new RoleC();
                rc.setRoleId(ruId);
                rc.setUserId(a.getId());
                rc.setEndDate(DateUtils.now());
                rc.setStartDate(DateUtils.now());
                rc.fillInitData(e);
                this.service.save(rc);
            }
            ++i;
        }
        return this.getSuccessResult(a.getOrgId());
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.getChildNodeTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"orgTree.do"}, method={RequestMethod.GET})
    public String tree(Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner pt = this.service.getById(e.getCurrentPartner().getId());
        String tree = this.service.getOrgTree(pt);
        String orgId = e.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "employee/orgTree.ftl";
    }

    public void validateAccount(String account) throws Exception {
        boolean isExist = this.service.isAccount(account);
        if (isExist) {
            throw new AppException("5101");
        }
    }

    @RequestMapping(value={"updateEP.do"}, method={RequestMethod.GET})
    public String edit(Model model) throws Exception {
        Employee ep = this.getCurrentEmployee();
        Employee em = this.service.getEP(ep.getId());
        Contact cv = this.service.get(ep.getId());
        model.addAttribute("cv", (Object)cv);
        model.addAttribute("em", (Object)em);
        return "employee/updateEP.ftl";
    }

    @RequestMapping(value={"updateEP.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add(@RequestBody Contact cv, String result, Model model) throws Exception {
        cv.setState("update");
        Employee ep = this.getCurrentEmployee();
        Contact ct = this.service.get(ep.getId());
        cv.setFullname(ct.getFullname());
        cv.setHiredate(cv.getHiredate());
        cv.setPartnerOrgId(ct.getPartnerOrgId());
        cv.setStartdate(ct.getStartdate());
        cv.setPersontype(ct.getPersontypeName());
        cv.setRoletype(ct.getRoletypeName());
        this.contactsSiebelService.addOrUpdateContactsToSiebel(cv, null, null, null);
        if (StringUtils.isNotEmpty((String)cv.getPassword()) && StringUtils.isNotEmpty((String)cv.getNewPassword()) && StringUtils.isNotEmpty((String)cv.getIsPassword())) {
            if (!ep.getPassword().equals(MD5.GetMD5Code(cv.getPassword()))) {
                throw new AppException("0010", "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            if (!cv.getNewPassword().equals(cv.getIsPassword())) {
                throw new AppException("0010", "\u65b0\u5bc6\u7801\u548c\u786e\u8ba4\u5bc6\u7801\u4e0d\u76f8\u540c,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            ep.setPassword(MD5.GetMD5Code(cv.getNewPassword()));
            this.contactsSiebelService.updateUserToSiebel(ep);
        }
        model.addAttribute("result", (Object)result);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, String orgId, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            String result = this.service.getChildTree(id, orgId);
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"areaTree.do"})
    public String artree(@RequestParam(value="isMultipleChoice", required=false) String isMultipleChoice, String orgId, String partnerId, Model model) throws Exception {
        Partner p = null;
        if (partnerId.equals("")) {
            Employee e = this.getCurrentEmployee();
            p = this.service.getById(e.getCurrentPartner().getId());
        } else {
            p = this.service.getById(orgId);
        }
        String tree = this.service.areaTree(p);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "employee/areaTree.ftl";
    }

    @RequestMapping(value={"logout.do"})
    @ResponseBody
    public String logout(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="partnerId", required=false) String partnerId, @RequestParam(value="id") String id) throws Exception {
        Contact ct = this.service.get(id);
        this.service.deleteRegionAndPosition(id);
        PartnerShop pt = this.partnerShopService.get(orgId);
        if ("Partner".equals(pt.getOrgtype())) {
            ct.setPartnerId(partnerId);
            ct.setState("update");
            this.contactsSiebelService.loginOut(ct);
        } else {
            ct.setState("update");
            this.contactsSiebelService.loginOut(ct);
        }
        return "true";
    }

    @RequestMapping(value={"/selectPartner.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page get_page(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ClientCondition con) {
        try {
            if (com.tcbj.util.StringUtils.isNotEmpty(con.getName())) {
                con.setName(new String(con.getName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.clientService.findPartnerApplyers(con, pageno);
        return page;
    }

    @RequestMapping(value={"/getPartners.do"})
    public String get_partner(String partnerId, String userId, Model model) {
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("userId", (Object)userId);
        return "employee/selectPartner.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editPartner(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        Page page = this.service.getPagePartner(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/intoselectshop.do"}, method={RequestMethod.GET})
    public String selectProductView(String userId, Model model) {
        model.addAttribute("userId", (Object)userId);
        return "employee/shopList.ftl";
    }

    @RequestMapping(value={"/selectshop.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getSelectShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) throws Exception {
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(new String(condition.getName().getBytes("iso8859-1"), "UTF-8"));
        }
        Page page = this.shopService.getSelectShop(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/editShop.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        try {
            if (StringUtils.isNotEmpty((String)condition.getShopName())) {
                condition.setShopName(new String(condition.getShopName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.service.getShop(condition, pageno);
        return page;
    }
}

