/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.employee;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.ContactPartner;
import com.tcbj.crm.entity.ContactPosition;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.RoleC;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.notice.NoticeCondition;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="personnelService")
public class PersonnelService {
    @Autowired
    private BaseDao baseDao;

    public Page getPts(String partnerId, String contactName, String mobile, String no, int pageno) throws Exception {
        String hql = "from PartnerContact p where p.partnerId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        if (StringUtils.isNotBlank((String)contactName)) {
            hql = String.valueOf(hql) + " and p.contactName like ? ";
            args.add("%" + contactName.trim() + "%");
        }
        if (StringUtils.isNotEmpty((String)no)) {
            hql = String.valueOf(hql) + " and p.no like ? ";
            args.add("%" + no.trim() + "%");
        }
        if (StringUtils.isNotEmpty((String)mobile)) {
            hql = String.valueOf(hql) + "and p.mobile = ?";
            args.add(mobile);
        }
        hql = String.valueOf(hql) + " order by p.createDt desc ";
        return this.baseDao.search(hql, args.toArray(), 10, pageno);
    }

    public List<Employee> getPCS(String partnerId, NoticeCondition noticeCondition) throws Exception {
        String hql = "from Employee p,Partner e,EmployeePartner t where p.id = t.personId and e.id = t.id ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)noticeCondition.getContactName())) {
            hql = String.valueOf(hql) + " and p.name like ? ";
            args.add("%" + noticeCondition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty((String)noticeCondition.getDealerId())) {
            hql = String.valueOf(hql) + " and e.id = ? ";
            args.add(noticeCondition.getDealerId());
        }
        if (StringUtils.isNotEmpty((String)noticeCondition.getPersontype())) {
            hql = String.valueOf(hql) + " and p.type = ? ";
            args.add(noticeCondition.getPersontype());
        }
        if (StringUtils.isNotEmpty((String)noticeCondition.getSaleChannelTypeCode())) {
            hql = String.valueOf(hql) + " and e.saleChannelTypeCode = ? ";
            args.add(noticeCondition.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty((String)noticeCondition.getBigAreaCode())) {
            hql = String.valueOf(hql) + " and e.bigAreaCode = ? ";
            args.add(noticeCondition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty((String)noticeCondition.getAreaCode())) {
            hql = String.valueOf(hql) + " and e.areaCode = ? ";
            args.add(noticeCondition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql, args.toArray(), Object[].class);
        ArrayList<Employee> result = new ArrayList<Employee>();
        for (Object[] objs : list) {
            Employee e = (Employee)objs[0];
            e.setCurrentPartner((EmployeePartner)objs[2]);
            result.add(e);
        }
        return result;
    }

    public Partner getPT(String id) throws Exception {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public List<Shop> getSPS() throws Exception {
        String hql = "from Shop s ";
        return this.baseDao.findEntity(hql, Shop.class);
    }

    public Shop getBySiebelShopId(String siebelShopId) throws Exception {
        String hql = "from Shop s where s.siebelShopId = ?";
        List sps = this.baseDao.findEntity(hql, new Object[]{siebelShopId}, Shop.class);
        return sps.size() == 0 ? null : (Shop)sps.get(0);
    }

    public Employee getEP(String id) throws Exception {
        return (Employee)this.baseDao.get(Employee.class, (Serializable)((Object)id));
    }

    public List<ContactRegion> getRegion(String id) {
        String hql = "from ContactRegion s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactRegion.class);
    }

    public List<ContactPosition> getPost(String id) {
        String hql = "from ContactPosition s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactPosition.class);
    }

    public List<ContactShop> getShop(String id) {
        String hql = "from ContactShop s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, ContactShop.class);
    }

    public Page getShop(ShopCondition condition, int pageno) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from ContactShop c,ShopView s where c.shopId = s.id and c.userId = ?";
        args.add(condition.getUserId());
        if (StringUtils.isNotEmpty((String)condition.getShopName())) {
            hql = String.valueOf(hql) + " and s.shopName like ? ";
            args.add("%" + condition.getShopName() + "%");
        }
        if (StringUtils.isNotEmpty((String)condition.getShopNo())) {
            String[] shopNo = condition.getShopNo().split(",");
            hql = String.valueOf(hql) + " and ( s.shopNumber like ? ";
            args.add("%" + shopNo[0] + "%");
            int i = 1;
            while (i < shopNo.length) {
                hql = String.valueOf(hql) + " or s.shopNumber like ? ";
                args.add("%" + shopNo[i] + "%");
                ++i;
            }
            hql = String.valueOf(hql) + " ) ";
        }
        hql = String.valueOf(hql) + " order by s.shopNumber ";
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            ContactShop contactShop = (ContactShop)obj[0];
            ShopView shopView = (ShopView)obj[1];
            contactShop.setShopName(shopView.getShopName());
            contactShop.setShopNo(shopView.getShopNumber());
            list.add(contactShop);
            ++i;
        }
        page.setList(list);
        return page;
    }

    public List<ContactPartner> getPartner(String userId) {
        String hql = "from ContactPartner s where s.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactPartner.class);
    }

    public String getPartnerIds(String userId) {
        List<ContactPartner> list = this.getPartner(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ContactPartner iter : list) {
            if (iter.getEnddate() != null && DateUtils.now().compareTo(iter.getEnddate()) < 0) {
                set.add(iter.getApplyerId());
                continue;
            }
            if (iter.getEnddate() != null) continue;
            set.add(iter.getApplyerId());
        }
        StringBuffer sb = new StringBuffer();
        if (set.size() > 0) {
            for (String p : set) {
                sb.append("'").append(p).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<String> getPartnerIdsByUserId(String userId) {
        List<ContactPartner> list = this.getPartner(userId);
        ArrayList<String> set = new ArrayList<String>();
        for (ContactPartner iter : list) {
            if (iter.getEnddate() != null && DateUtils.now().compareTo(iter.getEnddate()) < 0) {
                set.add(iter.getApplyerId());
                continue;
            }
            if (iter.getEnddate() != null) continue;
            set.add(iter.getApplyerId());
        }
        return set;
    }

    public Page getPagePartner(ShopCondition condition, int pageno) {
        String hql = "from ContactPartner s where s.userId = ?";
        return this.baseDao.search(hql.toString(), new Object[]{condition.getUserId()}, condition.getRowsize().intValue(), pageno);
    }

    public Contact get(String id) throws Exception {
        Contact v = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)id));
        v.setRegion(this.getRegion(id));
        v.setPosition(this.getPost(id));
        v.setPartner(this.getPartner(id));
        v.setShop(this.getShop(id));
        return v;
    }

    public void findContactByEmpNo(Contact ep) {
        Contact contact;
        String empNo = ep.getEmpno();
        String id = ep.getId();
        ArrayList<String> obj = new ArrayList<String>();
        String hql = " from Contact where 1=1 ";
        if (com.tcbj.util.StringUtils.isNotEmpty(empNo)) {
            hql = String.valueOf(hql) + " and empno = ? ";
            obj.add(empNo);
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id <> ? ";
            obj.add(id);
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(ep.getPartnerOrgId())) {
            hql = String.valueOf(hql) + " and partnerOrgId = ? ";
            obj.add(ep.getPartnerOrgId());
        }
        if ((contact = (Contact)this.baseDao.findFirstEntity(hql, obj.toArray(), Contact.class)) != null) {
            throw new AppException("0010", "\u5458\u5de5\u7f16\u53f7\uff1a" + empNo + "\u5df2\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u5176\u4ed6\u7f16\u53f7");
        }
    }

    public void add(Employee ep) throws Exception {
        this.baseDao.save((Object)ep);
    }

    public void addRegion(List<ContactRegion> sps, List<ContactPartner> cps, List<ContactShop> sts, List<ContactPosition> cts) {
        this.baseDao.save(sps);
        this.baseDao.save(cps);
        this.baseDao.save(sts);
        this.baseDao.save(cts);
    }

    public void addPartner(List<ContactPartner> cps) {
        this.baseDao.save(cps);
    }

    public void updateRegionAndPosition(Contact cv) {
        int n;
        int n2;
        String[] stringArray;
        Object[] args = new Object[]{cv.getId()};
        this.baseDao.executeHQL("delete ContactRegion where userId=?", args);
        this.baseDao.executeHQL("delete ContactPosition where userId=?", args);
        this.baseDao.save(cv.getRegion());
        this.baseDao.save(cv.getPosition());
        if (StringUtils.isNotEmpty((String)cv.getPartnerIds())) {
            stringArray = cv.getPartnerIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(ContactPartner.class, (Serializable)((Object)id));
                ++n;
            }
        }
        int i = 0;
        while (i < cv.getPartner().size()) {
            if (StringUtils.isNotEmpty((String)cv.getPartner().get(i).getId())) {
                this.baseDao.update((Object)cv.getPartner().get(i));
            } else {
                this.baseDao.save((Object)cv.getPartner().get(i));
            }
            ++i;
        }
        if (StringUtils.isNotEmpty((String)cv.getShopIds())) {
            stringArray = cv.getShopIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(ContactShop.class, (Serializable)((Object)id));
                ++n;
            }
        }
        i = 0;
        while (i < cv.getShop().size()) {
            if (StringUtils.isNotEmpty((String)cv.getShop().get(i).getId())) {
                this.baseDao.update((Object)cv.getShop().get(i));
            } else {
                this.baseDao.save((Object)cv.getShop().get(i));
            }
            ++i;
        }
    }

    public void addPosition(List<ContactPosition> sts) {
        this.baseDao.save(sts);
    }

    public void updatePosition(List<ContactPosition> sts) {
        this.baseDao.update(sts);
    }

    public void update(Employee ep) throws Exception {
        this.baseDao.update((Object)ep);
    }

    public void delete(Contact ep) throws Exception {
        this.baseDao.delete((Object)ep);
    }

    public Partner getById(String id) throws Exception {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public String getChildNodeTree(String id, String orgId) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        List pns = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pns) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)pn.getId());
            node.put("pId", (Object)pn.getParentId());
            node.put("name", (Object)pn.getRegionName());
            node.put("iconSkin", (Object)"start");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
        }
        List cts = this.baseDao.findEntity("from Customer c where c.areaCode = ? and c.supplierId = ? order by startDate ", new Object[]{id, orgId}, Customer.class);
        for (Customer ct : cts) {
            JSONObject node1 = new JSONObject();
            node1.put("id", (Object)ct.getApplyerId());
            node1.put("pId", (Object)ct.getSupplierId());
            node1.put("name", (Object)ct.getApplyerName());
            node1.put("iconSkin", (Object)"root");
            node1.put("partnerId", (Object)"partnerId");
            node1.put("isParent", (Object)"true");
            node1.put("url", (Object)"/employee/list");
            nodes.put((Object)node1);
        }
        List cms = this.baseDao.findEntity("from Customer c where c.supplierId = ? order by startDate ", new Object[]{id}, Customer.class);
        for (Customer cm : cms) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)cm.getApplyerId());
            node2.put("pId", (Object)cm.getSupplierId());
            node2.put("name", (Object)cm.getApplyerName());
            node2.put("iconSkin", (Object)"root");
            node2.put("partnerId", (Object)"partnerId");
            node2.put("isParent", (Object)"true");
            node2.put("url", (Object)"/employee/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public List<Partner> getPTS(String parentPartnerId) {
        String hql = "from Partner p where p.parentPartnerId = ?";
        return this.baseDao.findEntity(hql, new Object[]{parentPartnerId}, Partner.class);
    }

    public String getOrgTree(Partner pt) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)pt.getId());
        rootNode.put("pId", (Object)pt.getParentPartnerId());
        rootNode.put("name", (Object)pt.getName());
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("open", (Object)"true");
        rootNode.put("url", (Object)"/employee/list");
        rootNode.put("partnerId", (Object)"partnerId");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by c.created ", new Object[]{pt.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)pt.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("iconSkin", (Object)"start");
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        List<DictionaryItem> des = Cache.getItems("TCBJ_STORE_TYPE");
        for (DictionaryItem de : des) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)de.getName());
            node.put("pId", (Object)pt.getId());
            node.put("name", (Object)de.getVal());
            node.put("url", (Object)"/employee/list");
            node.put("level", (Object)"level");
            node.put("iconSkin", (Object)"MD");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
            List sps = this.baseDao.findEntity("from ShopView s where s.parentDealerId = ? and s.shopType = ? order by startDate", new Object[]{pt.getId(), de.getName()}, ShopView.class);
            for (ShopView sp : sps) {
                JSONObject node1 = new JSONObject();
                node1.put("id", (Object)sp.getId());
                node1.put("pId", (Object)de.getName());
                node1.put("name", (Object)sp.getShopName());
                node1.put("isParent", (Object)"true");
                node1.put("nocheck", (Object)"true");
                node1.put("url", (Object)"/employee/list");
                node1.put("level", (Object)"level");
                nodes.put((Object)node1);
            }
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public void save(RoleC rc) throws Exception {
        this.baseDao.save((Object)rc);
    }

    public void delete(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete RoleC where userId=?", args);
    }

    public List<RoleC> getRCS(String id) throws Exception {
        String hql = " from RoleC r where r.userId = ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, RoleC.class);
    }

    public boolean isAccount(String account) throws Exception {
        boolean isExist = false;
        String hql = "from Employee e where e.account =? ";
        List emps = this.baseDao.findEntity(hql, new Object[]{account}, Employee.class);
        if (emps.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public String getChildTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getRegionName());
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String areaTree(Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u533a\u57df\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("nocheck", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and startDt < ? and (endDt > ? or endDt is null) order by created ", new Object[]{p.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)p.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("nocheck", (Object)"true");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public EmployeePartner getByPId(String personId) throws Exception {
        String hql = "from EmployeePartner e where e.personId = ? ";
        List eps = this.baseDao.findEntity(hql, new Object[]{personId}, EmployeePartner.class);
        return eps.size() == 0 ? null : (EmployeePartner)eps.get(0);
    }

    public List<PartnerContact> getByPartnerId(String partnerId) {
        String hql = " select distinct(p) from PartnerContact p where p.partnerId =? ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId}, PartnerContact.class);
    }

    public List<ContactRegion> getRegionsByUser(String userId) {
        String hql = " from ContactRegion  c , ShopViewContats  sc  where c.userId = ? and sc.dutyType='Region Manager' ";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactRegion.class);
    }

    public List<ContactRegion> getRegionsByUserId(String userId) {
        String hql = " from ContactRegion c where c.userId = ? ";
        hql = String.valueOf(hql) + " and sysdate between nvl(c.startDate, sysdate-1) and nvl(c.endDate, sysdate+1) ";
        return this.baseDao.findEntity(hql, new Object[]{userId}, ContactRegion.class);
    }

    public String getFRegionsByUserId(String userId) {
        List<Region> newlist = this.getRegions(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getId());
        }
        StringBuffer sb = this.getIdBySb(set);
        return sb.substring(0, sb.length() - 1);
    }

    private List<Region> getRegions(String userId) {
        List<ContactRegion> list = this.getRegionsByUserId(userId);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (ContactRegion contactRegion : list) {
            newlist.add(map.get(contactRegion.getRegionId()));
            if (map.get(contactRegion.getRegionId()).getChildList().size() <= 0) continue;
            for (Region region : map.get(contactRegion.getRegionId()).getChildList()) {
                newlist.add(region);
            }
        }
        return newlist;
    }

    private StringBuffer getIdBySb(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        if (set.size() > 0) {
            for (String p : set) {
                sb.append("'").append(p).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb;
    }

    public String getChannelIdByUserId(String userId) {
        List<Region> newlist = this.getRegions(userId);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getParentId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getParentId());
        }
        String hql = " from ChannelType c where c.id in (?) and startDt < ? and (endDt > ? or endDt is null) ";
        StringBuffer sb = this.getIdBySb(set);
        List list = this.baseDao.findEntity(hql, new Object[]{sb.toString(), new Date(), new Date()}, ChannelType.class);
        if (list.size() > 0) {
            for (ChannelType p : list) {
                sb.append("'").append(p.getId()).append("',");
            }
        } else {
            sb.append("'1-2-3',");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public List<Region> getBigareasByList(String userId) {
        String idString = this.getFRegionsByUserId(userId);
        String hql = "select r from ChannelType ct,Region r where r.parentId = ct.id and r.id in(" + idString + ") ";
        return this.baseDao.findEntity(hql, Region.class);
    }

    public List<Region> getAreasByList(String userId) {
        String idString = this.getFRegionsByUserId(userId);
        String hql = "from Region where id in (" + idString + ") and id not in( select r from ChannelType ct,Region r where r.parentId = ct.id and r.id in(" + idString + ")) ";
        return this.baseDao.findEntity(hql, Region.class);
    }

    public String getFRegionsById(String paetnerId, String saleChannelTypeId, String bigAreaId) {
        List list = null;
        list = StringUtils.isEmpty((String)bigAreaId) ? this.baseDao.findEntity("from Region where parentId =? and orgId = ? ", new Object[]{saleChannelTypeId, paetnerId}, Region.class) : this.baseDao.findEntity("from Region where parentId =? and orgId = ? ", new Object[]{bigAreaId, paetnerId}, Region.class);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (Region region : list) {
            newlist.add(map.get(region.getId()));
            if (map.get(region.getId()).getChildList().size() <= 0) continue;
            for (Region region2 : map.get(region.getId()).getChildList()) {
                newlist.add(region2);
            }
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region region : newlist) {
            if (region.getEndDate() != null && DateUtils.now().compareTo(region.getEndDate()) < 0) {
                set.add(region.getId());
                continue;
            }
            if (region.getEndDate() != null) continue;
            set.add(region.getId());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (set.size() > 0) {
            for (String string : set) {
                stringBuffer.append("'").append(string).append("',");
            }
        } else {
            stringBuffer.append("'1-2-3',");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public Set<String> getRegionsByDutyType(String userId) {
        List<ContactRegion> list = this.getRegionsByUser(userId);
        Map<String, Region> map = Cache.getRegion();
        ArrayList<Region> newlist = new ArrayList<Region>();
        for (ContactRegion contactRegion : list) {
            newlist.add(map.get(contactRegion.getRegionId()));
            if (map.get(contactRegion.getRegionId()).getChildList().size() <= 0) continue;
            for (Region region : map.get(contactRegion.getRegionId()).getChildList()) {
                newlist.add(region);
            }
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Region iter : newlist) {
            if (iter.getEndDate() != null && DateUtils.now().compareTo(iter.getEndDate()) < 0) {
                set.add(iter.getId());
                continue;
            }
            if (iter.getEndDate() != null) continue;
            set.add(iter.getId());
        }
        System.out.println(set.size());
        return set;
    }

    public void deleteRegionAndPosition(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete ContactRegion where userId=?", args);
        this.baseDao.executeHQL("delete ContactPosition where userId=?", args);
        this.baseDao.executeHQL("delete ContactPartner where userId=?", args);
        this.baseDao.executeHQL("delete ContactShop where userId=?", args);
    }

    public List<ContactRegion> getUserByRegion(String regionId) {
        String hql = " from ContactRegion where regionId= ? ";
        return this.baseDao.findEntity(hql, new Object[]{regionId}, ContactRegion.class);
    }

    public List<Partner> getOrgPartners(String orgId) {
        String hql = "from Partner p where p.masterOuId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{orgId}, Partner.class);
    }

    public List<PartnerContact> getByOrgId(String orgId) {
        String hql = "from PartnerContact p where p.partnerId = ?";
        return this.baseDao.findEntity(hql, new Object[]{orgId}, PartnerContact.class);
    }

    public void addShop(List<ContactShop> sts) {
        this.baseDao.save(sts);
    }

    public List<Employee> getEmps() {
        String hql = "from Employee";
        return this.baseDao.findEntity(hql, new Object[0], Employee.class);
    }

    public Map<String, String> getByOrgMap(String orgId) {
        String hql = "from PartnerContact p where p.partnerId = ?";
        List list = this.baseDao.findEntity(hql, new Object[]{orgId}, PartnerContact.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PartnerContact pc : list) {
            map.put(String.valueOf(pc.getContactName()) + "_" + pc.getMobile(), pc.getId());
        }
        return map;
    }
}

