/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.entity.base;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.base.BaseEntity;
import com.tcbj.crm.view.Employee;
import com.tcbj.spring.serializer.CustomDateSerializer;
import com.tcbj.util.DateUtils;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BasePartnerAddress
extends BaseEntity {
    protected String id;
    protected String addressTypeCode;
    protected String address;
    protected String cityCode;
    protected String countryCode;
    protected String countyCode;
    protected String provinceCode;
    protected String receiveTimeCode;
    protected Date startDt;
    protected Date endDt;
    protected String contactCode;
    protected String contactPhone;
    protected String zip;
    protected String partnerId;
    protected String cityManagerId;
    protected String disDelearId;
    protected String harvestWarehouse;
    protected Date createDt;
    protected String creatorId;
    protected Date lastUpdateDt;
    protected String lastUpdatorId;
    protected String siebelId;

    public BasePartnerAddress() {
        this.setCountryCode("China");
    }

    @Override
    public void fillInitData(Employee e) {
        this.setCreateDt(DateUtils.now());
        this.setCreatorId(e.getId());
        this.setLastUpdateDt(DateUtils.now());
        this.setLastUpdatorId(e.getId());
    }

    public String getDisDelearId() {
        return this.disDelearId;
    }

    public String getDisDelearName() {
        return Cache.getApplyerName(this.getDisDelearId());
    }

    public void setDisDelearId(String disDelearId) {
        this.disDelearId = disDelearId;
    }

    public String getHarvestWarehouse() {
        return this.harvestWarehouse;
    }

    public String getHarvestWarehouseName() {
        return Cache.getStorageName(this.getHarvestWarehouse());
    }

    public void setHarvestWarehouse(String harvestWarehouse) {
        this.harvestWarehouse = harvestWarehouse;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddressTypeCode() {
        return this.addressTypeCode;
    }

    public String getAddressTypeName() {
        return Cache.getItemName("ADDR_TYPE", this.getAddressTypeCode());
    }

    public void setAddressTypeCode(String addressTypeCode) {
        this.addressTypeCode = addressTypeCode;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getCityName() {
        return Cache.getItemName("TCBJ_CITY", this.getCityCode());
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryName() {
        return Cache.getItemName("COUNTRY", this.getCountryCode());
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountyCode() {
        return this.countyCode;
    }

    public String getCountyName() {
        return Cache.getItemName("COUNTY", this.getCountyCode());
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public String getProvinceName() {
        return Cache.getItemName("STATE_ABBREV", this.getProvinceCode());
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getReceiveTimeCode() {
        return this.receiveTimeCode;
    }

    public String getReceiveTimeName() {
        return Cache.getItemName("TCBJ_RECEIVE_DATE_TYPE", this.getReceiveTimeCode());
    }

    public void setReceiveTimeCode(String receiveTimeCode) {
        this.receiveTimeCode = receiveTimeCode;
    }

    @JsonSerialize(using=CustomDateSerializer.class)
    public Date getStartDt() {
        return this.startDt;
    }

    public void setStartDt(Date startDt) {
        this.startDt = startDt;
    }

    @JsonSerialize(using=CustomDateSerializer.class)
    public Date getEndDt() {
        return this.endDt;
    }

    public void setEndDt(Date endDt) {
        this.endDt = endDt;
    }

    public String getContactCode() {
        return this.contactCode;
    }

    public void setContactCode(String contactCode) {
        this.contactCode = contactCode;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @Override
    public Date getCreateDt() {
        return this.createDt;
    }

    @Override
    public void setCreateDt(Date createDt) {
        this.createDt = createDt;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    @Override
    public Date getLastUpdateDt() {
        return this.lastUpdateDt;
    }

    @Override
    public void setLastUpdateDt(Date lastUpdateDt) {
        this.lastUpdateDt = lastUpdateDt;
    }

    @Override
    public String getLastUpdatorId() {
        return this.lastUpdatorId;
    }

    @Override
    public void setLastUpdatorId(String lastUpdatorId) {
        this.lastUpdatorId = lastUpdatorId;
    }

    public String getCityManagerId() {
        return this.cityManagerId;
    }

    public String getCityManagerName() {
        return Cache.getEmployeeName(this.getCityManagerId());
    }

    public void setCityManagerId(String cityManagerId) {
        this.cityManagerId = cityManagerId;
    }

    public String getSiebelId() {
        return this.siebelId;
    }

    public void setSiebelId(String siebelId) {
        this.siebelId = siebelId;
    }
}

