/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.exception;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.exception.AuthenticateException;
import com.tcbj.crm.exception.BaseException;
import com.tcbj.crm.exception.ErrorInfo;
import com.tcbj.crm.exception.ErrorResult;
import com.tcbj.crm.exception.ValidateException;
import com.tcbj.crm.util.ServletContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class MyExceptionResolver
extends SimpleMappingExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (request.getHeader("accept").indexOf("application/json") <= -1 && (request.getHeader("X-Requested-With") == null || request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") <= -1)) {
            String message = null;
            if (ex instanceof BaseException) {
                ApplicationContext ac = ServletContextUtils.getContext();
                if (StringUtils.isNotEmpty((String)ex.getMessage())) {
                    message = ex.getMessage();
                } else {
                    String code = ((BaseException)ex).getCode();
                    Object[] args = ((BaseException)ex).getArgs();
                    if (StringUtils.isNotEmpty((String)code)) {
                        message = ac.getMessage(code, args, null);
                    }
                }
            } else {
                if (ex instanceof MaxUploadSizeExceededException) {
                    ApplicationContext ac = ServletContextUtils.getContext();
                    message = ac.getMessage("0090", null, null);
                    try {
                        ErrorResult er = new ErrorResult("-1", "other", message);
                        PrintWriter writer = response.getWriter();
                        writer.write(JSON.toJSONString((Object)er));
                        writer.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
                message = null;
            }
            request.setAttribute("ctx", (Object)request.getContextPath());
            request.setAttribute("SYSTEM_ERROR", (Object)message);
            return super.doResolveException(request, response, handler, ex);
        }
        try {
            ApplicationContext ac;
            String status = "-1";
            String type = null;
            Object data = null;
            if (ex instanceof AuthenticateException) {
                type = "authentication";
            } else if (ex instanceof ValidateException) {
                type = "validation";
                ac = ServletContextUtils.getContext();
                BindingResult errors = ((ValidateException)ex).getErrors();
                List fes = errors.getFieldErrors();
                ArrayList<ErrorInfo> infos = new ArrayList<ErrorInfo>();
                for (FieldError fe : fes) {
                    String msg = ac.getMessage(fe.getCode(), null, null);
                    infos.add(new ErrorInfo(fe.getField(), msg));
                }
                data = infos;
            } else if (ex instanceof BaseException) {
                type = "business";
                ac = ServletContextUtils.getContext();
                if (StringUtils.isNotEmpty((String)ex.getMessage())) {
                    data = ex.getMessage();
                } else {
                    String code = ((BaseException)ex).getCode();
                    Object[] args = ((BaseException)ex).getArgs();
                    if (StringUtils.isNotEmpty((String)code)) {
                        data = ac.getMessage(code, args, null);
                    }
                }
            } else {
                type = "other";
                data = "\u7cfb\u7edf\u51fa\u73b0\u4e86\u5c0f\u95ee\u9898,\u8bf7\u7a0d\u540e\u91cd\u8bd5......";
            }
            ErrorResult er = new ErrorResult(status, type, data);
            PrintWriter writer = response.getWriter();
            writer.write(JSON.toJSONString((Object)er));
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

