/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expapply;

import com.tcbj.crm.budget.BudgetService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.entity.ExpApply;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.entity.PactExpense;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.expapply.ExpCondition;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.ExpApplyView;
import com.tcbj.crm.view.ExpBalanceView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="expapplyService")
public class ExpService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private BudgetService budgetService;

    public ExpApply get(String id) {
        return this.getExpApply(id);
    }

    public ExpApply getExpApply(String id) {
        return (ExpApply)this.baseDao.get(ExpApply.class, (Serializable)((Object)id));
    }

    public ExpBalance getExpBalance(String id) {
        return (ExpBalance)this.baseDao.get(ExpBalance.class, (Serializable)((Object)id));
    }

    public void delApply(String id) {
        ExpApply expApply = this.getExpApply(id);
        this.updateUsingAmount(expApply.getSupplierId(), expApply.getYear(), expApply.getBudgetTargetType(), expApply.getBudgetTargetId(), expApply.getExpensesItemCode(), 0.0 - expApply.getAmount());
        this.baseDao.delete((Object)expApply);
    }

    public void delBalance(String id) {
        ExpApply apply;
        ExpBalance expBalance = this.getExpBalance(id);
        this.updateUsedAmount(expBalance.getSupplierId(), expBalance.getYear(), expBalance.getBudgetTargetType(), expBalance.getBudgetTargetId(), expBalance.getExpensesItemCode(), 0.0 - expBalance.getAmount(), true);
        this.baseDao.delete((Object)expBalance);
        if (StringUtils.isNotEmpty(expBalance.getApplyId()) && (apply = this.getExpApply(expBalance.getApplyId())) != null) {
            apply.setBalanceId(null);
            this.baseDao.update((Object)apply);
        }
    }

    public ExpApplyView getExpApplyView(String id) {
        return (ExpApplyView)this.baseDao.get(ExpApplyView.class, (Serializable)((Object)id));
    }

    public ExpBalanceView getExpBalanceView(String id) {
        return (ExpBalanceView)this.baseDao.get(ExpBalanceView.class, (Serializable)((Object)id));
    }

    public Page getApplyPage(ExpCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExpApplyView where 1=1 ");
        if (StringUtils.isNotEmpty(con.getOperatorId())) {
            hql.append(" and operatorId = ? ");
            args.add(con.getOperatorId());
        }
        if (con.getYear() != null) {
            hql.append(" and year = ? ");
            args.add(con.getYear());
        }
        if (con.getStartDt() != null) {
            hql.append(" and operateDt >= ? ");
            args.add(con.getStartDt());
        }
        if (con.getEndDt() != null) {
            hql.append(" and operateDt <= ? ");
            args.add(con.getEndDt());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and no like ? ");
            args.add("%" + con.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getExpensesTypeCode())) {
            hql.append(" and expensesTypeCode = ? ");
            args.add(con.getExpensesTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getExpensesItemCode())) {
            hql.append(" and expensesItemCode = ? ");
            args.add(con.getExpensesItemCode());
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            hql.append(" and applyerId = ? ");
            args.add(con.getApplyerId());
        }
        if (StringUtils.isNotEmpty(con.getIsBalanceSel()) && "Y".equals(con.getIsBalanceSel())) {
            hql.append(" and balanceId is null ");
            hql.append(" and source = 'csp' ");
        }
        hql.append("order by operateDt desc");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page getBalancePage(ExpCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExpBalanceView where 1=1 ");
        if (StringUtils.isNotEmpty(con.getOperatorId())) {
            hql.append(" and operatorId = ? ");
            args.add(con.getOperatorId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql.append(" and year = ? ");
            args.add(con.getYear());
        }
        hql.append(" order by operateDt desc");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void saveApply(String orgId, ExpApply expApply) {
        if (expApply.getAmount() <= 0.0) {
            throw new AppException("0010", "\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        this.baseDao.save((Object)expApply);
        this.updateUsingAmount(orgId, expApply.getYear(), expApply.getBudgetTargetType(), expApply.getBudgetTargetId(), expApply.getExpensesItemCode(), expApply.getAmount());
    }

    public void saveBalanceByJob(String orgId, ExpBalance expBalance) {
        if (expBalance.getAmount() <= 0.0) {
            return;
        }
        boolean withApply = false;
        ExpApply apply = null;
        if (StringUtils.isNotEmpty(expBalance.getApplyId())) {
            apply = this.getExpApply(expBalance.getApplyId());
            if (apply == null) {
                return;
            }
            if (expBalance.getAmount() > apply.getAmount()) {
                return;
            }
            withApply = true;
        }
        this.baseDao.save((Object)expBalance);
        if (apply != null) {
            apply.setBalanceId(expBalance.getId());
            this.baseDao.update((Object)apply);
        }
        this.updateUsedAmount(orgId, expBalance.getYear(), expBalance.getBudgetTargetType(), expBalance.getBudgetTargetId(), expBalance.getExpensesItemCode(), expBalance.getAmount(), withApply);
    }

    public void saveBalance(String orgId, ExpBalance expBalance) {
        if (expBalance.getAmount() <= 0.0) {
            throw new AppException("0010", "\u6838\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        boolean withApply = false;
        ExpApply apply = null;
        if (StringUtils.isNotEmpty(expBalance.getApplyId())) {
            apply = this.getExpApply(expBalance.getApplyId());
            if (apply == null) {
                throw new AppException("0010", "\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
            }
            if (expBalance.getAmount() > apply.getAmount()) {
                throw new AppException("0010", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d");
            }
            withApply = true;
        }
        this.baseDao.save((Object)expBalance);
        if (apply != null) {
            apply.setBalanceId(expBalance.getId());
            this.baseDao.update((Object)apply);
        }
        this.updateUsedAmount(orgId, expBalance.getYear(), expBalance.getBudgetTargetType(), expBalance.getBudgetTargetId(), expBalance.getExpensesItemCode(), expBalance.getAmount(), withApply);
    }

    public BudgetItem getBudgetItem(String supplierId, Long year, String budgetTargetType, String budgetTargetId, String expensesItemCode) {
        if (StringUtils.isEmpty(budgetTargetType)) {
            return null;
        }
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select item from BudgetItem item,Budget budget where item.budgetId=budget.id and budget.year=? ");
        args.add(year);
        hql.append(" and budget.partnerId=? ");
        args.add(supplierId);
        if (budgetTargetType.equals("org")) {
            hql.append("and item.partnerId=? and item.channelId is null and item.bigareaId is null and item.areaId is null and item.sellerId is null and item.customerId is null ");
            args.add(budgetTargetId);
        } else if (budgetTargetType.equals("channel")) {
            hql.append("and item.channelId=? and item.bigareaId is null and item.areaId is null and item.sellerId is null and item.customerId is null ");
            args.add(budgetTargetId);
        } else if (budgetTargetType.equals("bigarea")) {
            hql.append("and item.bigareaId=? and item.areaId is null and item.sellerId is null and item.customerId is null ");
            args.add(budgetTargetId);
        } else if (budgetTargetType.equals("area")) {
            hql.append("and item.areaId=? and item.sellerId is null and item.customerId is null ");
            args.add(budgetTargetId);
        } else if (budgetTargetType.equals("seller")) {
            hql.append("and item.sellerId=? and item.customerId is null ");
            args.add(budgetTargetId);
        } else if (budgetTargetType.equals("customer")) {
            hql.append("and item.customerId=? and item.sellerId is null");
            args.add(budgetTargetId);
        }
        if (StringUtils.isNotEmpty(expensesItemCode)) {
            hql.append(" and item.subType=? ");
            args.add(expensesItemCode);
        }
        return (BudgetItem)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), BudgetItem.class);
    }

    public void updateContactUsingAmount(String supplierId, String applyerId, Long year, String expensesItemCode, Double amount) {
        Object[] args = new Object[]{supplierId, applyerId, (double)year.longValue(), expensesItemCode};
        PactExpense expense = (PactExpense)this.baseDao.findFirstEntity("from PactExpense e,PactMain p where p.id=e.pactId and p.supplierId=? and p.applyerId=? and e.year=? and e.expenseCode=? ", args, PactExpense.class);
        if (expense != null) {
            expense.setTempMoney(MathUtils.add((Double)expense.getTempMoney(), (Double)amount));
            expense.setOccupyMoney(MathUtils.add((Double)expense.getOccupyMoney(), (Double)amount));
            this.baseDao.update((Object)expense);
        }
    }

    public void updateContactUsedAmount(String supplierId, String applyerId, Long year, String expensesItemCode, Double amount, boolean withApply) {
        Object[] args = new Object[]{supplierId, applyerId, (double)year.longValue(), expensesItemCode};
        PactExpense expense = (PactExpense)this.baseDao.findFirstEntity("from PactExpense e,PactMain p where p.id=e.pactId and p.supplierId=? and p.applyerId=? and e.year=? and e.expenseCode=? ", args, PactExpense.class);
        if (expense != null) {
            if (withApply) {
                expense.setTempMoney(0.0);
            }
            expense.setEmployMoney(MathUtils.add((Double)expense.getEmployMoney(), (Double)amount));
            this.baseDao.update((Object)expense);
        }
    }

    public void updateUsingAmount(String supplierId, Long year, String budgetTargetType, String budgetTargetId, String expensesItemCode, Double amount) {
        DictionaryItem di = Cache.getItem("TCBJ_PACT_EXPENSE_TYPE", expensesItemCode);
        if (StringUtils.isNotEmpty(di.getHigh()) && di.getHigh().trim().equals("1")) {
            this.updateContactUsingAmount(supplierId, budgetTargetId, year, expensesItemCode, amount);
            return;
        }
        BudgetItem item = this.getBudgetItem(supplierId, year, budgetTargetType, budgetTargetId, expensesItemCode);
        if (item == null) {
            return;
        }
        this._updateUsingAmount(item, amount);
        if (budgetTargetType.equals("seller") || budgetTargetType.equals("customer")) {
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "area", item.getAreaId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "bigarea", item.getBigareaId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount);
        } else if (budgetTargetType.equals("area")) {
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "bigarea", item.getBigareaId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount);
        } else if (budgetTargetType.equals("bigarea")) {
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount);
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount);
        } else if (budgetTargetType.equals("channel")) {
            this._updateUsingAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount);
        }
    }

    private void _updateUsingAmount(BudgetItem budgetItem, Double amount) {
        if (budgetItem == null || amount == 0.0) {
            return;
        }
        budgetItem.setUsingAmount(MathUtils.add((Double)budgetItem.getUsingAmount(), (Double)amount));
        budgetItem.setTempAmount(MathUtils.add((Double)budgetItem.getTempAmount(), (Double)amount));
        this.budgetService.updateItem(budgetItem);
    }

    private String getBudgetTargetName(String type, String id) {
        String name = "\u672a\u77e5\u9884\u7b97\u5bf9\u8c61";
        if ("org".equals(type) || "customer".equals(type)) {
            name = Cache.getPartnerName(id);
        } else if ("channel".equals(type)) {
            name = Cache.getChannelTypeName(id);
        } else if ("bigarea".equals(type) || "area".equals(type)) {
            name = Cache.getRegionsName(id);
        } else if ("seller".equals(type)) {
            name = Cache.getEmployeeName(id);
        }
        return name;
    }

    public void updateUsedAmount(String supplierId, Long year, String budgetTargetType, String budgetTargetId, String expensesItemCode, Double amount, boolean withApply) {
        DictionaryItem di = Cache.getItem("TCBJ_PACT_EXPENSE_TYPE", expensesItemCode);
        if (di != null && StringUtils.isNotEmpty(di.getHigh()) && di.getHigh().trim().equals("1")) {
            this.updateContactUsedAmount(supplierId, budgetTargetId, year, expensesItemCode, amount, withApply);
            return;
        }
        BudgetItem item = this.getBudgetItem(supplierId, year, budgetTargetType, budgetTargetId, expensesItemCode);
        if (item == null) {
            return;
        }
        this._updateUsedAmount(item, amount, withApply);
        if (budgetTargetType.equals("seller") || budgetTargetType.equals("customer")) {
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "area", item.getAreaId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "bigarea", item.getBigareaId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount, withApply);
        } else if (budgetTargetType.equals("area")) {
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "bigarea", item.getBigareaId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount, withApply);
        } else if (budgetTargetType.equals("bigarea")) {
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "channel", item.getChannelId(), expensesItemCode), amount, withApply);
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount, withApply);
        } else if (budgetTargetType.equals("channel")) {
            this._updateUsedAmount(this.getBudgetItem(supplierId, year, "org", item.getPartnerId(), expensesItemCode), amount, withApply);
        }
    }

    private void _updateUsedAmount(BudgetItem budgetItem, Double amount, boolean withApply) {
        if (budgetItem == null || amount == 0.0) {
            return;
        }
        if (withApply) {
            budgetItem.setTempAmount(0.0);
        }
        budgetItem.setUsedAmount(MathUtils.add((Double)budgetItem.getUsedAmount(), (Double)amount));
        this.budgetService.updateItem(budgetItem);
    }

    public Map<String, String> getApplyByBalance(List<ExpApplyView> list) {
        String sb = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (ExpApplyView expApplyView : list) {
            sb = String.valueOf(sb) + "'" + expApplyView.getId() + "',";
        }
        if (sb.length() > 0) {
            List blist = this.baseDao.findEntity("from ExpBalanceView where applyId in (" + sb.substring(0, sb.length() - 1) + ")", ExpBalanceView.class);
            for (ExpBalanceView expBalanceView : blist) {
                map.put(expBalanceView.getApplyId(), expBalanceView.getId());
            }
        }
        return map;
    }
}

