/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expbalance;

import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.entity.ExpApply;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.expbalance.ExpBalanceCondition;
import com.tcbj.crm.expbalance.excel.AreaExc;
import com.tcbj.crm.expbalance.excel.BigAreaExc;
import com.tcbj.crm.expbalance.excel.ChannelExc;
import com.tcbj.crm.expbalance.excel.CustomerExc;
import com.tcbj.crm.expbalance.excel.DetailCostExc;
import com.tcbj.crm.expbalance.excel.SubTypeExc;
import com.tcbj.crm.view.CostV;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="expBalanceService")
public class ExpBalanceService {
    @Autowired
    private BaseDao baseDao;

    public ExpBalance get(String id) {
        ExpBalance expApply = this.getExpBalance(id);
        return expApply;
    }

    public ExpBalance getExpBalance(String id) {
        return (ExpBalance)this.baseDao.get(ExpBalance.class, (Serializable)((Object)id));
    }

    public void del(String id) {
        this.baseDao.deleteById(ExpBalance.class, (Serializable)((Object)id));
    }

    public void update(String id) {
        ExpBalance expApply = this.getExpBalance(id);
        this.baseDao.update((Object)expApply);
    }

    public Page getPage(ExpBalanceCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExpBalance where operatorId = ? ");
        args.add(con.getOperatorId());
        if (StringUtils.isNotNull(con.getYear())) {
            hql.append(" and year = ? ");
            args.add(con.getYear());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void save(ExpBalance expApply) {
        this.baseDao.save((Object)expApply);
    }

    public void update(ExpBalance expApply) {
        ExpBalance ex = (ExpBalance)this.baseDao.get(ExpBalance.class, (Serializable)((Object)expApply.getId()));
        ex.setYear(expApply.getYear());
        ex.setSupplierId(expApply.getSupplierId());
        ex.setExpensesItemCode(expApply.getExpensesItemCode());
        ex.setAmount(expApply.getAmount());
        ex.setActivityId(expApply.getActivityId());
        ex.setApplyId(expApply.getApplyId());
        ex.setApplyerId(expApply.getApplyerId());
        this.baseDao.update((Object)ex);
    }

    public List<ExpBalance> getList(Long year, String supplierId, String expensesItemCode) {
        return this.baseDao.findEntity(" from ExpBalance where year = ? and supplierId = ? and expensesItemCode = ? ", new Object[]{year, supplierId, expensesItemCode}, ExpBalance.class);
    }

    public Double getAmount(Long year, String supplierId, String expensesItemCode, Double amount) {
        List<ExpBalance> list = this.getList(year, supplierId, expensesItemCode);
        int i = 0;
        while (i < list.size()) {
            amount = MathUtils.add((Double)amount, (Double)list.get(i).getAmount());
            ++i;
        }
        return amount;
    }

    public List<ExpApply> getList(String operatorId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ExpApply where balanceId is null ");
        if (StringUtils.isNotEmpty(operatorId)) {
            hql.append(" and operatorId = ? ");
            args.add(operatorId);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), ExpApply.class);
    }

    public List<ExpApply> getList(String applyerId, String operatorId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ExpApply where balanceId is not null ");
        if (StringUtils.isNotEmpty(operatorId)) {
            hql.append(" and operatorId = ? ");
            args.add(operatorId);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            hql.append(" and applyerId = ? ");
            args.add(applyerId);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), ExpApply.class);
    }

    private String getHqlCustomer(ExpBalanceCondition con, List<Object> args, String select, String where, String group) {
        StringBuffer hql = new StringBuffer();
        hql.append("select sum(bi.AMOUNT) amount,sum(bi.USING_AMOUNT) usingAmount,sum(bi.USED_AMOUNT) usedAmount, ");
        hql.append(select);
        hql.append(" from cx_awk_budget_view bi,CX_AWK_PRTNR_ACCOUNTLIST_VIEW c where c.PARTNERID = bi.CUSTOMER_ID ");
        if (StringUtils.isNotNull(con.getPartnerId())) {
            hql.append(" and bi.PARTNER_ID = ? ");
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql.append(" and bi.YEAR = ? ");
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and c.PARTNERNAME like ? ");
            args.add("%" + con.getName() + "%");
        }
        if (StringUtils.isNotEmpty(con.getBigareaId())) {
            hql.append(" and c.DISTRICTID = ? ");
            args.add(con.getBigareaId());
        }
        if (StringUtils.isNotEmpty(con.getSubType())) {
            hql.append(" and bi.SUB_TYPE = ? ");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql.append(" and bi.TYPE = ? ");
            args.add(con.getType());
        }
        hql.append(where);
        hql.append(" group by ");
        hql.append(group);
        return hql.toString();
    }

    private String getHql(ExpBalanceCondition con, List<Object> args, String select, String where, String group) {
        StringBuffer hql = new StringBuffer();
        hql.append("select sum(bi.AMOUNT) amount,sum(bi.USING_AMOUNT) usingAmount,sum(bi.USED_AMOUNT) usedAmount, ");
        hql.append(select);
        hql.append(" from CX_BUDGET bt,CX_BUDGET_ITEM bi where bt.ROW_ID = bi.BUDGET_ID and bi.STATE = '0' and bt.STATE ='2' ");
        if (StringUtils.isNotNull(con.getPartnerId())) {
            hql.append(" and bt.PARTNER_ID = ? ");
            args.add(con.getPartnerId());
        }
        if (StringUtils.isNotNull(con.getYear())) {
            hql.append(" and bt.YEAR = ? ");
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getChannelId())) {
            hql.append(" and bi.CHANNEL_ID = ? ");
            args.add(con.getChannelId());
        }
        if (StringUtils.isNotEmpty(con.getBigareaId())) {
            hql.append(" and bi.BIGAREA_ID = ? ");
            args.add(con.getBigareaId());
        }
        if (StringUtils.isNotEmpty(con.getSubType())) {
            hql.append(" and bi.SUB_TYPE = ? ");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql.append(" and bi.TYPE = ? ");
            args.add(con.getType());
        }
        hql.append(where);
        hql.append(" group by ");
        hql.append(group);
        return hql.toString();
    }

    public List<BudgetItem> subTypeQueryList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType ";
        String group = " bi.TYPE,bi.SUB_TYPE ";
        String where = " and bi.CHANNEL_ID is null and bi.AREA_ID is null and bi.BIGAREA_ID is null and bi.SELLER_ID is null  ";
        String sql = this.getHql(con, args, select, where, group);
        List subTypes = this.baseDao.findBySql(sql, args.toArray());
        return this.wrap(subTypes, con.getByType());
    }

    public Page subTypeQuery(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType ";
        String group = " bi.TYPE,bi.SUB_TYPE ";
        String where = " and bi.CHANNEL_ID is null and bi.AREA_ID is null and bi.BIGAREA_ID is null and bi.SELLER_ID is null  ";
        String sql = this.getHql(con, args, select, where, group);
        return this.wrap(this.baseDao.searchBySql(sql, args.toArray(), Constant.DEFAULT_ROWS, pageno, null), "subType");
    }

    public List<BudgetItem> channelQueryList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID";
        String where = " and bi.channel_id is not null and bi.BIGAREA_ID is null and bi.AREA_ID is null and bi.SELLER_ID is null ";
        String sql = this.getHql(con, args, select, where, group);
        List channelList = this.baseDao.findBySql(sql, args.toArray());
        return this.wrap(channelList, "channel");
    }

    public Page channelQuery(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID";
        String where = " and bi.channel_id is not null and bi.BIGAREA_ID is null and bi.AREA_ID is null and bi.SELLER_ID is null ";
        String hql = this.getHql(con, args, select, where, group);
        return this.wrap(this.baseDao.searchBySql(hql, args.toArray(), Constant.DEFAULT_ROWS, pageno, null), "channel");
    }

    public List<BudgetItem> bigareaQueryList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId, bi.BIGAREA_ID as bigareaId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID,bi.BIGAREA_ID ";
        String where = " and bi.BIGAREA_ID is not null and bi.AREA_ID is null and bi.SELLER_ID is null ";
        String sql = this.getHql(con, args, select, where, group);
        List bigAreaList = this.baseDao.findBySql(sql, args.toArray());
        return this.wrap(bigAreaList, "bigarea");
    }

    public Page bigareaQuery(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId, bi.BIGAREA_ID as bigareaId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID,bi.BIGAREA_ID ";
        String where = " and bi.BIGAREA_ID is not null and bi.AREA_ID is null and bi.SELLER_ID is null ";
        String hql = this.getHql(con, args, select, where, group);
        return this.wrap(this.baseDao.searchBySql(hql, args.toArray(), Constant.DEFAULT_ROWS, pageno, null), "bigarea");
    }

    public List<BudgetItem> areaQueryList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId,bi.bigarea_id as bigareaId, bi.area_id as areaId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID,bi.BIGAREA_ID,bi.AREA_ID ";
        String where = " and bi.AREA_ID is not null and bi.SELLER_ID is null ";
        String sql = this.getHql(con, args, select, where, group);
        List bigAreaList = this.baseDao.findBySql(sql, args.toArray());
        return this.wrap(bigAreaList, "area");
    }

    public Page areaQuery(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CHANNEL_ID as channelId,bi.bigarea_id as bigareaId, bi.area_id as areaId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CHANNEL_ID,bi.BIGAREA_ID,bi.AREA_ID ";
        String where = " and bi.AREA_ID is not null and bi.SELLER_ID is null ";
        String hql = this.getHql(con, args, select, where, group);
        return this.wrap(this.baseDao.searchBySql(hql, args.toArray(), Constant.DEFAULT_ROWS, pageno, null), "area");
    }

    public List<BudgetItem> customerQueryList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CUSTOMER_ID as customerId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CUSTOMER_ID ";
        String where = " and bi.CUSTOMER_ID is not null ";
        String sql = this.getHqlCustomer(con, args, select, where, group);
        List bigAreaList = this.baseDao.findBySql(sql, args.toArray());
        return this.wrap(bigAreaList, "customer");
    }

    public Page customerQuery(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String select = " bi.TYPE as type,bi.SUB_TYPE as subType,bi.CUSTOMER_ID as customerId ";
        String group = " bi.TYPE,bi.SUB_TYPE,bi.CUSTOMER_ID ";
        String where = " and bi.CUSTOMER_ID is not null ";
        String hql = this.getHqlCustomer(con, args, select, where, group);
        return this.wrap(this.baseDao.searchBySql(hql, args.toArray(), Constant.DEFAULT_ROWS, pageno, null), "customer");
    }

    private Page wrap(Page page, String type) {
        List list = page.getList();
        ArrayList<BudgetItem> items = new ArrayList<BudgetItem>();
        BudgetItem item = null;
        Object[] obj = null;
        for (Object tmp : list) {
            obj = (Object[])tmp;
            item = new BudgetItem();
            if (obj[0] != null) {
                item.setAmount(((BigDecimal)obj[0]).doubleValue());
            }
            if (obj[1] != null) {
                item.setUsedAmount(((BigDecimal)obj[1]).doubleValue());
            }
            if (obj[2] != null) {
                item.setUsingAmount(((BigDecimal)obj[2]).doubleValue());
            }
            if (obj[3] != null) {
                item.setType((String)obj[3]);
            }
            if (obj[4] != null) {
                item.setSubType((String)obj[4]);
            }
            if ("area".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
                if (obj[6] != null) {
                    item.setBigareaId((String)obj[6]);
                }
                if (obj[6] != null) {
                    item.setAreaId((String)obj[7]);
                }
            }
            if ("channel".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
            } else if ("customer".equals(type)) {
                if (obj[5] != null) {
                    item.setCustomerId((String)obj[5]);
                }
            } else if ("bigarea".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
                if (obj[6] != null) {
                    item.setBigareaId((String)obj[6]);
                }
            }
            items.add(item);
        }
        page.setList(items);
        return page;
    }

    private List<BudgetItem> wrap(List<Object[]> objArr, String type) {
        ArrayList<BudgetItem> items = new ArrayList<BudgetItem>();
        BudgetItem item = null;
        for (Object[] obj : objArr) {
            item = new BudgetItem();
            if (obj[0] != null) {
                item.setAmount(((BigDecimal)obj[0]).doubleValue());
            }
            if (obj[1] != null) {
                item.setUsedAmount(((BigDecimal)obj[1]).doubleValue());
            }
            if (obj[2] != null) {
                item.setUsingAmount(((BigDecimal)obj[2]).doubleValue());
            }
            if (obj[3] != null) {
                item.setType((String)obj[3]);
            }
            if (obj[4] != null) {
                item.setSubType((String)obj[4]);
            }
            if ("area".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
                if (obj[6] != null) {
                    item.setBigareaId((String)obj[6]);
                }
                if (obj[6] != null) {
                    item.setAreaId((String)obj[7]);
                }
            }
            if ("channel".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
            } else if ("customer".equals(type)) {
                if (obj[5] != null) {
                    item.setCustomerId((String)obj[5]);
                }
            } else if ("bigarea".equals(type)) {
                if (obj[5] != null) {
                    item.setChannelId((String)obj[5]);
                }
                if (obj[6] != null) {
                    item.setBigareaId((String)obj[6]);
                }
            }
            items.add(item);
        }
        return items;
    }

    public List<CostV> getDetailedList(ExpBalanceCondition con) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append(" from CostV where 1=1 ");
        if (StringUtils.isNotNull(con.getYear())) {
            sb.append(" and year = ? ");
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getSubType())) {
            sb.append(" and itemCode = ? ");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            sb.append(" and applyerId = ? ");
            args.add(con.getApplyerId());
        }
        return this.baseDao.findEntity(sb.toString(), args.toArray(), CostV.class);
    }

    public Page getDetailed(ExpBalanceCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append(" from CostV where 1=1 ");
        if (StringUtils.isNotNull(con.getYear())) {
            sb.append(" and year = ? ");
            args.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getSubType())) {
            sb.append(" and itemCode = ? ");
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            sb.append(" and applyerId = ? ");
            args.add(con.getApplyerId());
        }
        return this.baseDao.search(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page getExpApply(String type, String budgetTargetType, String expensesItemCode, String supplierId, int pageno) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" from ExpApply where 1=1 ");
        if (StringUtils.isNotNull(type)) {
            sb.append(" and expensesTypeCode = ? ");
            args.add(type);
        }
        if (StringUtils.isNotNull(expensesItemCode)) {
            sb.append(" and expensesItemCode = ? ");
            args.add(expensesItemCode);
        }
        if (StringUtils.isNotEmpty(budgetTargetType)) {
            sb.append(" and budgetTargetType = ? ");
            args.add(budgetTargetType);
        }
        if (StringUtils.isNotEmpty(supplierId)) {
            sb.append(" and supplierId = ? ");
            args.add(supplierId);
        }
        return this.baseDao.search(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<SubTypeExc> getSubTypeExcel(ExpBalanceCondition con) {
        List<BudgetItem> subTypes = this.subTypeQueryList(con);
        ArrayList<SubTypeExc> excels = new ArrayList<SubTypeExc>();
        for (BudgetItem item : subTypes) {
            SubTypeExc exc = new SubTypeExc();
            exc.setTypeName(item.getTypeName());
            exc.setSubTypeName(item.getSubTypeName());
            exc.setAmount(item.getAmount());
            exc.setUsingAmount(item.getUsingAmount());
            exc.setUsedAmount(item.getUsedAmount());
            exc.setAvailableAmt(item.getAmount() - item.getUsedAmount());
            excels.add(exc);
        }
        return excels;
    }

    public List<ChannelExc> getChannelExcel(ExpBalanceCondition con) {
        List<BudgetItem> channelList = this.channelQueryList(con);
        ArrayList<ChannelExc> excels = new ArrayList<ChannelExc>();
        for (BudgetItem item : channelList) {
            ChannelExc exc = new ChannelExc();
            exc.setChannelName(item.getChannelName());
            exc.setTypeName(item.getTypeName());
            exc.setSubTypeName(item.getSubTypeName());
            exc.setAmount(item.getAmount());
            exc.setUsingAmount(item.getUsingAmount());
            exc.setUsedAmount(item.getUsedAmount());
            exc.setAvailableAmt(item.getAmount() - item.getUsedAmount());
            excels.add(exc);
        }
        return excels;
    }

    public List<BigAreaExc> getBigAreaExcel(ExpBalanceCondition con) {
        List<BudgetItem> bigareaList = this.bigareaQueryList(con);
        ArrayList<BigAreaExc> excels = new ArrayList<BigAreaExc>();
        for (BudgetItem item : bigareaList) {
            BigAreaExc exc = new BigAreaExc();
            exc.setBigAreaName(item.getBigAreaName());
            exc.setTypeName(item.getTypeName());
            exc.setSubTypeName(item.getSubTypeName());
            exc.setAmount(item.getAmount());
            exc.setUsingAmount(item.getUsingAmount());
            exc.setUsedAmount(item.getUsedAmount());
            exc.setAvailableAmt(item.getAmount() - item.getUsedAmount());
            excels.add(exc);
        }
        return excels;
    }

    public List<AreaExc> getAreaExcel(ExpBalanceCondition con) {
        List<BudgetItem> areaList = this.areaQueryList(con);
        ArrayList<AreaExc> excels = new ArrayList<AreaExc>();
        for (BudgetItem item : areaList) {
            AreaExc exc = new AreaExc();
            exc.setAreaName(item.getAreaName());
            exc.setTypeName(item.getTypeName());
            exc.setSubTypeName(item.getSubTypeName());
            exc.setAmount(item.getAmount());
            exc.setUsingAmount(item.getUsingAmount());
            exc.setUsedAmount(item.getUsedAmount());
            exc.setAvailableAmt(item.getAmount() - item.getUsedAmount());
            excels.add(exc);
        }
        return excels;
    }

    public List<CustomerExc> getCustomerExcel(ExpBalanceCondition con) {
        List<BudgetItem> customer = this.customerQueryList(con);
        ArrayList<CustomerExc> excels = new ArrayList<CustomerExc>();
        for (BudgetItem item : customer) {
            CustomerExc exc = new CustomerExc();
            exc.setCustomerName(item.getCustomerName());
            exc.setTypeName(item.getTypeName());
            exc.setSubTypeName(item.getSubTypeName());
            exc.setAmount(item.getAmount());
            exc.setUsingAmount(item.getUsingAmount());
            exc.setUsedAmount(item.getUsedAmount());
            exc.setAvailableAmt(item.getAmount() - item.getUsedAmount());
            excels.add(exc);
        }
        return excels;
    }

    public List<DetailCostExc> getDetailExcel(ExpBalanceCondition con) {
        List<CostV> costList = this.getDetailedList(con);
        ArrayList<DetailCostExc> excels = new ArrayList<DetailCostExc>();
        for (CostV item : costList) {
            DetailCostExc exc = new DetailCostExc();
            exc.setTypeName(item.getItemTypeName());
            exc.setSubTypeName(item.getItemCodeName());
            exc.setApplyerName(item.getApplyerName());
            exc.setSupplierName(item.getSupplierName());
            exc.setAppAmount(item.getAppAmount());
            exc.setBalAmount(item.getBalAmount());
            exc.setYear(item.getYear());
            excels.add(exc);
        }
        return excels;
    }
}

