/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.fgift;

import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.FreeBalance;
import com.tcbj.crm.entity.GiftHis;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.fgift.FGiftService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fGiftFacadeService")
public class FGiftFacadeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PactMainService pactMainService;
    @Autowired
    FGiftService fGiftService;
    private static Double rate = 4.0;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderApplyService orderApplyService;

    public Double getGiftBalance(String applyerId, String supplierId, Integer precision) {
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{applyerId, supplierId}, FreeBalance.class);
        if (gb == null) {
            return 0.0;
        }
        Double result = gb.getRemainderAmount();
        if (result == null) {
            return 0.0;
        }
        result = MathUtils.getPrecision((Double)result, (Integer)precision);
        return result;
    }

    public Double getCurrentGiftBalance(OrderApply order, Integer precision) {
        Date orderDate = order.getDt() == null ? new Date() : order.getDt();
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDate);
        List<OrderApplyItem> list = order.getOrderApplyItems();
        Double totalAmount = 0.0;
        Double totalQuantity = 0.0;
        Double currentAmount = 0.0;
        for (OrderApplyItem item : list) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
            double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
            totalAmount = totalAmount + MathUtils.mul((Double)quantity, (Double)price);
            totalQuantity = totalQuantity + (item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity());
        }
        Double scale = pactMain.getFreeScale();
        if (scale == null) {
            scale = 0.0;
        }
        currentAmount = "QUANTITY".equals(pactMain.getFreeScaleType()) ? Double.valueOf(MathUtils.div((Double)MathUtils.mul((Double)totalQuantity, (Double)scale), (Double)100.0) * rate) : MathUtils.div((Double)MathUtils.mul((Double)totalAmount, (Double)scale), (Double)100.0);
        currentAmount = MathUtils.getPrecision((Double)currentAmount, (Integer)precision);
        return currentAmount;
    }

    public Double[] getExtendGiftAmountAndQuantity(OrderApply order, Integer precision) {
        Date orderDate = order.getDt() == null ? new Date() : order.getDt();
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDate);
        List<OrderApplyItem> list = order.getOrderApplyItems();
        Double totalAmount = 0.0;
        Double totalQuantity = 0.0;
        Double currentAmount = 0.0;
        Double currentQuantity = 0.0;
        for (OrderApplyItem item : list) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
            double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
            totalAmount = totalAmount + MathUtils.mul((Double)quantity, (Double)price);
            totalQuantity = totalQuantity + (item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity());
        }
        Double scale = pactMain.getFreeScale();
        if (scale == null) {
            scale = 0.0;
        }
        if ("QUANTITY".equals(pactMain.getFreeScaleType())) {
            currentQuantity = MathUtils.div((Double)MathUtils.mul((Double)totalQuantity, (Double)scale), (Double)100.0);
            currentAmount = currentQuantity * rate;
        } else {
            currentAmount = MathUtils.div((Double)MathUtils.mul((Double)totalAmount, (Double)scale), (Double)100.0);
        }
        currentAmount = MathUtils.getPrecision((Double)currentAmount, (Integer)precision);
        currentQuantity = MathUtils.getPrecision((Double)currentQuantity, (Integer)precision);
        Double[] rtn = new Double[]{currentAmount, currentQuantity};
        return rtn;
    }

    public void use(OrderApply order, Double actGiftQuantity, Double actAmount, Integer precision) {
        double useCount;
        Double[] tmp;
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), order.getDt());
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, FreeBalance.class);
        if (gb == null) {
            gb = new FreeBalance();
            gb.setGiftType(pactMain.getFreeScaleType());
            gb.setApplyerId(order.getApplyerId());
            gb.setSupplierId(order.getSupplierId());
            gb.setCreateDt(DateUtils.now());
            gb.setLastUpdateDt(gb.getCreateDt());
            gb.setCreatorId(order.getApproverId());
            gb.setLastUpdatorId(gb.getCreatorId());
            this.baseDao.save((Object)gb);
        }
        Double extendAmount = (tmp = this.getExtendGiftAmountAndQuantity(order, precision))[0] == null ? 0.0 : tmp[0];
        Double extendCount = tmp[1] == null ? 0.0 : tmp[1];
        double useAmount = actAmount == null ? 0.0 : actAmount;
        double d = useCount = actGiftQuantity == null ? 0.0 : actGiftQuantity;
        if (extendAmount == 0.0 && useAmount == 0.0 && useCount == 0.0) {
            return;
        }
        gb.setExtendCount(MathUtils.add((Double)gb.getExtendCount(), (Double)extendCount));
        gb.setUseCount(MathUtils.add((Double)gb.getUseCount(), (Double)useCount));
        gb.setExtendAmount(MathUtils.add((Double)gb.getExtendAmount(), (Double)extendAmount));
        gb.setUseAmount(MathUtils.add((Double)gb.getUseAmount(), (Double)useAmount));
        this.baseDao.update((Object)gb);
        if (useAmount != 0.0 || extendAmount != null && extendAmount != 0.0) {
            GiftHis giftHis = new GiftHis();
            giftHis.setGiftBalanceId(gb.getId());
            giftHis.setGiftType(gb.getGiftType());
            giftHis.setUseCount(useCount);
            if (Constant.SCALETYPE_QUANTITY.equals(gb.getGiftType())) {
                giftHis.setOrderGetCount(extendCount);
            } else {
                giftHis.setOrderGetCount(0.0);
            }
            giftHis.setUseAmount(useAmount);
            giftHis.setOrderGetAmount(extendAmount);
            giftHis.setOrderId(order.getId());
            giftHis.setOrderNo(order.getNo());
            giftHis.setCreatorId(order.getApproverId());
            giftHis.setLastupdatorId(order.getApproverId());
            giftHis.setType("fgift");
            this.baseDao.save((Object)giftHis);
        }
    }

    public void unuse(String orderId) {
        GiftHis gh = (GiftHis)this.baseDao.findFirstEntity("from GiftHis g where g.orderId = ? and state = '1' and type='fgift' order by useDate desc ", new Object[]{orderId}, GiftHis.class);
        if (gh == null) {
            return;
        }
        OrderApply order = this.orderApplyService.getSimpleOrderApply(orderId);
        FreeBalance gb = (FreeBalance)this.baseDao.findFirstEntity(" from FreeBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, FreeBalance.class);
        if (Constant.SCALETYPE_QUANTITY.equals(gh.getGiftType())) {
            double extendCount = MathUtils.sub((Double)gb.getExtendCount(), (Double)gh.getOrderGetCount());
            double useCount = MathUtils.sub((Double)gb.getUseCount(), (Double)gh.getUseCount());
            this.baseDao.executeHQL(" update FreeBalance set extendCount = ? ,useCount = ?  where id = ?", new Object[]{extendCount, useCount, gb.getId()});
        }
        double extendAmount = MathUtils.sub((Double)gb.getExtendAmount(), (Double)gh.getOrderGetAmount());
        double useAmount = MathUtils.sub((Double)gb.getUseAmount(), (Double)gh.getUseAmount());
        this.baseDao.executeHQL(" update FreeBalance set extendAmount = ? ,useAmount = ?  where id = ?", new Object[]{extendAmount, useAmount, gb.getId()});
        this.baseDao.executeHQL(" update GiftHis set state = ? where id = ?", new Object[]{0, gh.getId()});
    }
}

