/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intRule;

import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.intRule.IntRuleCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="intruleService")
public class IntRuleService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public IntRule get(String id) {
        return (IntRule)this.baseDao.get(IntRule.class, (Serializable)((Object)id));
    }

    public void save(IntRule obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(String orgid, int pageno, IntRuleCondition condition) {
        String regions = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer hql = new StringBuffer();
        hql.append(" from IntRule o,Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and o.applyerId=a.applyerId and o.supplierId=a.supplierId and o.supplierId = ?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(orgid);
        if (StringUtils.isNotEmpty(condition.getLocusOfControl())) {
            hql.append(" and o.locusOfControl like ? ");
            args.add("%" + condition.getLocusOfControl() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getControlContent())) {
            hql.append(" and o.controlContent = ? ");
            args.add(condition.getControlContent());
        }
        if (StringUtils.isNotEmpty(condition.getProductid())) {
            hql.append(" and o.productId = ? ");
            args.add(condition.getProductid());
        }
        hql.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), pageno);
        List list = page.getList();
        ArrayList<IntRule> intRules = new ArrayList<IntRule>();
        for (Object[] obj : list) {
            intRules.add((IntRule)obj[0]);
        }
        page.setList(intRules);
        return page;
    }

    public void update(IntRule obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        IntRule intRule = (IntRule)this.baseDao.get(IntRule.class, (Serializable)((Object)id));
        intRule.setEndDate(DateUtils.now());
        this.baseDao.update((Object)intRule);
    }

    public void update(List<IntRule> intRules, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    this.baseDao.executeHQL("delete IntRule where id= ?", args);
                }
                ++n2;
            }
            for (IntRule intRule : intRules) {
                intRule.fillInitData(me);
                intRule.setSupplierId(me.getCurrentPartner().getId());
                if (StringUtils.isEmpty(intRule.getId())) {
                    this.baseDao.save((Object)intRule);
                    continue;
                }
                this.baseDao.update((Object)intRule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

