/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemg;

import com.tcbj.crm.entity.GiftIntRebate;
import com.tcbj.crm.entity.GiftIntRebatemg;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftIntRebatemgService {
    @Autowired
    BaseDao baseDao;

    public Double[] getDiscount(String supplierId, String applyerId, Date date, Double giftMoney, Double freezeGiftMoney, Integer precision) {
        List<GiftIntRebatemg> list = this.getGiftIntRebateList(supplierId, applyerId, date);
        double resultGiftMoney = 0.0;
        double availableGiftMoney = 0.0;
        double totalAvailableGiftMoney = 0.0;
        for (GiftIntRebatemg r : list) {
            double over;
            if (!"GIFT".equals(r.getProducttype())) continue;
            double available = MathUtils.div((Double)MathUtils.mul((Double)giftMoney, (Double)100.0), (Double)100.0);
            if (available > (over = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney()).doubleValue())) {
                available = over;
            }
            availableGiftMoney = MathUtils.add((Double)availableGiftMoney, (Double)available);
            totalAvailableGiftMoney += over;
        }
        totalAvailableGiftMoney = (totalAvailableGiftMoney = MathUtils.sub((Double)totalAvailableGiftMoney, (Double)freezeGiftMoney).doubleValue()) < 0.0 ? 0.0 : totalAvailableGiftMoney;
        availableGiftMoney = availableGiftMoney > giftMoney ? giftMoney : availableGiftMoney;
        double d = resultGiftMoney = availableGiftMoney > totalAvailableGiftMoney ? totalAvailableGiftMoney : availableGiftMoney;
        if (precision != null) {
            switch (precision) {
                case 0: {
                    resultGiftMoney = MathUtils.getInt((Double)resultGiftMoney);
                    break;
                }
                case 1: {
                    resultGiftMoney = MathUtils.getPrecision1((Double)resultGiftMoney);
                    break;
                }
                case 2: {
                    resultGiftMoney = MathUtils.getPrecision2((Double)resultGiftMoney);
                    break;
                }
            }
        }
        Double[] result = new Double[]{totalAvailableGiftMoney, resultGiftMoney};
        return result;
    }

    public List<GiftIntRebatemg> getGiftIntRebateList(String supplierId, String applyerId, Date findDate) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from GiftIntRebatemg o where supplierId = ? and applyerId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(supplierId);
        args.add(applyerId);
        hql.append(" and startDate <= ? and nvl(endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        hql.append(" order by lastUpdateDt ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), GiftIntRebatemg.class);
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from GiftIntRebate r where r.indentApplyId = ? and r.state = '1' ", new Object[]{orderId}, GiftIntRebate.class);
        for (GiftIntRebate r : list) {
            String rebateId = r.getRebateId();
            GiftIntRebatemg intRebatemg = (GiftIntRebatemg)this.baseDao.get(GiftIntRebatemg.class, (Serializable)((Object)rebateId));
            if (intRebatemg != null) {
                intRebatemg.setWithheldMoney(MathUtils.sub((Double)intRebatemg.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())));
                this.baseDao.update((Object)intRebatemg);
            }
            this.baseDao.executeHQL(" update GiftIntRebate set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate) {
        double useed = 0.0;
        List<GiftIntRebatemg> list = this.getGiftIntRebateList(supplierId, applyerId, orderDate);
        for (GiftIntRebatemg r : list) {
            if (useed == useSum) break;
            double c = MathUtils.format((Double)MathUtils.div((Double)MathUtils.mul((Double)100.0, (Double)orderSum), (Double)100.0));
            if (c > MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney())) {
                c = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            }
            if (MathUtils.add((Double)useed, (Double)c) > useSum) {
                c = MathUtils.sub((Double)useSum, (Double)useed);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)c));
            useed = MathUtils.add((Double)useed, (Double)c);
            this.baseDao.update((Object)r);
            GiftIntRebate intRebate = new GiftIntRebate();
            operaterId = operaterId == null ? "0-1" : operaterId;
            intRebate.setCreatorId(operaterId);
            intRebate.setLastUpdatorId(operaterId);
            intRebate.setIndentApplyId(orderId);
            intRebate.setOrderNo(orderNo);
            intRebate.setRebateId(r.getId());
            intRebate.setWithheldMoney(String.valueOf(c));
            intRebate.setState(1);
            this.baseDao.save((Object)intRebate);
        }
    }
}

