/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemg;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.intrebatemg.IntRebatemgCondition;
import com.tcbj.crm.intrebatemg.IntRebatemgService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/intrebatemg"})
public class IntRebatemgController
extends BaseController {
    @Autowired
    IntRebatemgService intrebatemgservice;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        String bm = this.orderNoService.maxNo(e.getCurrentPartner().getNo(), "08");
        model.addAttribute("bm", (Object)bm);
        IntRebatemg intRebatemg = new IntRebatemg();
        model.addAttribute("master", (Object)intRebatemg);
        return "intrebatemg/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody IntRebatemg intrebatemg, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        intrebatemg.fillInitData(e);
        intrebatemg.setSupplierId(e.getCurrentPartner().getId());
        this.intrebatemgservice.save(intrebatemg);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        condition.setSupplierId(em.getCurrentPartner().getId());
        condition.setUserId(em.getId());
        model.addAttribute("page", (Object)this.intrebatemgservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            List<IntRebatemg> ibs = this.intrebatemgservice.getlist(this.getCurrentEmployee().getCurrentPartner().getId(), condition.getApplyerId(), DateUtils.now());
            Double sum_product = 0.0;
            Double sum_gift = 0.0;
            Double sy_sum_product = 0.0;
            Double sy_sum_gift = 0.0;
            int cp_sum = 0;
            int zp_sum = 0;
            for (IntRebatemg ib : ibs) {
                if ("PRODUCT".equals(ib.getProducttype())) {
                    sum_product = MathUtils.add((Double)sum_product, (Double)ib.getRebateMoney());
                    sy_sum_product = MathUtils.add((Double)sy_sum_product, (Double)ib.getWithheldMoney());
                    ++cp_sum;
                    continue;
                }
                sum_gift = MathUtils.add((Double)sum_gift, (Double)ib.getRebateMoney());
                sy_sum_gift = MathUtils.add((Double)sy_sum_gift, (Double)ib.getWithheldMoney());
                ++zp_sum;
            }
            Double ky_sum_product = sum_product - sy_sum_product;
            Double ky_sum_gift = sum_gift - sy_sum_gift;
            model.addAttribute("cp_sum", (Object)cp_sum);
            model.addAttribute("zp_sum", (Object)zp_sum);
            model.addAttribute("ky_sum_product", (Object)ky_sum_product);
            model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
            model.addAttribute("sum_product", (Object)sum_product);
            model.addAttribute("sum_gift", (Object)sum_gift);
            model.addAttribute("ibs", (Object)ibs.size());
        }
        return "intrebatemg/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, String applyerId, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("master", (Object)intrebatemg);
        return "intrebatemg/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody IntRebatemg intrebatemg, BindingResult errors, Model model, HttpServletRequest request) {
        if (intrebatemg.getRebateMoney() < intrebatemg.getWithheldMoney()) {
            throw new AppException("1401");
        }
        Employee e = this.getCurrentEmployee();
        intrebatemg.fillInitData(e);
        this.intrebatemgservice.update(intrebatemg);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("master", (Object)intrebatemg);
        List<IntRebatemg> ibs = this.intrebatemgservice.getlist(this.getCurrentEmployee().getCurrentPartner().getId(), intrebatemg.getApplyerId(), DateUtils.now());
        Double sum_product = 0.0;
        Double sum_gift = 0.0;
        Double sy_sum_product = 0.0;
        Double sy_sum_gift = 0.0;
        int cp_sum = 0;
        int zp_sum = 0;
        for (IntRebatemg ib : ibs) {
            if ("PRODUCT".equals(ib.getProducttype())) {
                sum_product = MathUtils.add((Double)sum_product, (Double)ib.getRebateMoney());
                sy_sum_product = MathUtils.add((Double)sy_sum_product, (Double)ib.getWithheldMoney());
                ++cp_sum;
                continue;
            }
            sum_gift = MathUtils.add((Double)sum_gift, (Double)ib.getRebateMoney());
            sy_sum_gift = MathUtils.add((Double)sy_sum_gift, (Double)ib.getWithheldMoney());
            ++zp_sum;
        }
        Double ky_sum_product = sum_product - sy_sum_product;
        Double ky_sum_gift = sum_gift - sy_sum_gift;
        model.addAttribute("cp_sum", (Object)cp_sum);
        model.addAttribute("zp_sum", (Object)zp_sum);
        model.addAttribute("ky_sum_product", (Object)ky_sum_product);
        model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
        model.addAttribute("sum_product", (Object)sum_product);
        model.addAttribute("sum_gift", (Object)sum_gift);
        model.addAttribute("ibs", (Object)ibs.size());
        return "intrebatemg/look.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request) {
        this.intrebatemgservice.delete(id);
        return "redirect:/intrebatemg/list.do";
    }

    @RequestMapping(value={"/viewHistory.do"}, method={RequestMethod.GET})
    public String viewIntRebate(String id, Model model) {
        List<IntRebate> list = this.intrebatemgservice.getIntRebateHistoryById(id);
        model.addAttribute("list", list);
        model.addAttribute("id", (Object)id);
        return "intrebatemg/viewHistory.ftl";
    }

    @RequestMapping(value={"/viewHistoryApply.do"}, method={RequestMethod.GET})
    public String viewHistory(String id, Model model) {
        List<IntRebate> list = this.intrebatemgservice.getIntRebateHistoryById(id);
        model.addAttribute("list", list);
        model.addAttribute("id", (Object)id);
        return "intrebatemg/viewHistoryApply.ftl";
    }

    @RequestMapping(value={"/viewHistoryadd.do"}, method={RequestMethod.GET})
    public String viewHistoryadd(Model model, String id) {
        model.addAttribute("id", (Object)id);
        return "intrebatemg/viewHistoryadd.ftl";
    }

    @RequestMapping(value={"/viewHistoryadd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String viewHistoryaddPost(IntRebate intRebate) {
        try {
            return this.intrebatemgservice.saveIntRebate(intRebate, this.getCurrentEmployee());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }
}

