/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.entity.WarSummary;
import com.tcbj.crm.entity.Warning;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class InitWarningSummaryJob {
    @Autowired
    SessionFactory sessionFactory2;
    @Autowired
    BaseDao baseDao;
    @Autowired
    JobService jobService;
    @Autowired
    ClientService clientService;

    public void run() {
        String[] orgIds;
        String[] stringArray = orgIds = new String[]{"1-22UH", "1-1JK1"};
        int n = orgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String orgId = stringArray[n2];
            this.run(orgId);
            ++n2;
        }
    }

    public void run(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "initwarningsummary");
        long start = System.currentTimeMillis();
        try {
            String rtn = this.initWaringSummarys(orgId);
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    private String simpleClientNo(String clientNo) {
        if (StringUtils.isEmpty((Object)clientNo)) {
            return clientNo;
        }
        int pos = clientNo.lastIndexOf(".");
        if (pos > 0 && clientNo.length() > pos + 1) {
            clientNo = clientNo.substring(pos + 1);
        }
        return clientNo;
    }

    private Map<String, Partner> getPartners(String orgId) {
        List<Partner> partners = Cache.getPartnersBySupplierId(orgId);
        HashMap<String, Partner> partnerMap = new HashMap<String, Partner>();
        for (Partner partner : partners) {
            if (StringUtils.isEmpty((Object)partner.getClientAppNo())) continue;
            String clientNo = this.simpleClientNo(partner.getClientAppNo());
            partnerMap.put(clientNo, partner);
        }
        return partnerMap;
    }

    private List<Warning> getWarnings(Map<String, Partner> partnerMap) {
        String hql = " from Warning where isUse='Y' ";
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (Warning warning : this.baseDao.findEntity(hql, Warning.class)) {
            String id = warning.getCustomerId();
            Partner p = null;
            for (String key : partnerMap.keySet()) {
                Partner partner = partnerMap.get(key);
                if (!partner.getId().equals(id)) continue;
                p = partner;
                break;
            }
            if (p == null) continue;
            warnings.add(warning);
        }
        return warnings;
    }

    private List<Warning> getParnterWarnings(List<Warning> all, String partnerId) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (Warning warning : all) {
            if (!partnerId.equals(warning.getCustomerId())) continue;
            warnings.add(warning);
        }
        return warnings;
    }

    private int initWaringSummary(String partnerId, String clientNo, List<Warning> warnings) {
        int count = 0;
        try (Session session = this.sessionFactory2.openSession();){
            String sql2 = "select zid,itemcode,batch,productionDate,count(itemcode) from V_DealerBarcodeLib where zid='" + clientNo + "' group by zid,itemcode,batch,productionDate";
            List list = session.createSQLQuery(sql2).list();
            HashMap<String, WarSummary> summarys = new HashMap<String, WarSummary>();
            int i = 0;
            while (i < list.size()) {
                Object[] row = (Object[])list.get(i);
                String itemcode = (String)row[1];
                String batch = (String)row[2];
                Date productionDate = (Date)row[3];
                int quantity = (Integer)row[4];
                for (Warning warning : warnings) {
                    if (productionDate == null) continue;
                    Long splitDays = DateUtils.getDays((Date)productionDate, (Date)DateUtils.now());
                    Long days = warning.getExpireDays();
                    if (splitDays < 730L - days) continue;
                    String key = String.valueOf(itemcode) + "-" + batch + "-" + days;
                    WarSummary summary = (WarSummary)summarys.get(key);
                    if (summary == null) {
                        summary = new WarSummary(batch, partnerId, clientNo, itemcode, 0.0, String.valueOf(warning.getExpireDays()));
                        summary.setCreateDt(DateUtils.now());
                        summary.setLastUpdateDt(DateUtils.now());
                        summary.setCreatorId("1-1");
                        summary.setLastUpdatorId("1-1");
                        summarys.put(key, summary);
                    }
                    summary.setSummaryTotal(summary.getSummaryTotal() + (double)quantity);
                }
                ++i;
            }
            this.baseDao.executeHQL("delete from WarSummary where dealerId='" + partnerId + "'");
            for (String key : summarys.keySet()) {
                WarSummary summary = (WarSummary)summarys.get(key);
                if (summary.getSummaryTotal() == 0.0) continue;
                this.baseDao.save((Object)summary);
                ++count;
            }
        }
        return count;
    }

    private String initWaringSummarys(String orgId) {
        Map<String, Partner> partnerMap = this.getPartners(orgId);
        List<Warning> all = this.getWarnings(partnerMap);
        int count = 0;
        for (String clientNo : partnerMap.keySet()) {
            String partnerId = partnerMap.get(clientNo).getId();
            List<Warning> warnings = this.getParnterWarnings(all, partnerId);
            if (warnings == null || warnings.size() == 0) continue;
            count += this.initWaringSummary(partnerId, clientNo, warnings);
        }
        return "\u66f4\u65b0\u4ea7\u54c1\u6548\u671f\u6570:" + count;
    }
}

