/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.entity.ExpensesOrder;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.expapply.ExpService;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.util.ServletContextUtils;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class OAFeeJob {
    @Autowired
    SessionFactory sessionFactory2;
    @Autowired
    BaseDao baseDao;
    @Autowired
    JobService jobService;
    @Autowired
    ClientService clientService;
    @Autowired
    ExpService expService;
    @Autowired
    OrderNoService orderNoService;

    public void run() {
        String[] orgIds;
        String[] stringArray = orgIds = new String[]{"1-22UH", "1-1JK1"};
        int n = orgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String orgId = stringArray[n2];
            this.run(orgId);
            ++n2;
        }
    }

    public void run(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "grapoafee");
        long start = System.currentTimeMillis();
        try {
            String rtn = this.grapOaFee(orgId);
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    private String grapOaFee(String orgId) {
        List list = this.baseDao.findEntity(" from ExpensesOrder o where o.state = '0' ", ExpensesOrder.class);
        ApplicationContext ac = ServletContextUtils.getContext();
        int successCount = 0;
        int fauleCount = 0;
        for (ExpensesOrder b : list) {
            ExpBalance eb = new ExpBalance();
            eb.setId(b.getId());
            eb.setApplyerId(b.getTargetId());
            eb.setSupplierId(orgId);
            eb.setOperatorName(b.getApplyerName());
            eb.setOperateDt(b.getApplyDt());
            eb.setBudgetTargetType(b.getTargetType());
            eb.setBudgetTargetId(b.getTargetId());
            eb.setExpensesItemCode(b.getExpensesItemCode());
            eb.setNo(this.orderNoService.maxNo("TCBJ", "FYHX"));
            eb.setApp("OA");
            eb.setSource(b.getSourceSystem());
            eb.setBusinessId(b.getSourceId());
            eb.setState("1");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            eb.setYear(Long.valueOf(sdf.format(b.getApplyDt())));
            eb.setAmount(b.getAmount());
            try {
                this.expService.saveBalance(orgId, eb);
                b.setState("1");
                ++successCount;
            }
            catch (AppException e) {
                e.printStackTrace();
                b.setState("9");
                String msg = null;
                String code = e.getCode();
                Object[] args = e.getArgs();
                if (StringUtils.isNotEmpty(code)) {
                    msg = ac.getMessage(code, args, null);
                }
                b.setStateRemark(msg);
                ++fauleCount;
            }
            catch (Throwable ex) {
                b.setState("9");
                b.setStateRemark(ex.getMessage());
                ++fauleCount;
            }
        }
        return "\u6293\u53d6\u6298\u8ba9\u7533\u8bf7\u6210\u529f\u6570:" + successCount + ",\u5931\u8d25\u4e2a\u6570:" + fauleCount;
    }
}

