/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.ProductCondition;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.common.WmsDao;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.OrderInOut;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.fgift.FGiftFacadeService;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderApplyService")
public class OrderApplyService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    protected IntRebatemgFacadeService intRebatemgService;
    @Autowired
    protected GiftIntRebatemgService giftIntRebatemgService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    AplfineService aplfineService;
    @Autowired
    protected GiftService giftService;
    @Autowired
    protected FGiftFacadeService fGiftService;
    @Autowired
    WmsDao wmsDao;
    @Autowired
    ScoreService scoreService;

    @PostConstruct
    public void init() {
    }

    public int[] getOrderStats(String employeeId, String partnerId) {
        String regions = this.personnelService.getFRegionsByUserId(employeeId);
        String hql = "select new OrderApply(o.id,o.applyerId,o.supplierId,o.nature,o.state) from OrderApply o where ( ";
        hql = String.valueOf(hql) + " (o.applyerId=?) or (o.supplierId=? and o.areaCode in(" + regions + ") ";
        hql = String.valueOf(hql) + " )  ";
        hql = String.valueOf(hql) + " and (o.state=? or o.state=? or o.state=?)) ";
        Object[] args = new Object[]{partnerId, partnerId, "0", "2", "2-0"};
        List applys = this.baseDao.findEntity(hql, args, OrderApply.class);
        int drafts = 0;
        int nopass = 0;
        int approves = 0;
        int rtn_drafts = 0;
        int rtn_nopass = 0;
        int rtn_approves = 0;
        for (OrderApply apply : applys) {
            if (apply.getApplyerId().equals(partnerId)) {
                if (apply.getNature().equals("1")) {
                    if (apply.getState().equals("0")) {
                        ++drafts;
                        continue;
                    }
                    if (!apply.getState().equals("2-0")) continue;
                    ++nopass;
                    continue;
                }
                if (!apply.getNature().equals("2")) continue;
                if (apply.getState().equals("0")) {
                    ++rtn_drafts;
                    continue;
                }
                if (!apply.getState().equals("2-0")) continue;
                ++rtn_nopass;
                continue;
            }
            if (!apply.getSupplierId().equals(partnerId)) continue;
            if (apply.getNature().equals("1")) {
                if (!apply.getState().equals("2")) continue;
                ++approves;
                continue;
            }
            if (!apply.getNature().equals("2") || !apply.getState().equals("2")) continue;
            ++rtn_approves;
        }
        int[] rtns = new int[]{drafts, nopass, approves, rtn_drafts, rtn_nopass, rtn_approves};
        return rtns;
    }

    public Double getContractOrdersMoney(String applyerId, String contractNo) {
        String sql = "select sum(apply.REBATE_END_MONEY),1 from \tCX_INDENT_Apply apply \twhere \tapply.dealer_id='" + applyerId + "' and " + "\tapply.PACT_NO='" + contractNo + "' and " + "\tapply.NATURE='1' and " + "\t( " + "\t\tapply.INDENT_FLAG='3' or " + "\t\tapply.INDENT_FLAG='4' or " + "\t\tapply.INDENT_FLAG='5' or " + "\t\tapply.INDENT_FLAG='6' " + "\t) " + "\tgroup by apply.dealer_id ";
        List list = this.baseDao.findBySql(sql);
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        Object[] val = (Object[])list.get(0);
        if (val[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)val[0]).doubleValue();
    }

    public Double getContractRtnOrdersFullyMoney(String applyerId, String contractNo, String extendId) {
        List list;
        String sql = "select sum(apply.RETURNED_MONEY-apply.RETUNS_OVERTOP_MONEY),1 from \tCX_INDENT_Apply apply \twhere \tapply.dealer_id='" + applyerId + "' and " + "\tapply.PACT_NO='" + contractNo + "' and " + "\tapply.NATURE='2' and " + "\t( " + "\t\tapply.INDENT_FLAG='2' or " + "\t\tapply.INDENT_FLAG='3' or " + "\t\tapply.INDENT_FLAG='4' or " + "\t\tapply.INDENT_FLAG='5' or " + "\t\tapply.INDENT_FLAG='6' " + "\t) ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + "\tand apply.row_id!='" + extendId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql = String.valueOf(sql) + "\tgroup by apply.dealer_id ")) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] val = (Object[])list.get(0);
        if (val[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)val[0]).doubleValue();
    }

    public Double getUsingOtherDiacount(String applyerId, String supplierId, String excludeId) {
        String sql = " select sum(apply.OTHER_REBATE_MONEY),1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        List list = this.baseDao.findBySql(sql);
        Double rtn = 0.0;
        if (list == null || list.size() == 0) {
            return rtn;
        }
        Object[] discount = (Object[])list.get(0);
        rtn = discount[0] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[0]).doubleValue());
        return rtn;
    }

    public Double[] getUsingDiacount(String applyerId, String supplierId, String excludeId) {
        String sql = " select sum(apply.REBATE_MONEY),sum(apply.GIFT_REBATE_MONEY) from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        List list = this.baseDao.findBySql(sql);
        Double[] rtn = new Double[]{0.0, 0.0};
        if (list == null || list.size() == 0) {
            return rtn;
        }
        Object[] discount = (Object[])list.get(0);
        rtn[0] = discount[0] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[0]).doubleValue());
        rtn[1] = discount[1] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[1]).doubleValue());
        return rtn;
    }

    public Double getUsingPenalty(String applyerId, String supplierId, String excludeId) {
        List list;
        String sql = " select sum(apply.FINE_MONEY),1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] penalty = (Object[])list.get(0);
        if (penalty[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)penalty[0]).doubleValue();
    }

    public Double _getUsingFreeGiftMoney(String applyerId, String supplierId, String type, String excludeId) {
        List list;
        String statCol = "FREE_GIFT_MONEY";
        if (type != null && type.toLowerCase().equals("quantity")) {
            statCol = "FREE_GIFT";
        }
        String sql = " select sum(apply." + statCol + "),1 from " + "\tCX_INDENT_Apply apply " + "\twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] freeGiftMoney = (Object[])list.get(0);
        if (freeGiftMoney[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)freeGiftMoney[0]).doubleValue();
    }

    public Double getUsingFreeGiftMoney(String applyerId, String supplierId, String type, String excludeId, Integer precision) {
        List list;
        String sql = " select  sum(       CASE WHEN (apply.FREE_GIFT_MONEY - apply.free_gift_order) < 0 then 0           else(apply.FREE_GIFT_MONEY - apply.free_gift_order) end       ) ,1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] freeGiftMoney = (Object[])list.get(0);
        if (freeGiftMoney[0] == null) {
            return 0.0;
        }
        return MathUtils.getPrecision((Double)((BigDecimal)freeGiftMoney[0]).doubleValue(), (Integer)precision);
    }

    public Map<String, Double> findProductApplyedQuantitys(String supplierId, String extendId) {
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.SUPPLIER_ID='" + supplierId + "' and " + "\tapply.NATURE='1' and ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + "\tapply.row_id!='" + extendId + "' and ";
        }
        sql = String.valueOf(sql) + "  (apply.INDENT_FLAG='2' or apply.INDENT_FLAG='3') group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findProductApplyedQuantitysForOrg(String supplierId, String extendId) {
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply,cx_sale_order_header_iface cso \twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tcso.crm_order_id(+)=apply.ROW_ID and\tapply.SUPPLIER_ID='" + supplierId + "' and " + "\tapply.NATURE='1' and ( " + "  cso.source_system='CRM' and cso.target_system='EAS' and " + "  (cso.eas_iface_flag='0' or cso.eas_iface_flag='2') or ( cso.crm_order_id is null )  ) ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + " and apply.row_id!='" + extendId + "' ";
        }
        sql = String.valueOf(sql) + " and nvl(item.isscore,'0') != 'Y' ";
        sql = String.valueOf(sql) + "  and (apply.INDENT_FLAG='2' or apply.INDENT_FLAG='3') ";
        sql = String.valueOf(sql) + " group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findRtnProductApplyedQuantitys(String applyerId, String extendId) {
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.DEALER_ID='" + applyerId + "' and " + "\tapply.NATURE='" + 2 + "' and ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + " apply.row_id!='" + extendId + "' and ";
        }
        sql = String.valueOf(sql) + "  (apply.INDENT_FLAG='2' or apply.INDENT_FLAG='3' or apply.INDENT_FLAG='4') group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findProductApplyQuantitys(String applyerId, String supplierId, Date startDt, Date endDt, String excludeId) {
        if (startDt == null) {
            startDt = DateUtils.now();
        }
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.NATURE='1' and \tapply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and " + "\tapply.INDENT_DATE>=to_date('" + DateUtils.getDate((Date)startDt, (String)"yyyyMMdd") + "','yyyymmdd') and";
        if (endDt != null) {
            endDt = DateUtils.getDateAfter((Date)endDt, (int)1);
            sql = String.valueOf(sql) + "\tapply.indent_date<=to_date('" + DateUtils.getDate((Date)endDt, (String)"yyyyMMdd") + "','yyyymmdd') and";
        }
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " apply.row_id!='" + excludeId + "' and ";
        }
        sql = String.valueOf(sql) + " ( apply.INDENT_FLAG!='0' and apply.INDENT_FLAG!='2-0' and apply.INDENT_FLAG!='9' ) and apply.indent_date is not null group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Page findOrderApplys(OrderApplyCondition con, String orderby) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("select distinct o from OrderApply o,Partner p  ");
        if (StringUtils.isNotEmpty(con.getProductNo())) {
            HQL.append(",OrderApplyItem i ");
        }
        HQL.append(" where o.applyerId=p.id ");
        if (StringUtils.isNotEmpty(con.getProductNo())) {
            HQL.append(" and o.id=i.orderApplyId ");
            HQL.append(" and i.no like ?");
            args.add("%" + con.getProductNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            HQL.append(" and o.applyerId = ?");
            args.add(con.getApplyerId());
        }
        if (StringUtils.isNotEmpty(con.getNature())) {
            HQL.append(" and o.nature = ?");
            args.add(con.getNature());
        }
        if (StringUtils.isNotEmpty(con.getSupplierId())) {
            HQL.append(" and o.supplierId = ?");
            args.add(con.getSupplierId());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            HQL.append(" and o.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCreatorId())) {
            HQL.append(" and o.creatorId = ?");
            args.add(con.getCreatorId());
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and o.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and o.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (con.isRegionFilter()) {
            String employeeId = con.getEmployeeId();
            String partnerIds = this.personnelService.getPartnerIds(employeeId);
            String regions = this.personnelService.getFRegionsByUserId(employeeId);
            if (!"'1-2-3'".equals(partnerIds)) {
                HQL.append(" and p.id in ( ");
                HQL.append(partnerIds);
                HQL.append(" ) ");
            } else {
                HQL.append(" and o.areaCode in ( ");
                HQL.append(regions);
                HQL.append(" ) ");
            }
        }
        String areaCodes = null;
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            areaCodes = "'" + con.getAreaCode() + "'";
        } else if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            areaCodes = this.personnelService.getFRegionsById(con.getSupplierId(), con.getSaleChannelTypeCode(), con.getBigAreaCode());
        } else if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            areaCodes = this.personnelService.getFRegionsById(con.getSupplierId(), con.getSaleChannelTypeCode(), null);
        }
        if (StringUtils.isNotEmpty(areaCodes)) {
            HQL.append(" and o.areaCode in ( ");
            HQL.append(areaCodes);
            HQL.append(" ) ");
        }
        if (con.getQuantityS() != null) {
            HQL.append(" and o.quantity >= ?");
            args.add(con.getQuantityS());
        }
        if (con.getQuantityE() != null) {
            HQL.append(" and o.quantity <= ?");
            args.add(con.getQuantityE());
        }
        if (con.getMoneyS() != null) {
            HQL.append(" and o.totalMoney >= ?");
            args.add(con.getMoneyS());
        }
        if (con.getMoneyE() != null) {
            HQL.append(" and o.totalMoney <= ?");
            args.add(con.getMoneyE());
        }
        if (StringUtils.isNotEmpty(con.getContacts())) {
            HQL.append(" and o.orderContacts like ?");
            args.add("%" + con.getContacts().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getPurchaseNo())) {
            HQL.append(" and o.purchaseNo like ?");
            args.add("%" + con.getPurchaseNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getApplyerName())) {
            HQL.append(" and p.name like ?");
            args.add("%" + con.getApplyerName().trim() + "%");
        }
        if (con.getOrderStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : con.getOrderStates()) {
                HQL.append(" o.state = ?");
                if (++i < con.getOrderStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        HQL.append(" and o.state!=? ");
        args.add(TCBJEnum.AuditState.del.getValue());
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(orderby);
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue());
    }

    public List<OrderApplyItem> getOrderApplyItems(String orderApplyId) {
        String hql = "from OrderApplyItem where orderApplyId=?";
        Object[] args = new Object[]{orderApplyId};
        return this.baseDao.findEntity(hql, args, OrderApplyItem.class);
    }

    public OrderApply getOrderApply(String orderApplyId) {
        OrderApply orderApply = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderApplyId));
        orderApply.setOrderApplyItems(this.getOrderApplyItems(orderApplyId));
        return orderApply;
    }

    public OrderApply getSimpleOrderApply(String orderApplyId) {
        OrderApply orderApply = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderApplyId));
        return orderApply;
    }

    public void updateOrderApplyState(String id, String state, Employee me) {
        String hql = "update OrderApply set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public void addOrderInOut(String id, Employee me) {
        OrderApply apply = this.getOrderApply(id);
        this.createOrderInOut(apply, me);
    }

    public void delOrderApply(String orderApplyId) {
        Object[] args = new Object[]{orderApplyId};
        String hql = "delete OrderApplyItem where orderApplyId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete OrderApply where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public void cancelOrderApply(String orderApplyId, String[] exchangeOrderIds) {
        Object[] args = new Object[]{TCBJEnum.AuditState.del.getValue(), orderApplyId};
        String hql = "update OrderApply set state=?,exchangeOrderIds=null where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public boolean hasPushOrder(String supplierId, String applyerId) {
        return this.baseDao.exist(" from OrderApply o where o.applyerId = ? and o.supplierId = ? and  o.source = ? and o.state = '0'", new Object[]{applyerId, supplierId, "\u81ea\u52a8\u8865\u8d27"});
    }

    public boolean hasBind(String partnerId, String[] ids, String extendId) {
        String hql = " select new OrderApply(id,exchangeOrderIds) from OrderApply where (state=? or state=?) and applyerId=? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(TCBJEnum.AuditState.draft.getValue());
        args.add(TCBJEnum.AuditState.approve.getValue());
        args.add(partnerId);
        if (StringUtils.isNotEmpty(extendId)) {
            hql = String.valueOf(hql) + " and id!=? ";
            args.add(extendId);
        }
        List applys = this.baseDao.findEntity(hql, args.toArray(), OrderApply.class);
        for (OrderApply apply : applys) {
            String[] exchangeOrderIds = apply.getExchangeOrderIdArray();
            if (exchangeOrderIds == null) continue;
            String[] stringArray = exchangeOrderIds;
            int n = exchangeOrderIds.length;
            int n2 = 0;
            while (n2 < n) {
                String exchangeOrderId = stringArray[n2];
                String[] stringArray2 = ids;
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id = stringArray2[n4];
                    if (id.equals(exchangeOrderId)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public List<ExchangeOrder> filterHasBind(String partnerId, List<ExchangeOrder> orders, String extendId) {
        String hql = " select new OrderApply(id,exchangeOrderIds) from OrderApply where (state=? or state=? or state = ? ) and applyerId=? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(TCBJEnum.AuditState.draft.getValue());
        args.add(TCBJEnum.AuditState.approve.getValue());
        args.add(TCBJEnum.AuditState.approvePass.getValue());
        args.add(partnerId);
        if (StringUtils.isNotEmpty(extendId)) {
            hql = String.valueOf(hql) + " and id!=? ";
            args.add(extendId);
        }
        List applys = this.baseDao.findEntity(hql, args.toArray(), OrderApply.class);
        ArrayList<ExchangeOrder> newOrders = new ArrayList<ExchangeOrder>();
        for (ExchangeOrder order : orders) {
            boolean hasSubmit = false;
            for (OrderApply apply : applys) {
                String[] exchangeOrderIds = apply.getExchangeOrderIdArray();
                if (exchangeOrderIds == null) continue;
                String[] stringArray = exchangeOrderIds;
                int n = exchangeOrderIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id.equals(order.getId())) {
                        hasSubmit = true;
                    }
                    ++n2;
                }
            }
            if (hasSubmit) continue;
            newOrders.add(order);
        }
        return newOrders;
    }

    private void submitExchangeOrders(OrderApply orderApply) {
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.scoreService.submitExchangeOrder(id);
            ++n2;
        }
    }

    private void unApproveExchangeOrders(String orderId) {
        OrderApply orderApply = this.getSimpleOrderApply(orderId);
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.scoreService.unApproveExchangeOrder(id);
            ++n2;
        }
    }

    private void approveExchangeOrders(OrderApply orderApply) {
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        List<ExchangeDetail> exchangeDetails = this.scoreService.getExchangeDetailsByIds(ids);
        List<ProductGiftView> products = this.scoreService.getProducts(orderApply.getSupplierId());
        HashMap<String, ProductGiftView> productMap = new HashMap<String, ProductGiftView>();
        for (ProductGiftView product : products) {
            productMap.put(product.getId(), product);
        }
        ArrayList<OrderApplyItem> items = new ArrayList<OrderApplyItem>();
        for (ExchangeDetail detail : exchangeDetails) {
            ProductGiftView product = (ProductGiftView)productMap.get(detail.getProductId());
            if (product == null) continue;
            OrderApplyItem item = new OrderApplyItem();
            item.setActPrice(product.getPrice());
            item.setActQuantity(detail.getQuantity());
            item.setBasePrice(product.getPrice());
            item.setCreateDt(orderApply.getCreateDt());
            item.setCreatorId(orderApply.getCreatorId());
            item.setLastUpdateDt(orderApply.getLastUpdateDt());
            item.setLastUpdatorId(orderApply.getLastUpdatorId());
            item.setIsFree("Y");
            item.setIsScore("Y");
            item.setBasePoints(detail.getPoints() == null ? 0.0 : detail.getPoints());
            item.setMinUnit(1.0);
            item.setMoney(MathUtils.mul((Double)(product.getPrice() == null ? 0.0 : product.getPrice()), (Double)detail.getQuantity()));
            item.setNo(product.getNo());
            item.setOrderApplyId(orderApply.getId());
            item.setPrice(product.getPrice());
            item.setPriceFormula(null);
            item.setProductId(detail.getProductId());
            item.setQuantity(detail.getQuantity());
            item.setSpec(product.getSpec());
            item.setRemark(null);
            item.setUnitCode(product.getUnitCode());
            items.add(item);
        }
        this.baseDao.save(items);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                this.scoreService.approveExchangeOrder(id);
            }
            ++n2;
        }
    }

    public void approveOrderApply(OrderApply orderApply, boolean triggerEAS, Integer precision) {
        OrderApply old = this.getSimpleOrderApply(orderApply.getId());
        old.setContacts(orderApply.getContacts());
        old.setPhone(orderApply.getPhone());
        old.setShippingAddress(orderApply.getShippingAddress());
        old.setExpectDate(orderApply.getExpectDate());
        old.setOrderContacts(orderApply.getOrderContacts());
        old.setOrderPhone(orderApply.getOrderPhone());
        old.setPurchaseNo(orderApply.getPurchaseNo());
        old.setPredictArriveDt(orderApply.getPredictArriveDt());
        old.setDeliveryLevelCode(orderApply.getDeliveryLevelCode());
        old.setOrderTypeCode(orderApply.getOrderTypeCode());
        old.setIsReport(orderApply.getIsReport());
        old.setTaxCode(orderApply.getTaxCode());
        old.setAreaCode(orderApply.getAreaCode());
        old.setSettlementModeCode(orderApply.getSettlementModeCode());
        old.setDeliveryCode(orderApply.getDeliveryCode());
        old.setIsCreditManaged(orderApply.getIsCreditManaged());
        old.setOverCreditRemark(orderApply.getOverCreditRemark());
        old.setState(orderApply.getState());
        old.setQuantity(orderApply.getQuantity());
        old.setTotalMoney(orderApply.getTotalMoney());
        old.setRemainMoney(orderApply.getRemainMoney());
        old.setRetunsFullyMoney(orderApply.getRetunsFullyMoney());
        old.setRetunsOvertopMoney(orderApply.getRetunsOvertopMoney());
        old.setReturnedMoney(orderApply.getReturnedMoney());
        old.setDiscountTotalMoney(orderApply.getDiscountTotalMoney());
        old.setDiscountCanuseMoney(orderApply.getDiscountCanuseMoney());
        old.setDiscountMoney(orderApply.getDiscountMoney());
        old.setGiftDiscountTotalMoney(orderApply.getGiftDiscountTotalMoney());
        old.setGiftDiscountCanuseMoney(orderApply.getGiftDiscountCanuseMoney());
        old.setGiftDiscountMoney(orderApply.getGiftDiscountMoney());
        old.setOtherDiscountTotalMoney(orderApply.getOtherDiscountTotalMoney());
        old.setOtherDiscountCanuseMoney(orderApply.getOtherDiscountCanuseMoney());
        old.setOtherDiscountMoney(orderApply.getOtherDiscountMoney());
        old.setFreeGift(orderApply.getFreeGift());
        old.setFreeGiftMoney(orderApply.getFreeGiftMoney());
        old.setFreeGiftOrder(orderApply.getFreeGiftOrder());
        old.setFreeGiftTotal(orderApply.getFreeGiftTotal());
        old.setFineTotalMoney(orderApply.getFineTotalMoney());
        old.setFineMoney(orderApply.getFineMoney());
        old.setFineOverMoney(orderApply.getFineOverMoney());
        old.setFreeMoney(orderApply.getFreeMoney());
        old.setApproverId(orderApply.getApproverId());
        old.setApproveDt(orderApply.getApproveDt());
        old.setActGiftQuantity(orderApply.getActGiftQuantity());
        orderApply.setDt(old.getDt());
        this.updateOrderApplyItems(orderApply);
        if (orderApply.getDiscountMoney() != null && orderApply.getDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getProductTotalMoney(), orderApply.getDiscountMoney(), old.getDt(), "PRODUCT");
        }
        if (orderApply.getGiftDiscountMoney() != null && orderApply.getGiftDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getGiftTotalMoney(), orderApply.getGiftDiscountMoney(), old.getDt(), "GIFT");
        }
        if (orderApply.getOtherDiscountMoney() != null && orderApply.getOtherDiscountMoney() > 0.0) {
            this.giftIntRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getGiftTotalMoney(), orderApply.getOtherDiscountMoney(), old.getDt());
        }
        if (orderApply.getFineMoney() != null && orderApply.getFineMoney() > 0.0) {
            this.aplfineService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getTotalMoney(), orderApply.getFineMoney(), old.getDt());
        }
        this.fGiftService.use(orderApply, orderApply.getFreeGift(), orderApply.getFreeGiftMoney(), precision);
        this.giftService.use(orderApply, orderApply.getActGiftQuantity());
        Partner supplier = this.partnerService.getPartner(orderApply.getSupplierId());
        if (supplier.isOrg() && StringUtils.isNotEmpty(old.getExchangeOrderIds())) {
            this.approveExchangeOrders(old);
        }
    }

    public void triggerEAS(String orderId) {
        Object[] objs = null;
        try {
            objs = this.baseDao.callExecute("cx_sale_order_iface_pub.CREATE_SO_TO_IFACE", new Object[]{orderId, "F"}, new Integer[]{12, 12});
        }
        catch (Exception e) {
            throw new AppException("3018", e.getMessage());
        }
        String code = (String)objs[0];
        String message = (String)objs[1];
        if ("E".equals(code)) {
            throw new AppException("3018", message);
        }
    }

    private void saveOrderApply(OrderApply orderApply) {
        this.baseDao.save((Object)orderApply);
        for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
            orderApplyItem.setOrderApplyId(orderApply.getId());
            orderApplyItem.setActPrice(orderApplyItem.getPrice());
            orderApplyItem.setActQuantity(orderApplyItem.getQuantity());
        }
        this.baseDao.save(orderApply.getOrderApplyItems());
    }

    private void updateOrderApply(OrderApply orderApply) {
        OrderApply old = this.getSimpleOrderApply(orderApply.getId());
        old.setContacts(orderApply.getContacts());
        old.setPhone(orderApply.getPhone());
        old.setShippingAddress(orderApply.getShippingAddress());
        old.setExpectDate(orderApply.getExpectDate());
        old.setOrderContacts(orderApply.getOrderContacts());
        old.setOrderPhone(orderApply.getOrderPhone());
        old.setPurchaseNo(orderApply.getPurchaseNo());
        old.setRemark(orderApply.getRemark());
        old.setQuantity(orderApply.getQuantity());
        old.setTotalMoney(orderApply.getTotalMoney());
        old.setSalesman(orderApply.getSalesman());
        old.setHarvestWarehouse(orderApply.getHarvestWarehouse());
        old.setDisApplyerId(orderApply.getDisApplyerId());
        old.setRelatedApplyerId(orderApply.getRelatedApplyerId());
        old.setDiscountTotalMoney(orderApply.getDiscountTotalMoney());
        old.setDiscountCanuseMoney(orderApply.getDiscountCanuseMoney());
        old.setDiscountMoney(orderApply.getDiscountMoney());
        old.setGiftDiscountTotalMoney(orderApply.getGiftDiscountTotalMoney());
        old.setGiftDiscountCanuseMoney(orderApply.getGiftDiscountCanuseMoney());
        old.setGiftDiscountMoney(orderApply.getGiftDiscountMoney());
        old.setOtherDiscountTotalMoney(orderApply.getOtherDiscountTotalMoney());
        old.setOtherDiscountCanuseMoney(orderApply.getOtherDiscountCanuseMoney());
        old.setOtherDiscountMoney(orderApply.getOtherDiscountMoney());
        old.setFreeGift(orderApply.getFreeGift());
        old.setFreeGiftMoney(orderApply.getFreeGiftMoney());
        old.setFreeGiftOrder(orderApply.getFreeGiftOrder());
        old.setFreeGiftTotal(orderApply.getFreeGiftTotal());
        old.setRemainMoney(orderApply.getRemainMoney());
        old.setRetunsFullyMoney(orderApply.getRetunsFullyMoney());
        old.setRetunsOvertopMoney(orderApply.getRetunsOvertopMoney());
        old.setReturnedMoney(orderApply.getReturnedMoney());
        old.setFineTotalMoney(orderApply.getFineTotalMoney());
        old.setFineMoney(orderApply.getFineMoney());
        old.setFineOverMoney(orderApply.getFineOverMoney());
        old.setFreeMoney(orderApply.getFreeMoney());
        old.setLastUpdateDt(orderApply.getLastUpdateDt());
        old.setLastUpdatorId(orderApply.getLastUpdatorId());
        old.setState(orderApply.getState());
        if (old.getDt() == null) {
            old.setDt(orderApply.getDt());
        }
        if (old.getNo() == null) {
            old.setNo(orderApply.getNo());
        }
    }

    private void updateOrderApplyItems(OrderApply orderApply) {
        List<OrderApplyItem> newItems = orderApply.getOrderApplyItems();
        List<OrderApplyItem> items = this.getOrderApplyItems(orderApply.getId());
        ArrayList updateItems = new ArrayList();
        ArrayList<OrderApplyItem> appendItems = new ArrayList<OrderApplyItem>();
        ArrayList<OrderApplyItem> delItems = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem ni : newItems) {
            boolean isnew = true;
            for (OrderApplyItem i : items) {
                if (!ni.getProductId().equals(i.getProductId()) || !ni.getBatchNum().equals(i.getBatchNum())) continue;
                i.update(ni);
                isnew = false;
                break;
            }
            if (!isnew) continue;
            ni.setId(UUIDUtils.getId());
            ni.setOrderApplyId(orderApply.getId());
            appendItems.add(ni);
        }
        for (OrderApplyItem i : items) {
            boolean isdel = true;
            for (OrderApplyItem ni : newItems) {
                if (!ni.getProductId().equals(i.getProductId()) || !ni.getBatchNum().equals(i.getBatchNum())) continue;
                isdel = false;
                break;
            }
            if (!isdel) continue;
            delItems.add(i);
        }
        if (appendItems.size() > 0) {
            this.baseDao.save(appendItems);
        }
        if (updateItems.size() > 0) {
            this.baseDao.update(updateItems);
        }
        if (delItems.size() > 0) {
            this.baseDao.deleteAll(delItems);
        }
    }

    public void saveOrUpdateOrderApply(OrderApply orderApply, boolean triggerEAS) {
        if (StringUtils.isEmpty(orderApply.getId())) {
            this.saveOrderApply(orderApply);
        } else {
            this.updateOrderApply(orderApply);
            this.updateOrderApplyItems(orderApply);
        }
        if (orderApply.getState().equals(TCBJEnum.AuditState.approve.getValue())) {
            this.submitExchangeOrders(orderApply);
        }
    }

    public List<Product> findProducts(ProductCondition con) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Product where 1=1 ");
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        HQL.append(" order by createDt ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Product.class);
    }

    public void createOrderInOut(OrderApply apply, Employee me) {
        OrderInOut io = new OrderInOut();
        io.setId(UUIDUtils.getId());
        io.setOrderId(apply.getId());
        io.setNo("CKD00001");
        io.fillInitData(me);
        io.setState(TCBJEnum.SendOrReceiveState.sending.getValue());
        this.baseDao.save((Object)io);
        for (OrderApplyItem item : apply.getOrderApplyItems()) {
            OrderInOutItem oi = new OrderInOutItem();
            oi.setProductId(item.getProductId());
            oi.setOrderInOutId(io.getId());
            oi.setOrderItemId(item.getId());
            oi.setQuantity(item.getQuantity());
            oi.setRemark(apply.getRemark());
            oi.fillInitData(me);
            this.baseDao.save((Object)oi);
        }
    }

    public void unApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        if ("N".equals(rtn)) {
            throw new AppException("3019");
        }
        objs = this.baseDao.callExecute("cx_sale_order_iface_pub.reapprove_process_btn", new Object[]{orderId, "T"}, new Integer[]{12, 12});
        rtn = (String)objs[0];
        String msg = (String)objs[1];
        if ("E".equals(rtn)) {
            throw new AppException("3020", msg);
        }
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
        this.intRebatemgService.unuse(orderId);
        this.giftIntRebatemgService.unuse(orderId);
        this.aplfineService.unuse(orderId);
        this.giftService.unuse(orderId);
        this.fGiftService.unuse(orderId);
    }

    public boolean canApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        return "Y".equals(rtn);
    }

    public Page findOrderLogitics(OrderApplyCondition con) {
        String orderBy = "order by o.lastUpdateDt desc";
        Page page = this.findOrderApplys(con, orderBy);
        List orders = page.getList();
        if (Beans.isEmpty((Object)orders)) {
            return page;
        }
        ArrayList<String> orderIds = new ArrayList<String>();
        for (OrderApply order : orders) {
            orderIds.add(order.getNo());
        }
        List<Map<String, Object>> logitics = this.getLogitics(orderIds);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (OrderApply order : orders) {
            Map<String, Object> map = order.toLogiticsMap();
            for (Map<String, Object> m : logitics) {
                if (!m.get("EXTEND_C5").equals(map.get("no"))) continue;
                map.putAll(m);
            }
            result.add(map);
        }
        page.setList(result);
        return page;
    }

    private List<Map<String, Object>> getLogitics(List<String> orderIds) {
        if (Beans.isEmpty(orderIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        StringBuilder logiticsSql = new StringBuilder("select * from TCBJWMS.ORDER_INFO_VIEW a where a.EXTEND_C5 in (");
        int i = 0;
        while (i < orderIds.size()) {
            if (i == orderIds.size() - 1) {
                logiticsSql.append("?)");
            } else {
                logiticsSql.append("?,");
            }
            ++i;
        }
        List<Map<String, Object>> logiticsList = this.wmsDao.findBySql(logiticsSql.toString(), orderIds.toArray());
        return logiticsList;
    }

    public Map<String, Object> findLogiticsByOrderId(String id) {
        List<Map<String, Object>> logitics;
        OrderApply order = this.getOrderApply(id);
        Map<String, Object> map = order.toLogiticsMap();
        String[] ids = new String[]{order.getNo()};
        if (Beans.isNotEmpty((Object)ids) && !Beans.isEmpty(logitics = this.getLogitics(Arrays.asList(ids)))) {
            map.putAll(logitics.get(0));
        }
        map.put("currentState", this.getLogiticState(map));
        return map;
    }

    private String getLogiticState(Map<String, Object> map) {
        if (Beans.isNotEmpty((Object)map.get("sign_time"))) {
            return Constant.LogiticState.received.value;
        }
        if (Beans.isNotEmpty((Object)map.get("Ship_Time"))) {
            return Constant.LogiticState.send.value;
        }
        if (Beans.isNotEmpty((Object)map.get("DELIVER_START_TIME"))) {
            return Constant.LogiticState.picked.value;
        }
        if (Beans.isNotEmpty((Object)map.get("approveDt"))) {
            return Constant.LogiticState.approve.value;
        }
        return Constant.LogiticState.submit.value;
    }
}

