/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.view.Product;
import java.util.Comparator;
import java.util.Date;
import org.springframework.util.StringUtils;

public class OrderProduct
implements Comparator<OrderProduct>,
Cloneable {
    private String id;
    private String partnerId;
    private String name;
    private String no;
    private String orgId;
    private String easNo;
    private String unitCode;
    private String unitName;
    private String spec;
    private String type;
    private String subType;
    private String catena;
    private Date invalidDt;
    private Long stockMax;
    private Long stockMin;
    private Double basePrice;
    private Double price;
    private Double penaltyRate = 0.0;
    private String isRecommend;
    private Double limitQuantity;
    private Double quantity;
    private Double money;
    private Double actQuantity;
    private Double actPrice;
    private Double remainQuantity;
    private String remainQuantityView;
    private String productType;
    private String priceFormula;
    private Double minUnit;
    private String hightLight;
    private String displayStock;
    private String valuation;
    private String isFree;
    private String[] prices;
    private String[] minQuantitys;
    private String[] maxQuantitys;
    private String batchNum;

    public OrderProduct() {
    }

    public OrderProduct(Product p, PartnerProductREL pd) {
        this.id = p.getId();
        this.partnerId = pd.getPartnerId();
        this.name = p.getName();
        this.no = p.getNo();
        this.orgId = p.getOrgId();
        this.easNo = p.getEasNo();
        this.unitCode = p.getUnitCode();
        this.unitName = p.getUnitName();
        this.spec = p.getSpec();
        this.type = p.getType();
        this.catena = p.getCatena();
        this.invalidDt = pd.getInvalidDt();
        this.productType = p.getOrderProdType();
        this.price = p.getPrice();
        this.subType = p.getSubType();
        this.isRecommend = p.getRecommendFlag();
        this.quantity = 0.0;
        this.money = 0.0;
        this.minUnit = p.getMinUnit();
        this.basePrice = this.getPrice();
        this.hightLight = p.getHighlightFlag() == null || !p.getHighlightFlag().equals("Y") ? "N" : "Y";
        this.valuation = p.getValuationFlag() == null || !p.getValuationFlag().equals("Y") ? "N" : "Y";
        this.displayStock = pd.getIsDisplay() == null || !pd.getIsDisplay().equals("N") ? "Y" : "N";
    }

    public OrderProduct(String partnerId, OrderApplyItem item) {
        this.id = item.getProductId();
        Product p = Cache.getProduct(this.id);
        if (p == null) {
            p = new Product();
        }
        this.basePrice = p.getPrice();
        this.partnerId = partnerId;
        this.name = p.getName();
        this.no = p.getNo();
        this.orgId = p.getOrgId();
        this.easNo = p.getEasNo();
        this.unitCode = p.getUnitCode();
        this.unitName = p.getUnitName();
        this.spec = p.getSpec();
        this.type = p.getType();
        this.catena = p.getCatena();
        this.price = item.getPrice();
        this.subType = p.getSubType();
        this.productType = p.getOrderProdType();
        this.isRecommend = p.getRecommendFlag();
        this.quantity = item.getQuantity();
        this.money = item.getMoney();
        this.actPrice = item.getActPrice();
        this.actQuantity = item.getActQuantity();
        this.priceFormula = item.getPriceFormula();
        this.minUnit = item.getMinUnit();
        this.hightLight = p.getHighlightFlag();
        this.valuation = p.getValuationFlag();
        this.isFree = item.getIsFree();
        this.batchNum = item.getBatchNum();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getEasNo() {
        return this.easNo;
    }

    public void setEasNo(String easNo) {
        this.easNo = easNo;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCatena() {
        return this.catena;
    }

    public void setCatena(String catena) {
        this.catena = catena;
    }

    public Date getInvalidDt() {
        return this.invalidDt;
    }

    public void setInvalidDt(Date invalidDt) {
        this.invalidDt = invalidDt;
    }

    public Long getStockMax() {
        return this.stockMax;
    }

    public void setStockMax(Long stockMax) {
        this.stockMax = stockMax;
    }

    public Long getStockMin() {
        return this.stockMin;
    }

    public void setStockMin(Long stockMin) {
        this.stockMin = stockMin;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Double getPrice() {
        if (this.price == null) {
            this.price = 0.0;
        }
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String getIsRecommend() {
        return this.isRecommend;
    }

    public void setIsRecommend(String isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Double getLimitQuantity() {
        if (this.limitQuantity == null) {
            return 1000000.0;
        }
        return this.limitQuantity;
    }

    public String getLimitQuantityPrompt() {
        return this.getLimitQuantity().toString();
    }

    public void setLimitQuantity(Double limitQuantity) {
        this.limitQuantity = limitQuantity;
    }

    public Double getQuantity() {
        if (this.quantity == null) {
            this.quantity = 0.0;
        }
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Double getMoney() {
        return this.money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public Double getActQuantity() {
        if (this.actQuantity == null) {
            return 0.0;
        }
        return this.actQuantity;
    }

    public void setActQuantity(Double actQuantity) {
        this.actQuantity = actQuantity;
    }

    public Double getActPrice() {
        if (this.actPrice == null) {
            return 0.0;
        }
        return this.actPrice;
    }

    public void setActPrice(Double actPrice) {
        this.actPrice = actPrice;
    }

    public Double getRemainQuantity() {
        if ("N".equals(this.getDisplayStock())) {
            return 0.0;
        }
        return this.remainQuantity;
    }

    public void setRemainQuantity(Double remainQuantity) {
        this.remainQuantity = remainQuantity;
    }

    public String[] getPrices() {
        return this.prices;
    }

    public void setPrices(String[] prices) {
        this.prices = prices;
    }

    public String[] getMinQuantitys() {
        return this.minQuantitys;
    }

    public void setMinQuantitys(String[] minQuantitys) {
        this.minQuantitys = minQuantitys;
    }

    public String[] getMaxQuantitys() {
        return this.maxQuantitys;
    }

    public void setMaxQuantitys(String[] maxQuantitys) {
        this.maxQuantitys = maxQuantitys;
    }

    public String getRemainQuantityView() {
        return this.remainQuantityView;
    }

    public void setRemainQuantityView(String remainQuantityView) {
        this.remainQuantityView = remainQuantityView;
    }

    public Double getBasePrice() {
        return this.basePrice;
    }

    public void setBasePrice(Double unifiedPrice) {
        this.basePrice = unifiedPrice;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getPriceFormula() {
        return this.priceFormula;
    }

    public String getPriceFormulaView() {
        return this.priceFormula;
    }

    public void setPriceFormula(String priceFormula) {
        this.priceFormula = priceFormula;
    }

    public Double getMinUnit() {
        return this.minUnit;
    }

    public void setMinUnit(Double minUnit) {
        this.minUnit = minUnit;
    }

    public String getHightLight() {
        return this.hightLight;
    }

    public void setHightLight(String hightLight) {
        this.hightLight = hightLight;
    }

    public String getValuation() {
        return this.valuation;
    }

    public void setValuation(String valuation) {
        this.valuation = valuation;
    }

    public String getDisplayStock() {
        return this.displayStock;
    }

    public void setDisplayStock(String displayStock) {
        this.displayStock = displayStock;
    }

    public Double getPenaltyRate() {
        return this.penaltyRate;
    }

    public void setPenaltyRate(Double penaltyRate) {
        this.penaltyRate = penaltyRate;
    }

    public String getIsFree() {
        if (StringUtils.isEmpty((Object)this.isFree)) {
            this.isFree = "\u5426";
        }
        return this.isFree;
    }

    public void setIsFree(String isFree) {
        this.isFree = isFree;
    }

    public String getBatchNum() {
        return this.batchNum;
    }

    public void setBatchNum(String batchNum) {
        this.batchNum = batchNum;
    }

    @Override
    public int compare(OrderProduct paramT1, OrderProduct paramT2) {
        int f = paramT1.getProductType().compareTo(paramT2.getProductType());
        if (f == 0) {
            return paramT1.getNo().compareTo(paramT2.getNo());
        }
        return f;
    }

    public OrderProduct clone() {
        OrderProduct o = null;
        try {
            o = (OrderProduct)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }
}

