/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.allot.QyAllotService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.SFAOrderApply;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.IntRebatemgService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.PartnerCreditService;
import com.tcbj.crm.order.SFAOrderApplyService;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sfaOrder"})
public class SFAOrderApplyController
extends BaseController {
    @Autowired
    SFAOrderApplyService sfaService;
    @Autowired
    protected QyAllotService qyAllService;
    @Autowired
    protected PartnerCreditService creditServcie;
    @Autowired
    protected GiftService giftService;
    @Autowired
    IntRebatemgService intrebatemgservice;
    @Autowired
    ScoreService scoreService;

    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u8ba2\u5355");
    }

    @RequestMapping(value={"/sfaOrderList.do"})
    public String sfaOrderList(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setSupplierId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        if (con.getState() == null) {
            con.setState("0");
        }
        Page page = this.sfaService.getSfaOrderApplys(con);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("page", (Object)page);
        return "order/sfaOrderList.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String sfaView(@RequestParam(value="id", required=false) String id, Model model) {
        SFAOrderApply sfaOrder = this.sfaService.getSfaOrderById(id);
        model.addAttribute("sfaOrder", (Object)sfaOrder);
        return "order/sfaView.ftl";
    }

    @RequestMapping(value={"/viewDetail.do"}, method={RequestMethod.GET})
    public String viewDetail(@Valid @RequestParam(value="id", required=false) String id, @RequestParam(value="submitType", required=false) String submitType, Model model) {
        SFAOrderApply sfaOrder = this.sfaService.getSfaOrderAndItemById(id);
        if ("approve".equals(submitType)) {
            model.addAttribute("approve", (Object)submitType);
        }
        model.addAttribute("sfaOrder", (Object)sfaOrder);
        model.addAttribute("sfaOrderItem", (Object)JSON.toJSONString(sfaOrder.getItems()));
        return "order/sfaView.ftl";
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve(@Valid @RequestParam(value="id", required=true) String id, @RequestParam(value="type", required=true) String type, Model model) {
        Employee emp = this.getCurrentEmployee();
        boolean result = this.sfaService.approveSfaOrder(id, type, emp);
        String rtns = "";
        rtns = result ? "\u5ba1\u6279\u6210\u529f" : "\u5ba1\u6279\u5931\u8d25";
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/print.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        SFAOrderApply sfaOrder = this.sfaService.getSfaOrderAndItemById(id);
        model.addAttribute("sfaOrder", (Object)sfaOrder);
        model.addAttribute("sfaOrderItem", sfaOrder.getItems());
        model.addAttribute("data", (Object)JSON.toJSONString(sfaOrder.getItems()));
        return "order/sfaPrint.ftl";
    }
}

