/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.SFAOrderApply;
import com.tcbj.crm.entity.SFAOrderApplyItem;
import com.tcbj.crm.fgift.FGiftFacadeService;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SFAOrderApplyService")
public class SFAOrderApplyService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    protected IntRebatemgFacadeService intRebatemgService;
    @Autowired
    protected GiftIntRebatemgService giftIntRebatemgService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    AplfineService aplfineService;
    @Autowired
    protected GiftService giftService;
    @Autowired
    protected FGiftFacadeService fGiftService;

    @PostConstruct
    public void init() {
    }

    public Page getSfaOrderApplys(OrderApplyCondition con) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select o from SFAOrderApply o where 1=1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and o.sfaOrderNum like ? ");
            params.add("%" + con.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getState())) {
            hql.append(" and o.orderStatus = ? ");
            params.add(con.getState());
        }
        Page page = this.baseDao.search(hql.toString(), params.toArray(), Constant.DEFAULT_ROWS, con.getPageno().intValue());
        return page;
    }

    public SFAOrderApply getSfaOrderAndItemById(String id) {
        SFAOrderApply order = this.getSfaOrderById(id);
        if (order == null) {
            return order;
        }
        List<SFAOrderApplyItem> items = this.getSfaOrderItemByOrderId(order.getSfaOrderId());
        order.setItems(items);
        return order;
    }

    public SFAOrderApply getSfaOrderById(String id) {
        return (SFAOrderApply)this.baseDao.get(SFAOrderApply.class, (Serializable)((Object)id));
    }

    public List<SFAOrderApplyItem> getSfaOrderItemByOrderId(String sfaId) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select oi from SFAOrderApplyItem oi where ");
        hql.append(" oi.sfaOrderId = ? ");
        List orderItem = this.baseDao.findEntity(hql.toString(), new Object[]{sfaId}, SFAOrderApplyItem.class);
        return orderItem;
    }

    public boolean approveSfaOrder(String id, String type, Employee emp) {
        SFAOrderApply sfaOrder = this.getSfaOrderById(id);
        if (sfaOrder != null) {
            if ("notpass".equals(type)) {
                sfaOrder.setOrderStatus("0");
            } else if ("pass".equals(type)) {
                sfaOrder.setOrderStatus("9");
            }
            sfaOrder.setOrderIfaceStatus("1");
            sfaOrder.setLastUpdateBy(emp.getName());
            sfaOrder.setLastUpdateDt(new Date());
            return true;
        }
        return false;
    }
}

