/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.orderinout;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.orderinout.Opt;
import com.tcbj.crm.orderinout.OrderInOutCondition;
import com.tcbj.crm.orderinout.OrderInOutService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.OrderInOutView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orderinout"})
public class OrderInOutController
extends BaseController {
    @Autowired
    OrderInOutService service;
    @Autowired
    StorageService storageService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    BaseDao baseDao;

    private void fillRepositoryName(OrderInOutView orderInOut) {
        Storage s;
        if (orderInOut.getOutDt() != null && (s = this.storageService.get(orderInOut.getOutRepository())) != null) {
            orderInOut.setOutRepositoryName(s.getStorageName());
        }
        if (orderInOut.getInDt() != null && (s = this.storageService.get(orderInOut.getInRepository())) != null) {
            orderInOut.setInRepositoryName(s.getStorageName());
        }
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="no", required=false) String no, Model model) {
        OrderInOutView orderInOut = this.loadOrderInOutNew(no, model);
        this.fillRepositoryName(orderInOut);
        return "orderinout/view.ftl";
    }

    @RequestMapping(value={"/sends.do"})
    public String sends(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        if (condition.getState() == null || condition.getState().equals("sending")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
        } else if (condition.getState().equals("sended")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
        } else {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        }
        if (!me.getCurrentPartner().getId().equals(me.getCurrentPartner().getOrganizationid())) {
            model.addAttribute("page", (Object)new Page(null, 0, 1, 0));
        } else {
            Page page = this.service.findOrderOutsNew(me, condition, pageno);
            model.addAttribute("page", (Object)page);
        }
        model.addAttribute("condition", (Object)condition);
        return "orderinout/sends.ftl";
    }

    private Storage getDefault(String partnerId) {
        List<Storage> storages = this.storageService.getList(partnerId);
        if (storages == null || storages.size() == 0) {
            return null;
        }
        return storages.get(0);
    }

    @RequestMapping(value={"/send.do"}, method={RequestMethod.GET})
    public String send(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        this.loadOrderInOut(id, model);
        Opt opt = new Opt();
        opt.setDt(DateUtils.now());
        opt.setId(id);
        opt.setOperatorName(me.getName());
        Storage s = this.getDefault(me.getCurrentPartner().getId());
        if (s != null) {
            opt.setRepositoryId(s.getId());
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("opt", (Object)opt);
        return "orderinout/send.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/send.do"}, method={RequestMethod.POST})
    public Result send_do(@Valid @RequestBody Opt opt, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        opt.setOperatorId(me.getId());
        opt.setOperateDt(DateUtils.now());
        this.service.send(me, opt);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/receives.do"})
    public String receives(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        if (condition.getState() == null || condition.getState().equals("sended")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
        } else if (condition.getState().equals("received")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        } else {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        }
        if (!me.getCurrentPartner().getId().equals(me.getCurrentPartner().getOrganizationid())) {
            Page page = this.service.findOrderOutsNew(me, condition, pageno);
            model.addAttribute("page", (Object)page);
        } else {
            model.addAttribute("page", (Object)new Page(null, 0, 1, 0));
        }
        model.addAttribute("condition", (Object)condition);
        return "orderinout/receives.ftl";
    }

    @RequestMapping(value={"/receive.do"}, method={RequestMethod.GET})
    public String receive(@RequestParam(value="no", required=false) String no, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderInOutView orderInOut = this.loadOrderInOutNew(no, model);
        this.fillRepositoryName(orderInOut);
        OrderApply orderApply = (OrderApply)this.baseDao.findFirstEntity(" from OrderApply where no = ? ", new Object[]{no}, OrderApply.class);
        Opt opt = new Opt();
        if (orderApply != null) {
            opt.setDt(DateUtils.now());
            opt.setId(orderApply.getId());
            opt.setOperatorName(me.getName());
            Storage s = this.getDefault(me.getCurrentPartner().getId());
            if (s != null) {
                opt.setRepositoryId(s.getId());
            }
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("opt", (Object)opt);
        return "orderinout/receive.ftl";
    }

    @ResponseBody
    @RequestMapping(value={"/receive.do"}, method={RequestMethod.POST})
    public Result receive_do(@Valid @RequestBody Opt opt, String no, BindingResult errors, HttpServletRequest request) {
        this.service.receiveNew(no);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/sendings.do"})
    public String sendings(@ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
        this.findOrderInOuts(condition, " order by approveDt", model);
        return "orderinout/sendings.ftl";
    }

    @RequestMapping(value={"/allsends.do"})
    public String allsends(@ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        if (condition.getState() != null && condition.getState().equals("sending")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
        } else if (condition.getState() != null && condition.getState().equals("sended")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
        } else {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        }
        this.findOrderInOuts(condition, " order by v.approveDt desc", model);
        return "orderinout/allsends.ftl";
    }

    @RequestMapping(value={"/allreceives.do"})
    public String allReceives(@ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        if (condition.getState() != null && condition.getState().equals("sended")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
        } else if (condition.getState() != null && condition.getState().equals("received")) {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        } else {
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sending.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
            condition.getStates().add(TCBJEnum.SendOrReceiveState.received.getValue());
        }
        this.findOrderInOuts(condition, " order by v.approveDt desc", model);
        return "orderinout/allreceives.ftl";
    }

    @RequestMapping(value={"/receivings.do"})
    public String receivings(@ModelAttribute(value="condition") OrderInOutCondition condition, Model model) {
        condition.getStates().add(TCBJEnum.SendOrReceiveState.sended.getValue());
        this.findOrderInOuts(condition, " createDt", model);
        return "orderinout/receivings.ftl";
    }

    private void findOrderInOuts(OrderInOutCondition condition, String orderby, Model model) {
        condition = (OrderInOutCondition)this.wrapCondition(condition, "OrderInOut");
        model.addAttribute("condition", (Object)condition);
    }

    private OrderInOutView loadOrderInOut(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderInOutView orderInOut = this.service.get(id);
        List<OrderInOutItem> items = this.service.getOrderInOutItems(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("orderInOut", (Object)orderInOut);
        model.addAttribute("orderInOutItemItems", (Object)JSON.toJSONString(items));
        return orderInOut;
    }

    private OrderInOutView loadOrderInOutNew(String no, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderInOutCondition condition = new OrderInOutCondition();
        condition.setNo(no);
        OrderInOutView orderInOut = this.service.findOrderById(condition);
        orderInOut.setSupplierId(me.getCurrentPartner().getId());
        condition.setEsbId(orderInOut.getId());
        List<OrderInOutItem> items = this.service.getOrderInOutItemsNew(condition, orderInOut);
        model.addAttribute("me", (Object)me);
        model.addAttribute("orderInOut", (Object)orderInOut);
        model.addAttribute("orderInOutItemItems", (Object)JSON.toJSONString(items));
        return orderInOut;
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET})
    public void exportExcel(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request, HttpServletResponse response) {
        OrderInOutView orderInOut = this.service.get(id);
        List<OrderInOutItem> items = this.service.getOrderInOutItems(id);
        this.fillRepositoryName(orderInOut);
        this.typeByNumber(items);
        OrderInOutItem orderInOutItem = new OrderInOutItem();
        Collections.sort(items, orderInOutItem);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ExcelUtil.exportExcel(response, orderInOut, items, String.valueOf(orderInOut.getNo()) + ".xls");
    }

    @RequestMapping(value={"/exportExcelNew.do"}, method={RequestMethod.GET})
    public void exportExcelNew(@RequestParam(value="no", required=false) String no, Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee me = this.getCurrentEmployee();
        OrderInOutCondition condition = new OrderInOutCondition();
        condition.setNo(no);
        OrderInOutView orderInOut = this.service.findOrderById(condition);
        orderInOut.setSupplierId(me.getCurrentPartner().getId());
        condition.setEsbId(orderInOut.getId());
        List<OrderInOutItem> items = this.service.getOrderInOutItemsNew(condition, orderInOut);
        this.fillRepositoryName(orderInOut);
        this.typeByNumber(items);
        OrderInOutItem orderInOutItem = new OrderInOutItem();
        Collections.sort(items, orderInOutItem);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ExcelUtil.exportExcel(response, orderInOut, items, String.valueOf(orderInOut.getNo()) + ".xls");
    }

    private void typeByNumber(List<OrderInOutItem> products) {
        for (OrderInOutItem orderProduct : products) {
            if ("PRODUCT".equals(orderProduct.getProductType())) {
                orderProduct.setProductType("1");
                continue;
            }
            if ("GIFT".equals(orderProduct.getProductType())) {
                orderProduct.setProductType("2");
                continue;
            }
            if ("MATERIAL".equals(orderProduct.getProductType())) {
                orderProduct.setProductType("3");
                continue;
            }
            orderProduct.setProductType("4");
        }
    }

    @RequestMapping(value={"/print.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        OrderInOutView orderInOut = this.service.get(id);
        List<OrderInOutItem> items = this.service.getOrderInOutItems(id);
        this.fillRepositoryName(orderInOut);
        this.typeByNumber(items);
        OrderInOutItem orderInOutItem = new OrderInOutItem();
        Collections.sort(items, orderInOutItem);
        model.addAttribute("orderApply", (Object)orderInOut);
        model.addAttribute("products", items);
        model.addAttribute("items", (Object)JSON.toJSONString(items));
        return "orderinout/print.ftl";
    }

    @RequestMapping(value={"/printNew.do"}, method={RequestMethod.GET})
    public String viewNew(@RequestParam(value="no", required=false) String no, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        OrderInOutCondition condition = new OrderInOutCondition();
        condition.setNo(no);
        OrderInOutView orderInOut = this.service.findOrderById(condition);
        orderInOut.setSupplierId(me.getCurrentPartner().getId());
        condition.setEsbId(orderInOut.getId());
        List<OrderInOutItem> items = this.service.getOrderInOutItemsNew(condition, orderInOut);
        this.fillRepositoryName(orderInOut);
        this.typeByNumber(items);
        OrderInOutItem orderInOutItem = new OrderInOutItem();
        Collections.sort(items, orderInOutItem);
        model.addAttribute("orderApply", (Object)orderInOut);
        model.addAttribute("products", items);
        model.addAttribute("items", (Object)JSON.toJSONString(items));
        return "orderinout/print.ftl";
    }

    @RequestMapping(value={"/orderLogiticList.do"})
    public String orderLogitic(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setApplyerId(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(con.getState())) {
            con.getOrderStates().add(con.getState());
        }
        this.findLogitics(con, model);
        model.addAttribute("_title", (Object)"\u6211\u7684\u8d27\u7269\u72b6\u6001");
        model.addAttribute("_url", (Object)"orderLogiticList.do");
        return "orderinout/logitics.ftl";
    }

    @RequestMapping(value={"/corderLogiticList.do"})
    public String corderLogitic(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setSupplierId(me.getCurrentPartner().getId());
        if (con.getState() == null || con.getState().equals("dealing")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
        } else if (con.getState().equals("dealed")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        } else if (con.getState().equals("cspapprove")) {
            con.getOrderStates().add(TCBJEnum.AuditState.cspapprove.getValue());
        } else if (con.getState().equals("cspapproveNoPass")) {
            con.getOrderStates().add(TCBJEnum.AuditState.cspapproveNoPass.getValue());
        } else {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.balancePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.sended.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.received.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.cspapprove.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.cspapproveNoPass.getValue());
        }
        con.setEmployeeId(me.getId());
        con.setRegionFilter(true);
        this.findLogitics(con, model);
        model.addAttribute("_title", (Object)"\u5ba2\u6237\u7684\u8d27\u7269\u72b6\u6001");
        model.addAttribute("_url", (Object)"corderLogiticList.do");
        return "orderinout/logitics.ftl";
    }

    @RequestMapping(value={"/viewLogitic.do"})
    public String viewLogitic(@RequestParam(value="id") String id, Model model) {
        Map<String, Object> map = this.orderApplyService.findLogiticsByOrderId(id);
        this.checkCurrentApplyer(map);
        model.addAttribute("logitic", map);
        return "orderinout/viewLogitic.ftl";
    }

    @RequestMapping(value={"/getLogitic.do"})
    @ResponseBody
    public Result getLogitic(@RequestParam(value="id") String id, Model model) {
        Map<String, Object> map = this.orderApplyService.findLogiticsByOrderId(id);
        this.checkCurrentApplyer(map);
        model.addAttribute("logitic", map);
        return this.getSuccessResult(map);
    }

    private void checkCurrentApplyer(Map<String, Object> map) {
        String applyerId = Beans.isEmpty((Object)map.get("applyerId")) ? "" : map.get("applyerId").toString();
        Employee me = this.getCurrentEmployee();
        if (me.getCurrentPartner().getId().equals(applyerId)) {
            map.remove("applyerId");
            map.remove("applyerName");
        }
    }

    protected void findLogitics(OrderApplyCondition con, Model model) {
        con = (OrderApplyCondition)this.wrapCondition(con, "applys");
        Employee me = this.getCurrentEmployee();
        Page logitics = this.orderApplyService.findOrderLogitics(con);
        model.addAttribute("me", (Object)me);
        model.addAttribute("logitics", (Object)logitics);
        model.addAttribute("condition", (Object)con);
    }
}

