/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.orderrtn;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyController;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rtnorderapply"})
public class RtnOrderApplyController
extends OrderApplyController {
    @Override
    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u9000\u8d27");
    }

    @Override
    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        List<OrderProduct> products = null;
        if (orderApply.isDraft()) {
            products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
            this.fillQuantityToProducts(orderApply, products);
            Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
            List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            this.calculateProductPrices(contract, products, details, customer.getPrecision());
            this.calculateOrderMoney(orderApply, products, customer.getPrecision());
            Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
            Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
            orderApply.setRetunsFullyMoney(contractFullyMoney);
            this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        } else {
            products = this.getProducts(orderApply);
        }
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        return "orderrtn/view.ftl";
    }

    @Override
    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        con.setNature(TCBJEnum.OrderNature.rtn.getValue());
        super.applys(con, model);
        return "orderrtn/applys.ftl";
    }

    @Override
    @RequestMapping(value={"/approves.do"})
    public String approves(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        con.setNature(TCBJEnum.OrderNature.rtn.getValue());
        super.approves(con, model);
        return "orderrtn/approves.ftl";
    }

    @Override
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        orderApply.setNature(TCBJEnum.OrderNature.rtn.getValue());
        orderApply.setApplyerId(me.getCurrentPartner().getId());
        this.assertOrderBelongMyPartner(orderApply, me);
        this.fillSupplierInOrderApply(orderApply, request);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (contract != null && StringUtils.isEmpty(orderApply.getContractNo())) {
            orderApply.setContractNo(contract.getPactNo());
        }
        List<PactMain> contracts = this.getPactMains(orderApply.getApplyerId(), orderApply.getSupplierId());
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        model.addAttribute("addresses", (Object)JSON.toJSONString(customer.getAddresses()));
        if (orderApply.isNew()) {
            orderApply.bindEditData(customer, me);
        }
        orderApply.bindCannotEditData(customer, me);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        this.fillQuantityToProducts(orderApply, products);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateRtnProductStocks(products, orderApply.getApplyerId(), null);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        List<AuditInfo> auditInfos = this.auditService.find(orderApply.getId());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("auditInfos", auditInfos);
        model.addAttribute("contracts", (Object)JSON.toJSONString(contracts));
        model.addAttribute("contractTotalMoney", (Object)contractTotalMoney);
        model.addAttribute("contractFullyMoney", (Object)contractFullyMoney);
        model.addAttribute("customer", (Object)customer);
        return "orderrtn/apply.ftl";
    }

    @RequestMapping(value={"/getContractMoney.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getContractMoney(String id, String applyerId, String supplierId, String contractNo, Model model) {
        Double contractTotalMoney = this.calculateContractOrdersMoney(applyerId, contractNo);
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(applyerId, contractNo, id);
        Double[] contractMoney = new Double[]{contractTotalMoney, contractFullyMoney};
        return this.getSuccessResult(contractMoney);
    }

    @Override
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request) {
        Partner supplier;
        orderApply.setNature(TCBJEnum.OrderNature.rtn.getValue());
        Employee me = this.getCurrentEmployee();
        orderApply.fillInitData(me);
        this.assertOrderBelongMyPartner(orderApply, me);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.bindCannotEditData(customer, me);
        if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
            orderApply.setSalesman(customer.getCityManagerId());
        }
        OrderApply oldOrderApply = null;
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
            this.assertOrderExist(oldOrderApply);
            this.assertOrderBelongMyPartner(oldOrderApply, me);
            if (!oldOrderApply.isDraft()) {
                orderApply.setState(oldOrderApply.getState());
                orderApply.setNo(oldOrderApply.getNo());
                orderApply.setDt(oldOrderApply.getDt());
            }
        }
        Partner applyer = this.assertOrderApplyerIsEffective(orderApply.getApplyerId());
        this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        if (oldOrderApply == null || !oldOrderApply.isApprovedNotPass()) {
            this.assertOrderProduct(orderApply, products);
        }
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertProductPrices(orderApply, contract, products, details, customer.getPrecision());
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        if (orderApply.isToApprove()) {
            if (StringUtils.isEmpty(orderApply.getNo())) {
                String type = orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue()) ? "01" : "02";
                orderApply.setNo(this.orderNoService.maxNo(applyer.getNo(), type));
                orderApply.setDt(DateUtils.now());
                orderApply.setContractNo(contract.getPactNo());
            }
            orderApply.setState(TCBJEnum.AuditState.approve.getValue());
        }
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.fillInitData(me);
        }
        boolean trigger = false;
        if (orderApply.isToApprove() && (supplier = this.partnerService.getSimplePartner(orderApply.getSupplierId())).isOrg()) {
            trigger = true;
        }
        this.service.saveOrUpdateOrderApply(orderApply, trigger);
        if (trigger) {
            this.service.triggerEAS(orderApply.getId());
        }
        if (orderApply.isToAudit() || orderApply.isToApprove()) {
            AuditInfo auditInfo = new AuditInfo(orderApply.getId(), "OrderApply", orderApply.getState(), orderApply.getRemark(), me.getId(), DateUtils.now());
            this.auditService.add(auditInfo);
        }
        return this.getSuccessResult(null);
    }

    @Override
    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        this.assertOrderBelongMySupplier(orderApply, me);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        int days = customer.getTransportOnlineCode() == null ? 3 : customer.getTransportOnlineCode().intValue();
        orderApply.setPredictArriveDt(DateUtils.getDateAfter((Date)orderApply.getDt(), (int)days));
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        this.fillQuantityToProducts(orderApply, products);
        PactMain priceContract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        PactMain contract = this.getPactMain(orderApply.getSupplierId(), orderApply.getContractNo());
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(priceContract, products, details, customer.getPrecision());
        this.calculateRtnProductStocks(products, orderApply.getApplyerId(), orderApply.getId());
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("contractTotalMoney", (Object)contractTotalMoney);
        model.addAttribute("contractFullyMoney", (Object)contractFullyMoney);
        model.addAttribute("customer", (Object)customer);
        return "orderrtn/approve.ftl";
    }

    @Override
    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(@Valid @RequestBody OrderApply order, BindingResult errors, HttpServletRequest request) {
        order.setNature(TCBJEnum.OrderNature.rtn.getValue());
        return super.approve_do(order, errors, request);
    }

    @Override
    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        super.del(id, model);
        return "redirect:applys.do?conscope=session";
    }
}

