/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pactMain;

import com.tcbj.crm.base.BaseService;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PactActivit;
import com.tcbj.crm.entity.PactChannel;
import com.tcbj.crm.entity.PactExpense;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.PactResourc;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.pactMain.PactMainCondition;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pactmainService")
public class PactMainService
extends BaseService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private PartnerShopService partnerShopService;
    @Autowired
    private ClientService clientService;

    public PactMain get(String id) {
        return (PactMain)this.baseDao.get(PactMain.class, (Serializable)((Object)id));
    }

    public void updateStatus(String id, String status, String userid) {
        PactMain p = (PactMain)this.baseDao.get(PactMain.class, (Serializable)((Object)id));
        p.setPactState(status);
        p.setLastUpdateDt(DateUtils.now());
        p.setLastUpdatorId(userid);
        this.baseDao.update((Object)p);
    }

    public void save(PactMain obj) {
        this.baseDao.save((Object)obj);
    }

    public void save(List<PactMain> obj) {
        this.baseDao.save(obj);
    }

    public Page getList(int pageno, PactMainCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        hql.append(" from PactMain o,Customer c where 1=1 ");
        hql.append(" and o.applyerId = c.applyerId and o.supplierId = ? ");
        args.add(condition.getFirstParty());
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotEmpty(condition.getPactName())) {
            hql.append(" and o.pactName like ? ");
            args.add("%" + condition.getPactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPactNo())) {
            hql.append(" and o.pactNo like ? ");
            args.add("%" + condition.getPactNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotNull(condition.getSignDate())) {
            hql.append(" and o.signDate >= ? ");
            args.add(condition.getSignDate());
        }
        if (StringUtils.isNotNull(condition.getSignEndDateHQL())) {
            hql.append(" and o.signDate <= ? ");
            args.add(condition.getSignEndDateHQL());
        }
        if (StringUtils.isNotNull(condition.getStartDate())) {
            hql.append(" and o.startDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (StringUtils.isNotNull(condition.getEndDateHQL())) {
            hql.append(" and o.startDate <= ? ");
            args.add(condition.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(condition.getPactState())) {
            hql.append(" and o.pactState = ? ");
            args.add(condition.getPactState());
        }
        hql.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<PactMain> list = new ArrayList<PactMain>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((PactMain)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public void update(PactMain obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(PactMain.class, (Serializable)((Object)id));
    }

    public boolean getPactNo(String pactNo, String partnerId, String id) {
        PactMain pactMain;
        StringBuffer hql = new StringBuffer();
        hql.append(" from PactMain o where supplierId = ? and pactNo = ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(partnerId);
        args.add(pactNo);
        if (StringUtils.isNotEmpty(id)) {
            hql.append(" and id != ?");
            args.add(id);
        }
        return StringUtils.isNull(pactMain = (PactMain)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PactMain.class));
    }

    public boolean validataDateS(Date startDate, Date endDate, String applyerId, String partnerId, String id) {
        PactMain pactMain;
        StringBuffer hql = new StringBuffer();
        hql.append(" from PactMain o where supplierId = ? and applyerId = ? and ((startDate < ? and endDate > ?) or (startDate < ? and endDate > ?) or (startDate > ? and startDate < ?) or (endDate > ? and endDate < ?) ) ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(partnerId);
        args.add(applyerId);
        args.add(startDate);
        args.add(startDate);
        args.add(endDate);
        args.add(endDate);
        args.add(startDate);
        args.add(startDate);
        args.add(startDate);
        args.add(endDate);
        if (StringUtils.isNotEmpty(id)) {
            hql.append(" and id != ?");
            args.add(id);
        }
        return StringUtils.isNull(pactMain = (PactMain)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PactMain.class));
    }

    public PactMain getPactMain(String applyerId, String supplierId, Date findDate) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from PactMain o where pactState = '1' ");
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" and supplierId = ? and applyerId = ? ");
        args.add(supplierId);
        args.add(applyerId);
        hql.append(" and ((startDate <= ? and endDate >= ? )");
        args.add(findDate);
        args.add(findDate);
        hql.append(" or endDate <= ?) ");
        args.add(findDate);
        hql.append(" order by endDate desc ");
        PactMain pactMain = (PactMain)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PactMain.class);
        return pactMain;
    }

    public PactMain getPactMain(String supplierId, String contractNo) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from PactMain where ");
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" supplierId = ?  ");
        args.add(supplierId);
        hql.append(" and pactNo=? ");
        args.add(contractNo);
        hql.append(" order by endDate desc ");
        PactMain pactMain = (PactMain)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), PactMain.class);
        return pactMain;
    }

    public List<PactMain> getPactMainList(String applyerId, String supplierId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from PactMain o where pactState = '1' ");
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" and supplierId = ? and applyerId = ? ");
        args.add(supplierId);
        args.add(applyerId);
        hql.append(" order by createDt desc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PactMain.class);
    }

    public void updatePactMbo(PactMain obj) {
        String hql = "delete PactMbo where pactMainId = ? ";
        this.baseDao.executeHQL(hql, new Object[]{obj.getId()});
        List<PactMbo> pactMbos = obj.getPactMbo();
        for (PactMbo pactMbo : pactMbos) {
            pactMbo.setPactMainId(obj.getId());
            pactMbo.fillInitData(this.getCurrentEmployee());
        }
        this.baseDao.save(pactMbos);
    }

    public List<PactResourc> getPactResourc(String pactId) {
        return this.baseDao.findEntity("from PactResourc a where a.pactId='" + pactId + "'", PactResourc.class);
    }

    public List<PactMbo> getPactMbo(String id) {
        return this.baseDao.findEntity("from PactMbo a where a.pactMainId='" + id + "'", PactMbo.class);
    }

    public void updatePactResourc(PactMain obj) {
        String hql = "delete PactResourc where pactId = ? ";
        this.baseDao.executeHQL(hql, new Object[]{obj.getId()});
        List<PactResourc> pactMbos = obj.getPactResourc();
        for (PactResourc pactMbo : pactMbos) {
            pactMbo.setPactId(obj.getId());
            pactMbo.fillInitData(this.getCurrentEmployee());
        }
        this.baseDao.save(pactMbos);
    }

    public void updatePactChannel(PactMain obj) {
        String hql = "delete PactChannel where pactId = ? ";
        this.baseDao.executeHQL(hql, new Object[]{obj.getId()});
        List<PactChannel> pactMbos = obj.getPactChannel();
        for (PactChannel pactMbo : pactMbos) {
            pactMbo.setPactId(obj.getId());
            pactMbo.fillInitData(this.getCurrentEmployee());
        }
        this.baseDao.save(pactMbos);
    }

    public List<PactChannel> getPactChannel(String id) {
        return this.baseDao.findEntity("from PactChannel a where a.pactId='" + id + "'", PactChannel.class);
    }

    public List<PactActivit> getPactActivit(String id) {
        return this.baseDao.findEntity("from PactActivit a where a.pactId='" + id + "'", PactActivit.class);
    }

    public void updatePactActivit(PactMain obj) {
        String hql = "delete PactActivit where pactId = ? ";
        this.baseDao.executeHQL(hql, new Object[]{obj.getId()});
        List<PactActivit> pactMbos = obj.getPactActivit();
        for (PactActivit pactMbo : pactMbos) {
            pactMbo.setPactId(obj.getId());
            pactMbo.fillInitData(this.getCurrentEmployee());
        }
        this.baseDao.save(pactMbos);
    }

    public List<PactExpense> getPactExpense(String id) {
        return this.baseDao.findEntity("from PactExpense a where a.pactId='" + id + "'", PactExpense.class);
    }

    public void updatePactExpense(PactMain obj) {
        String hql = "delete PactExpense where pactId = ? ";
        this.baseDao.executeHQL(hql, new Object[]{obj.getId()});
        List<PactExpense> pactMbos = obj.getPactExpense();
        for (PactExpense pactMbo : pactMbos) {
            pactMbo.setPactId(obj.getId());
            pactMbo.fillInitData(this.getCurrentEmployee());
            pactMbo.setEmployMoney(pactMbo.getEmployMoney() == null ? 0.0 : pactMbo.getEmployMoney());
            pactMbo.setOccupyMoney(pactMbo.getOccupyMoney() == null ? 0.0 : pactMbo.getOccupyMoney());
        }
        this.baseDao.save(pactMbos);
    }

    public void validataPactNo(String pactNo, String partnerId, String id) {
        boolean isPactNo = this.getPactNo(pactNo, partnerId, id);
        if (!isPactNo) {
            throw new AppException("1101");
        }
    }

    public void validataDate(Date startDate, Date endDate, String applyerId, String partnerId, String id) {
        boolean isPactNo = this.validataDateS(startDate, endDate, applyerId, partnerId, id);
        if (!isPactNo) {
            throw new AppException("1102");
        }
    }

    public List<PactMbo> getPactMbos(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select p from PactMbo p,PactMain t where p.pactMainId = t.id and p.year = ? and t.supplierId = ? and t.applyerId = ? and p.targetType = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(Long.valueOf(condition.getYear()));
        args.add(emp.getCurrentPartner().getParPartnerId() == null ? emp.getCurrentPartner().getId() : emp.getCurrentPartner().getParPartnerId());
        args.add(emp.getCurrentPartner().getId());
        args.add(condition.getTargetType());
        hql.append(" and nvl(t.startDate,?) <= ? and nvl(t.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), pageNo, rowsize, PactMbo.class);
    }

    public List<PactMain> getPactMainListBySerch(PactMainCondition condition, Employee emp) {
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select o from PactMain o,Customer c where 1=1 ");
        hql.append(" and o.applyerId = c.applyerId and o.supplierId = ? ");
        args.add(condition.getFirstParty());
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotEmpty(condition.getPactName())) {
            hql.append(" and o.pactName like ? ");
            args.add("%" + condition.getPactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPactNo())) {
            hql.append(" and o.pactNo like ? ");
            args.add("%" + condition.getPactNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotNull(condition.getSignDate())) {
            hql.append(" and o.signDate >= ? ");
            args.add(condition.getSignDate());
        }
        if (StringUtils.isNotNull(condition.getSignEndDateHQL())) {
            hql.append(" and o.signDate <= ? ");
            args.add(condition.getSignEndDateHQL());
        }
        if (StringUtils.isNotNull(condition.getStartDate())) {
            hql.append(" and o.startDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (StringUtils.isNotNull(condition.getEndDateHQL())) {
            hql.append(" and o.startDate <= ? ");
            args.add(condition.getEndDateHQL());
        }
        if (StringUtils.isNotEmpty(condition.getPactState())) {
            hql.append(" and o.pactState = ? ");
            args.add(condition.getPactState());
        }
        hql.append(" order by o.createDt desc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PactMain.class);
    }

    public boolean excels(List<PactMain> list, String path, Employee emp, HttpServletResponse response) {
        String name = String.valueOf(emp.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls";
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u5408\u540c\u7f16\u53f7", "\u5408\u540c\u540d\u79f0", "\u7532\u65b9\u540d\u79f0", "\u4e59\u65b9\u52a9\u8bb0\u7801", "\u5408\u4f5c\u6a21\u5f0f", "\u7b7e\u7f72\u65e5\u671f", "\u54c1\u724c\u53d1\u5c55\u57fa\u91d1\u989d\u5ea6\u6bd4\u4f8b(%)", "\u63a8\u5e7f\u57fa\u91d1\u989d\u5ea6\u6bd4\u4f8b(%)", "\u94f6\u884c\u540d\u79f0", "\u8d26\u53f7", "\u9500\u552e\u76ee\u6807(\u4e07\u5143)", "\u7ed3\u7b97\u6298\u6263\u7387(%)", "\u9500\u552e\u533a\u57df\u8303\u56f4", "\u9500\u552e\u6e20\u9053", "\u5408\u540c\u751f\u6548\u5f00\u59cb\u65e5\u671f", "\u5408\u540c\u751f\u6548\u7ed3\u675f\u65e5\u671f", "\u9000\u6362\u8d27\u514d\u8d39\u989d\u5ea6\u6bd4\u4f8b(%)", "\u8d85\u51fa\u90e8\u5206\u91d1\u989d\u6bd4\u4f8b(%)", "\u4fe1\u7528\u989d\u5ea6(\u4e07\u5143)", "\u53ef\u8d2d\u4ea7\u54c1\u4e0e\u8d60\u54c1\u6bd4\u4f8b\u7c7b\u578b", "\u53ef\u8d2d\u4ea7\u54c1\u4e0e\u8d60\u54c1\u6bd4\u4f8b(%)", "\u514d\u8d39\u4ea7\u54c1\u4e0e\u8d60\u54c1\u6bd4\u4f8b\u7c7b\u578b", "\u514d\u8d39\u4ea7\u54c1\u4e0e\u8d60\u54c1\u6bd4\u4f8b(%)", "\u8fdd\u7ea6\u91d1\u7b2c\u4e00\u6b21(\u5143)", "\u8fdd\u7ea6\u91d1\u7b2c\u4e8c\u6b21(\u5143)", "\u8fdd\u7ea6\u91d1\u7b2c\u4e09\u6b21(\u5143)", "\u8fdd\u7ea6\u91d1\u7b2c\u56db\u6b21(\u5143)", "\u9500\u552e\u652f\u6301", "\u5ba2\u6237\u7c7b\u578b", "\u9500\u552e\u6e20\u9053", "\u9500\u552e\u533a\u57df\u7701", "\u9500\u552e\u533a\u57df\u5e02", "\u9500\u552e\u533a\u57df\u53bf\u533a", "\u5927\u533a", "\u5927\u533a\u7ecf\u7406", "\u533a\u57df", "\u533a\u57df\u7ecf\u7406", "\u64cd\u4f5c\u4eba", "\u76ee\u6807\u7c7b\u578b", "\u76ee\u6807", "\u5355\u4f4d", "\u5e74", "\u5408\u8ba1", "1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            PactMain stu = list.get(i2);
            PartnerShop partnerShop = this.partnerShopService.get(stu.getApplyerId());
            Customer customer = this.clientService.getCustomerAlone(emp.getCurrentPartner().getId(), stu.getApplyerId());
            List<PactMbo> pactMboList = this.getPactMbo(stu.getId());
            if (pactMboList.size() == 0) {
                row = sheet.createRow(++j);
                this.setRow(partnerShop, customer, stu, (Row)row, new PactMbo());
            } else {
                for (PactMbo pactMbo : pactMboList) {
                    row = sheet.createRow(++j);
                    this.setRow(partnerShop, customer, stu, (Row)row, pactMbo);
                }
            }
            ++i2;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String strEmp(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public Double douEmp(Double dou) {
        if (dou == null) {
            return 0.0;
        }
        return dou;
    }

    public void setRow(PartnerShop partnerShop, Customer customer, PactMain stu, Row row, PactMbo pactMbo) {
        row.createCell(0).setCellValue(this.strEmp(stu.getPactNo()));
        row.createCell(1).setCellValue(this.strEmp(stu.getPactName()));
        row.createCell(2).setCellValue(this.strEmp(stu.getSupplierName()));
        row.createCell(3).setCellValue(this.strEmp(customer.getApplyerCode()));
        row.createCell(4).setCellValue(this.strEmp(customer.getApplyerName()));
        row.createCell(5).setCellValue(this.strEmp(stu.getCopModel()));
        row.createCell(6).setCellValue(stu.getSignDate());
        row.createCell(7).setCellValue(this.douEmp(stu.getBrandDevRate()).doubleValue());
        row.createCell(8).setCellValue(this.douEmp(stu.getFoundationRate()).doubleValue());
        row.createCell(9).setCellValue(this.strEmp(stu.getBankName()));
        row.createCell(10).setCellValue(this.strEmp(stu.getAccount()));
        row.createCell(11).setCellValue(this.douEmp(stu.getSalesTarget()).doubleValue());
        row.createCell(12).setCellValue(this.douEmp(stu.getSettleRate()).doubleValue());
        row.createCell(13).setCellValue(this.strEmp(stu.getSalesArea()));
        row.createCell(14).setCellValue(this.strEmp(stu.getSalesChannel()));
        row.createCell(15).setCellValue(stu.getStartDate());
        row.createCell(16).setCellValue(stu.getEndDate());
        row.createCell(17).setCellValue(this.douEmp(stu.getReturnsFreeQuota()).doubleValue());
        row.createCell(18).setCellValue(this.douEmp(stu.getOvertopMoneyQuota()).doubleValue());
        row.createCell(19).setCellValue(this.douEmp(stu.getCreditQuota()).doubleValue());
        row.createCell(20).setCellValue(this.strEmp(stu.getScaleType()));
        row.createCell(21).setCellValue(this.douEmp(stu.getScale()).doubleValue());
        row.createCell(22).setCellValue(this.strEmp(stu.getFreeScaleType()));
        row.createCell(23).setCellValue(this.douEmp(stu.getFreeScale()).doubleValue());
        row.createCell(24).setCellValue(this.douEmp(stu.getPenaltyMoney1()).doubleValue());
        row.createCell(25).setCellValue(this.douEmp(stu.getPenaltyMoney2()).doubleValue());
        row.createCell(26).setCellValue(this.douEmp(stu.getPenaltyMoney3()).doubleValue());
        row.createCell(27).setCellValue(this.douEmp(stu.getPenaltyMoney4()).doubleValue());
        row.createCell(28).setCellValue(this.strEmp(stu.getSalesSupport()));
        row.createCell(29).setCellValue(this.strEmp(stu.getCusType()));
        row.createCell(30).setCellValue(partnerShop == null ? "" : partnerShop.getSaleChannelTypeName());
        row.createCell(31).setCellValue(partnerShop == null ? "" : partnerShop.getProvinceName());
        row.createCell(32).setCellValue(partnerShop == null ? "" : partnerShop.getCityName());
        row.createCell(33).setCellValue(partnerShop == null ? "" : partnerShop.getCountyName());
        row.createCell(34).setCellValue(this.strEmp(customer.getBigAreaName()));
        row.createCell(35).setCellValue(this.strEmp(customer.getBigAreaManagerName()));
        row.createCell(36).setCellValue(this.strEmp(customer.getAreaName()));
        row.createCell(37).setCellValue(this.strEmp(customer.getAreaManagerName()));
        row.createCell(38).setCellValue(this.strEmp(pactMbo.getTargetTypeName()));
        row.createCell(39).setCellValue(this.strEmp(pactMbo.getTargetName()));
        row.createCell(40).setCellValue(this.strEmp(pactMbo.getUnit()));
        row.createCell(41).setCellValue((double)(pactMbo.getYear() == null ? 0L : pactMbo.getYear()));
        row.createCell(42).setCellValue(this.douEmp(pactMbo.getSum()).doubleValue());
        row.createCell(43).setCellValue(this.douEmp(pactMbo.getMonth1()).doubleValue());
        row.createCell(44).setCellValue(this.douEmp(pactMbo.getMonth2()).doubleValue());
        row.createCell(45).setCellValue(this.douEmp(pactMbo.getMonth3()).doubleValue());
        row.createCell(46).setCellValue(this.douEmp(pactMbo.getMonth4()).doubleValue());
        row.createCell(47).setCellValue(this.douEmp(pactMbo.getMonth5()).doubleValue());
        row.createCell(48).setCellValue(this.douEmp(pactMbo.getMonth6()).doubleValue());
        row.createCell(49).setCellValue(this.douEmp(pactMbo.getMonth7()).doubleValue());
        row.createCell(50).setCellValue(this.douEmp(pactMbo.getMonth8()).doubleValue());
        row.createCell(51).setCellValue(this.douEmp(pactMbo.getMonth9()).doubleValue());
        row.createCell(52).setCellValue(this.douEmp(pactMbo.getMonth10()).doubleValue());
        row.createCell(53).setCellValue(this.douEmp(pactMbo.getMonth11()).doubleValue());
        row.createCell(54).setCellValue(this.douEmp(pactMbo.getMonth12()).doubleValue());
    }
}

