/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.position;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.position.PositionCondition;
import com.tcbj.crm.position.PositionService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/position"})
public class PositionController
extends BaseController {
    @Autowired
    PositionService positionService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    Cache cache;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(@RequestParam(value="orgId", required=false) String orgId, Model model, HttpServletRequest request) {
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("date", (Object)DateUtils.now());
        return "position/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody Position position, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        this.validateName(position.getPostName(), e.getCurrentPartner().getId(), null);
        position.setOrgId(e.getCurrentPartner().getId());
        position.fillInitData(e);
        Position ps = this.positionService.get(position.getTreeId());
        if (ps == null) {
            position.setChannelId(position.getTreeId());
        } else {
            position.setChannelId(ps.getChannelId());
        }
        position.setParentId(position.getTreeId());
        this.positionService.save(position);
        this.cache.initPositions();
        return this.getSuccessResult(position.getTreeId());
    }

    public void validateName(String name, String treeId, String id) throws Exception {
        boolean isExist = this.positionService.isName(name, treeId, id);
        if (isExist) {
            throw new AppException("3101");
        }
    }

    @RequestMapping(value={"/list.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="orgId", required=false) String orgId, PositionCondition condition, String refresh, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("page", (Object)this.positionService.getList(pageno, condition, e.getCurrentPartner().getId(), orgId));
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("refresh", (Object)refresh);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "position/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model, @RequestParam(value="orgId", required=false) String orgId, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Position position = this.positionService.get(id);
        model.addAttribute("master", (Object)position);
        model.addAttribute("orgId", (Object)orgId);
        return "position/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody Position position, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        Position cm = this.positionService.get(position.getId());
        this.validateName(position.getPostName(), e.getCurrentPartner().getId(), position.getId());
        position.fillInitData(e);
        position.setOrgId(e.getCurrentPartner().getId());
        position.setChannelId(cm.getChannelId());
        position.setParentId(cm.getParentId());
        this.positionService.update(position);
        return this.getSuccessResult(position.getTreeId());
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, @RequestParam(value="orgId", required=false) String orgId, Model model, HttpServletRequest request) throws Exception {
        Position cm = this.positionService.get(id);
        cm.setEndDate(DateUtils.now());
        this.positionService.update(cm);
        return "redirect:/position/list.do?refresh=1&orgId=" + orgId;
    }

    @RequestMapping(value={"/orgTree.do"})
    public String tree(String orgId, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner p = this.personnelservice.getById(e.getCurrentPartner().getId());
        String tree = this.positionService.getOrgTree(orgId, p);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        return "/position/orgTree.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, @RequestParam(value="orgId", required=false) String orgId, Model model) throws Exception {
        Position cm = this.positionService.get(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("cm", (Object)cm);
        return "/position/view.ftl";
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.positionService.getChildNodeTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, String orgId, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            String result = this.positionService.getChildTree(id, orgId);
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"posTree.do"})
    public String artree(Model model, String orgId, String partnerId) throws Exception {
        Partner p = null;
        Employee e = this.getCurrentEmployee();
        p = partnerId.equals("") ? this.personnelservice.getById(e.getCurrentPartner().getId()) : this.personnelservice.getById(orgId);
        String tree = this.positionService.posTree(p);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        return "/post/posTree.ftl";
    }
}

