/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.priceAdjust;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.entity.PriceAdjust;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.priceAdjust.PrAdjdetailCondition;
import com.tcbj.crm.priceAdjust.PriceAdjustCondition;
import com.tcbj.crm.priceAdjust.PriceAdjustService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/priceAdjust"})
public class PriceAdjustController
extends BaseController {
    @Autowired
    PriceAdjustService priceadjustservice;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, HttpServletRequest request) {
        PriceAdjust priceAdjust = new PriceAdjust();
        model.addAttribute("detail", (Object)JSON.toJSONString(priceAdjust.getPrAdjdetailList()));
        model.addAttribute("master", (Object)priceAdjust);
        model.addAttribute("date", (Object)DateUtils.now());
        return "priceAdjust/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String add_post(@ModelAttribute(value="priceadjust") PriceAdjust priceadjust, BindingResult errors, HttpServletResponse response, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        ArrayList<PrAdjdetail> list = new ArrayList<PrAdjdetail>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(list, request, response);
        String rtn = null;
        boolean isName = this.priceadjustservice.validateName(priceadjust.getAdjustmentName(), null, e.getCurrentPartner().getId());
        if (isName) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(priceadjust.getAdjustmentName()) + " \u8be5\u8c03\u6574\u91cf\u540d\u79f0\u5728\u672c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult("\u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\uff01"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        priceadjust.fillInitData(e);
        priceadjust.setSupplierId(e.getCurrentPartner().getId());
        for (PrAdjdetail prAdjdetail : list) {
            prAdjdetail.fillInitData(e);
        }
        priceadjust.setPrAdjdetailList(list);
        this.priceadjustservice.save(priceadjust);
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    public void validateApplyer(String applyerId, String productId, Date startDate) {
        boolean isExist = this.priceadjustservice.isApplyer(applyerId, productId, startDate);
        if (isExist) {
            throw new AppException("9101");
        }
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee em = this.getCurrentEmployee();
        PriceAdjust priceadjust = this.priceadjustservice.get(id, em);
        model.addAttribute("master", (Object)priceadjust);
        return "priceAdjust/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody PriceAdjust priceadjust, BindingResult errors, Model model, HttpServletRequest request) {
        if (errors.hasErrors()) {
            model.addAttribute("errors", (Object)errors.getFieldErrors());
            StringBuffer err = new StringBuffer();
            for (FieldError msg : errors.getFieldErrors()) {
                err.append(msg.getDefaultMessage());
            }
            return this.getErrorResult(err.toString());
        }
        Employee e = this.getCurrentEmployee();
        boolean isName = this.priceadjustservice.validateName(priceadjust.getAdjustmentName(), priceadjust.getId(), e.getCurrentPartner().getId());
        if (isName) {
            throw new AppException("3105");
        }
        if (StringUtils.isNotEmpty(priceadjust.getDelIds())) {
            String[] stringArray = priceadjust.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.priceadjustservice.deletePA(id);
                ++n2;
            }
        }
        priceadjust.fillInitData(e);
        priceadjust.setSupplierId(e.getCurrentPartner().getId());
        this.priceadjustservice.update(priceadjust, e);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PriceAdjustCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setSupplierId(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        condition.setEm(this.getCurrentEmployee());
        model.addAttribute("page", (Object)this.priceadjustservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "priceAdjust/list.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request) {
        this.priceadjustservice.delete(id);
        return "redirect:/priceAdjust/list.do";
    }

    public List<AdjustStockUtil> getFileReadyExcel(List<PrAdjdetail> list, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<IUploadFile> filelist = this.uploadFile(request, "adjuststock");
        List<List<Object>> readExcelList = new LinkedList<List<Object>>();
        String fileUrl = "";
        if (filelist.size() > 0) {
            fileUrl = filelist.get(0).getRealPath();
            readExcelList = ExcelHandle.readExcel(fileUrl);
        }
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        this.validateExcel(readExcelList, list, msglist);
        return msglist;
    }

    public void validateExcel(List<List<Object>> readExcelList, List<PrAdjdetail> list, List<AdjustStockUtil> msglist) throws Exception {
        String supplierId = this.getCurrentEmployee().getCurrentPartner().getId();
        int j = 1;
        for (List<Object> objectslist : readExcelList) {
            String message = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            boolean is = false;
            if ("".equals(objectslist.get(0).toString()) || objectslist.get(0).toString() == null) {
                message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(1).toString()) || objectslist.get(1).toString() == null) {
                message = String.valueOf(message) + "\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if ("".equals(objectslist.get(8).toString()) || objectslist.get(8).toString() == null) {
                message = String.valueOf(message) + "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a;";
                is = true;
            }
            if (!is) continue;
            AdjustStockUtil asu = new AdjustStockUtil();
            asu.setMessage(message);
            msglist.add(asu);
        }
        if (msglist.size() > 0) {
            return;
        }
        j = 1;
        for (List<Object> objectslist : readExcelList) {
            Customer customer;
            PrAdjdetail adju = new PrAdjdetail();
            String message = "\u5728\u7b2c" + ++j + "\u884c\uff0c";
            boolean is = false;
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy");
            if (StringUtils.isNotEmpty(objectslist.get(2).toString())) {
                adju.setNumberFrom(Long.valueOf(objectslist.get(2).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(3).toString())) {
                adju.setNumberTo(Long.valueOf(objectslist.get(3).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(4).toString())) {
                adju.setPrice(Double.valueOf(objectslist.get(4).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(5).toString())) {
                adju.setDisCount(Double.valueOf(objectslist.get(5).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(6).toString())) {
                adju.setMarkUp(Double.valueOf(objectslist.get(6).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(7).toString())) {
                adju.setRemark(objectslist.get(7).toString());
            }
            if (StringUtils.isNotEmpty(objectslist.get(8).toString())) {
                adju.setStartDate(sdf.parse(objectslist.get(8).toString()));
            }
            if (StringUtils.isNotEmpty(objectslist.get(9).toString())) {
                adju.setEndDate(sdf.parse(objectslist.get(9).toString()));
            }
            if ((customer = this.clientService.getCodeAndSupplier(objectslist.get(0).toString(), supplierId)) == null) {
                message = String.valueOf(message) + "\u5ba2\u6237\u7f16\u53f7\u4e0d\u5c5e\u4e8e\u672c\u7ec4\u7ec7;";
                is = true;
            } else {
                adju.setApplyerId(customer.getApplyerId());
            }
            if (customer != null) {
                Product product = this.productService.getCodeAndProduct(objectslist.get(1).toString(), customer.getApplyerId());
                if (product != null) {
                    adju.setProductId(product.getId());
                } else {
                    message = String.valueOf(message) + "\u8be5\u4ea7\u54c1\u7f16\u53f7\u4e0d\u5c5e\u4e8e" + objectslist.get(0).toString() + "\u7f16\u53f7\u7684\u5ba2\u6237;";
                    is = true;
                }
            }
            if (is) {
                AdjustStockUtil asu = new AdjustStockUtil();
                asu.setMessage(message);
                msglist.add(asu);
            }
            list.add(adju);
        }
        if (msglist.size() > 0) {
            return;
        }
    }

    public void checkShopNumber(List<AdjustStockUtil> msglist, Object ages, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        if ("".equals(ages) || ages == null) {
            util.setMessage(str);
            msglist.add(util);
        }
    }

    public void setMessage(List<AdjustStockUtil> msglist, String str) {
        AdjustStockUtil util = new AdjustStockUtil();
        util.setMessage(str);
        msglist.add(util);
    }

    public void packageMap(Map<String, List<PrAdjdetail>> map, List<PrAdjdetail> allotRows) {
        for (PrAdjdetail prAdjdetail : allotRows) {
            List<PrAdjdetail> nslist = map.get(prAdjdetail.getApplyerId());
            if (nslist == null) {
                nslist = new ArrayList<PrAdjdetail>();
                map.put(prAdjdetail.getApplyerId(), nslist);
            }
            nslist.add(prAdjdetail);
        }
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET})
    public String del(String id, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        PriceAdjust pa = this.priceadjustservice.get(id, e);
        this.priceadjustservice.delete(pa);
        return "redirect:/priceAdjust/list.do";
    }

    @RequestMapping(value={"/getPrAdjdetails.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getPrAdjdetails(PrAdjdetailCondition con, Model model) {
        con.setEm(this.getCurrentEmployee());
        Page page = this.priceadjustservice.getPrAdjdetails(con);
        return page;
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.GET})
    public String save_get(Model model, HttpServletRequest request) {
        PriceAdjust priceAdjust = new PriceAdjust();
        model.addAttribute("detail", (Object)JSON.toJSONString(priceAdjust.getPrAdjdetailList()));
        model.addAttribute("master", (Object)priceAdjust);
        model.addAttribute("date", (Object)DateUtils.now());
        return "priceAdjust/save.ftl";
    }

    @RequestMapping(value={"/save.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save_post(@Valid @RequestBody PriceAdjust priceadjust, BindingResult errors, HttpServletResponse response, Model model, HttpServletRequest request) throws Exception {
        if (errors.hasErrors()) {
            model.addAttribute("errors", (Object)errors.getFieldErrors());
            StringBuffer err = new StringBuffer();
            for (FieldError msg : errors.getFieldErrors()) {
                err.append(msg.getDefaultMessage());
            }
            return this.getErrorResult(err.toString());
        }
        Employee e = this.getCurrentEmployee();
        boolean isName = this.priceadjustservice.validateName(priceadjust.getAdjustmentName(), null, e.getCurrentPartner().getId());
        if (isName) {
            throw new AppException("3105");
        }
        List<PrAdjdetail> list = priceadjust.getPrAdjdetailList();
        priceadjust.fillInitData(e);
        priceadjust.setSupplierId(e.getCurrentPartner().getId());
        for (PrAdjdetail prAdjdetail : list) {
            prAdjdetail.fillInitData(e);
        }
        this.priceadjustservice.save(priceadjust);
        return this.getSuccessResult(null);
    }
}

