/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.product;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/product"})
public class ProductController
extends BaseController {
    @Autowired
    ProductService service;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelService;

    @RequestMapping(value={"/findProduct.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ProductCondition con, String no, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        if (me.getCurrentPartner().getParPartnerId() == null) {
            Page product = this.service.findPartners(con, no, pageno);
            model.addAttribute("page", (Object)product);
        } else {
            Contact contact = this.personnelService.get(me.getId());
            Page product = this.service.getProductStock(me.getCurrentPartner().getId(), con.getNo(), con.getProdname(), con, pageno, contact);
            model.addAttribute("partners", (Object)product);
        }
        model.addAttribute("no", (Object)no);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "/product/finds.ftl";
    }

    @RequestMapping(value={"/findApplyer.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findApplyer(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ClientCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        Page custmers = this.clientService.findPartnerApplysValid(con, pageno);
        model.addAttribute("partners", (Object)custmers);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "/product/findsApplyer.ftl";
    }

    @RequestMapping(value={"/findMyProduct.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findMyProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ProductCondition con, String no, String prodname, Model model) {
        Employee me = this.getCurrentEmployee();
        Page product = this.service.getMyProducts(me.getCurrentPartner().getId(), no, prodname, con, pageno);
        model.addAttribute("partners", (Object)product);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("no", (Object)no);
        model.addAttribute("prodname", (Object)prodname);
        return "/product/myfinds.ftl";
    }

    @RequestMapping(value={"/findMyProductStock.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findMyProductStock(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, String no, String prodname, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        Contact contact = this.personnelService.get(me.getId());
        Page product = this.service.getProductStock(me.getCurrentPartner().getId(), no, prodname, null, pageno, contact);
        model.addAttribute("partners", (Object)product);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("no", (Object)no);
        model.addAttribute("prodname", (Object)prodname);
        return "/product/myfindsStock.ftl";
    }

    @RequestMapping(value={"/findMyProductPrice.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findMyProductPrice(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, ProductCondition con) {
        Employee me = this.getCurrentEmployee();
        Page page = null;
        if (me.getCurrentPartner().getParPartnerId() == null) {
            page = this.service.getPartnerProductsTCBJ(con, pageno);
        } else {
            page = this.service.getProductPricesPage(me.getCurrentPartner().getId(), con, pageno);
            ArrayList<Product> products = new ArrayList<Product>();
            List list = page.getList();
            for (Object[] obj : list) {
                products.add((Product)obj[0]);
            }
            page.setList(products);
        }
        model.addAttribute("partners", (Object)page);
        model.addAttribute("con", (Object)con);
        return "/product/findProductPrice.ftl";
    }

    @RequestMapping(value={"/findProductPoints.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findProductPoints(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, ProductCondition con) {
        Employee me = this.getCurrentEmployee();
        Page page = null;
        page = this.service.findProductPointsByPage(me, con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "/product/productPointsList.ftl";
    }

    @RequestMapping(value={"/allotPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String allotProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, ProductCondition con) {
        con.setEm(this.getCurrentEmployee());
        Page product = this.service.getProducts(this.getCurrentEmployee().getCurrentPartner().getId(), id, con, pageno);
        String plist = this.service.getPartnerList(this.getCurrentEmployee().getCurrentPartner().getId(), this.getCurrentEmployee());
        Product prod = this.service.get(id);
        model.addAttribute("partners", (Object)product);
        model.addAttribute("name", (Object)prod.getName());
        model.addAttribute("no", (Object)prod.getNo());
        model.addAttribute("prodno", (Object)id);
        model.addAttribute("plist", (Object)plist);
        model.addAttribute("con", (Object)con);
        return "product/allot.ftl";
    }

    @RequestMapping(value={"/allotProductsQ.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String allotProducts(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String applyerId, Model model, String id, ProductCondition con, String partnerno) {
        Object product;
        Employee em = this.getCurrentEmployee();
        if (em.getCurrentPartner().getParPartnerId() == null) {
            product = this.service.getProducts(applyerId, con, pageno);
            model.addAttribute("partners", product);
        } else {
            try {
                product = this.service.getMyProducts(em.getCurrentPartner().getId(), applyerId, con);
                model.addAttribute("partners", product);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        try {
            Contact contact = this.personnelService.get(em.getId());
            String plist = this.service.getProductList(applyerId, contact);
            model.addAttribute("plist", (Object)plist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("name", (Object)this.service.getApplayName(id));
        model.addAttribute("applyerId", (Object)applyerId);
        model.addAttribute("id", (Object)id);
        model.addAttribute("partnerno", (Object)partnerno);
        model.addAttribute("condition", (Object)con);
        return "product/allotProducts.ftl";
    }

    @RequestMapping(value={"/allotProduct.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String allotProductsbmit(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno) {
        String[] sr = id.split(":");
        try {
            this.service.updateProduct(sr, pageno, prodno);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/allotProducts.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String allotProductsPost(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String applyerId) {
        String[] sr = id.split(":");
        try {
            this.service.updateProducts(sr, pageno, applyerId);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/abateProduct.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String abateProductsbmit(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno) {
        String[] sr = id.split(":");
        try {
            this.service.updateabateProduct(sr, pageno, prodno);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/openStock.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String openStock(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno, String flag) {
        String[] sr = id.split(":");
        try {
            this.service.updateOpenStock(sr, pageno, prodno, flag);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/closeStock.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String closeStock(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String prodno, String flag) {
        String[] sr = id.split(":");
        try {
            this.service.updateCloseStock(sr, pageno, prodno, flag);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/abateProducts.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String abateProductsPost(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String id, Model model, String applyerId) {
        String[] sr = id.split(":");
        try {
            this.service.updateabateProducts(sr, pageno, applyerId);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/Distribusbmit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String distribusbmit(String id, Model model, Double min, Double max, Double divideQuantity, Date invalidDt) {
        try {
            this.service.updateFindProduct(id, min, max, divideQuantity, invalidDt);
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/DistribusbmitAll.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String distribusbmitAll(PartnerProduct partnerproduct) {
        try {
            this.service.updateFindProductAll(partnerproduct.getPartnerProducts());
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/findMyProductR.do"}, method={RequestMethod.GET})
    public String findMyProductR(String id, Model model) throws Exception {
        List<Object> product = this.service.findProducts(id);
        model.addAttribute("product", product);
        return "/product/view.ftl";
    }
}

