/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pushrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.OrderPushItem;
import com.tcbj.crm.entity.OrderPushRule;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.pushrule.PushRuleCondition;
import com.tcbj.crm.pushrule.PushRuleService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pushrule"})
public class PushRuleController
extends BaseController {
    @Autowired
    PushRuleService pushRuelService;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PushRuleCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setEm(e);
        Page page = this.pushRuelService.getListByPage(pageno, condition);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "pushrule/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, HttpServletRequest request) {
        OrderPushRule orderPushRule = new OrderPushRule();
        EmployeePartner partner = this.getCurrentEmployee().getCurrentPartner();
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("detail", (Object)JSON.toJSONString(orderPushRule.getOrderPushItems()));
        model.addAttribute("master", (Object)orderPushRule);
        model.addAttribute("date", (Object)DateUtils.now());
        return "pushrule/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save_post(@Valid @RequestBody OrderPushRule orderPushRule, BindingResult errors, HttpServletResponse response, Model model, HttpServletRequest request) throws Exception {
        if (errors.hasErrors()) {
            model.addAttribute("errors", (Object)errors.getFieldErrors());
            StringBuffer err = new StringBuffer();
            for (FieldError msg : errors.getFieldErrors()) {
                err.append(msg.getDefaultMessage());
            }
            return this.getErrorResult(err.toString());
        }
        Employee e = this.getCurrentEmployee();
        boolean isName = this.pushRuelService.validateName(orderPushRule.getName(), e.getCurrentPartner().getId(), null);
        if (isName) {
            throw new AppException("4001", orderPushRule.getName());
        }
        List<OrderPushItem> list = orderPushRule.getOrderPushItems();
        orderPushRule.fillInitData(e);
        for (OrderPushItem detail : list) {
            detail.fillInitData(e);
        }
        this.pushRuelService.savePushRule(orderPushRule, e);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        OrderPushRule orderRulPushRule = this.pushRuelService.getPushRuleById(id);
        model.addAttribute("master", (Object)orderRulPushRule);
        return "pushrule/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody OrderPushRule orderPushRule, BindingResult errors, Model model, HttpServletRequest request) {
        if (errors.hasErrors()) {
            model.addAttribute("errors", (Object)errors.getFieldErrors());
            StringBuffer err = new StringBuffer();
            for (FieldError msg : errors.getFieldErrors()) {
                err.append(msg.getDefaultMessage());
            }
            return this.getErrorResult(err.toString());
        }
        Employee e = this.getCurrentEmployee();
        orderPushRule.fillInitData(e);
        this.pushRuelService.updatePushRule(orderPushRule, e);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request) {
        this.pushRuelService.deletePushRule(id);
        return "redirect:/pushrule/list.do";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(String id, Model model, HttpServletRequest request) {
        OrderPushRule orderRulPushRule = this.pushRuelService.getPushRuleById(id);
        model.addAttribute("details", (Object)JSON.toJSONStringWithDateFormat(orderRulPushRule.getOrderPushItems(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("master", (Object)orderRulPushRule);
        return "pushrule/view.ftl";
    }

    @RequestMapping(value={"/getRuleItms.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getRuleItemList(PushRuleCondition con, Model model) {
        con.setEm(this.getCurrentEmployee());
        Page page = this.pushRuelService.getRuleItemList(con);
        return page;
    }
}

