/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pushrule;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.OrderPushItem;
import com.tcbj.crm.entity.OrderPushRule;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.pushrule.PushRuleCondition;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushRuleService")
public class PushRuleService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ProductService productService;
    @Autowired
    StockService stockService;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    PactMainService pactMainService;

    public Page getListByPage(int pageno, PushRuleCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        hql.append(" select distinct(o) from OrderPushRule o , OrderPushItem p ,Customer c where ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) and c.applyerId = p.applyerId and c.supplierId=p.supplierId ");
        hql.append(" and o.id = p.ruleId ");
        hql.append(" and o.partnerId=?");
        args.add(condition.getEm().getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and o.name like ? ");
            args.add("%" + condition.getName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and  p.applyerId=? ");
            args.add(condition.getApplyerId());
        }
        hql.append(" and sysdate between nvl(o.startDt,sysdate-1) and nvl(o.endDt,sysdate +1 )");
        hql.append(" order by o.createDt  desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void savePushRule(OrderPushRule orderPushRule, Employee me) {
        this.baseDao.save((Object)orderPushRule);
        try {
            List<OrderPushItem> list = orderPushRule.getOrderPushItems();
            for (OrderPushItem detail : list) {
                detail.setRuleId(orderPushRule.getId());
                detail.setSupplierId(me.getCurrentPartner().getId());
                this.baseDao.save((Object)detail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deletePushRule(String id) {
        String hql = " delete from OrderPushRule where id = ? ";
        String hql2 = " delete from OrderPushItem where ruleId = ?";
        this.baseDao.executeHQL(hql, new Object[]{id});
        this.baseDao.executeHQL(hql2, new Object[]{id});
    }

    public OrderPushRule getPushRuleById(String id) {
        OrderPushRule orderPushRule = (OrderPushRule)this.baseDao.get(OrderPushRule.class, (Serializable)((Object)id));
        String hql = " from OrderPushItem where ruleId=? and sysdate between nvl(startDt,sysdate-1) and nvl(endDt,sysdate +1 )";
        List orderPushItems = this.baseDao.findEntity(hql, new Object[]{id}, OrderPushItem.class);
        orderPushRule.setOrderPushItems(orderPushItems);
        return orderPushRule;
    }

    public void updatePushRule(OrderPushRule orderPushRule, Employee me) {
        this.baseDao.update((Object)orderPushRule);
        if (StringUtils.isNotEmpty(orderPushRule.getDelIds())) {
            String[] stringArray = orderPushRule.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.baseDao.deleteById(OrderPushItem.class, (Serializable)((Object)id));
                ++n2;
            }
        }
        try {
            List<OrderPushItem> list = orderPushRule.getOrderPushItems();
            for (OrderPushItem detail : list) {
                detail.setSupplierId(me.getCurrentPartner().getId());
                detail.fillInitData(me);
                detail.setRuleId(orderPushRule.getId());
                if (StringUtils.isNotEmpty(detail.getId())) {
                    this.baseDao.update((Object)detail);
                    continue;
                }
                this.baseDao.save((Object)detail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Page getRuleItemList(PushRuleCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regionids = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        hql.append(" select DISTINCT(p) from OrderPushItem p,Customer c where ( c.areaCode in (" + regionids + ") or c.bigAreaCode in (" + regionids + ") ) and p.applyerId = c.applyerId and p.ruleId = ? ");
        args.add(con.getId());
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            hql.append(" and p.applyerId =? ");
            args.add(con.getApplyerId());
        }
        hql.append(" and sysdate between nvl(p.startDt,sysdate-1) and nvl(p.endDt,sysdate +1 )");
        hql.append(" order by p.createDt asc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), con.getRowsize().intValue(), con.getPageno().intValue());
        HashMap<String, OrderPushItem> map = new HashMap<String, OrderPushItem>();
        for (OrderPushItem detail : page.getList()) {
            map.put(String.valueOf(detail.getRuleId()) + "_" + detail.getApplyerId() + "_" + detail.getSupplierId(), detail);
        }
        ArrayList<OrderPushItem> pushItmes = new ArrayList<OrderPushItem>();
        for (OrderPushItem detail : map.values()) {
            pushItmes.add(detail);
        }
        page.setList(pushItmes);
        return page;
    }

    public boolean validateName(String name, String partnterId, String id) {
        OrderPushRule orderPushRule;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from OrderPushRule where  partnerId=? and  name =? ");
        args.add(partnterId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            hql.append(" and id <> ?");
            args.add(id);
        }
        return StringUtils.isNotNull(orderPushRule = (OrderPushRule)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), OrderPushRule.class));
    }

    public OrderPushItem getOrderPushItem(String applyerId, String supplierId, String ruleId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from OrderPushItem p where p.applyerId=? and p.supplierId=?  ");
        args.add(applyerId);
        args.add(supplierId);
        if (StringUtils.isNotEmpty(ruleId)) {
            hql.append(" and p.ruleId =?");
            args.add(ruleId);
        }
        hql.append(" order by p.createDt desc  ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), OrderPushItem.class);
        if (list.size() > 0) {
            return (OrderPushItem)list.get(0);
        }
        return null;
    }

    public List<OrderPushItem> getAllOrderPushItmes(String ruleId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from OrderPushItem  where  1=1 ");
        if (StringUtils.isNotEmpty(ruleId)) {
            hql.append(" and ruleId=? ");
            args.add(ruleId);
        }
        hql.append(" and sysdate between nvl(startDt,sysdate-1) and nvl(endDt,sysdate +1 ) order by createDt asc ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), OrderPushItem.class);
        HashMap<String, OrderPushItem> detailMap = new HashMap<String, OrderPushItem>();
        for (OrderPushItem item : list) {
            detailMap.put(String.valueOf(item.getApplyerId()) + "_" + item.getSupplierId(), item);
        }
        ArrayList<OrderPushItem> orderPushItemList = new ArrayList<OrderPushItem>();
        orderPushItemList.addAll(detailMap.values());
        return orderPushItemList;
    }

    public boolean validateOrderPushItems(OrderPushRule orderPushRule, Employee e) {
        List<OrderPushItem> itmes = orderPushRule.getOrderPushItems();
        List<OrderPushItem> oldOrderPushItems = this.getAllOrderPushItmes(null);
        for (OrderPushItem s1 : itmes) {
            for (OrderPushItem s2 : oldOrderPushItems) {
                if (!(String.valueOf(s1.getApplyerId()) + "_" + e.getCurrentPartner().getId()).equals(String.valueOf(s2.getApplyerId()) + "_" + s2.getSupplierId())) continue;
                if (DateUtils.compare((Date)s2.getStartDt(), (Date)s1.getStartDt())) {
                    if (s2.getEndDt() == null || s1.getEndDt() == null) {
                        return true;
                    }
                    if (s2.getEndDt() != null && s1.getEndDt() != null && DateUtils.compare((Date)s2.getEndDt(), (Date)s1.getStartDt())) {
                        return true;
                    }
                }
                if (!DateUtils.compare((Date)s1.getEndDt(), (Date)s2.getStartDt())) continue;
                if (s2.getEndDt() == null) {
                    return true;
                }
                if (s2.getEndDt() == null || !DateUtils.compare((Date)s1.getEndDt(), (Date)s2.getEndDt())) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - void declaration
     */
    public void savePushJob() {
        List<OrderPushItem> pushList = this.getAllOrderPushItmes(null);
        for (OrderPushItem pushItem : pushList) {
            boolean bl;
            List<PartnerAddress> addressList;
            Product product;
            Object objs;
            List list;
            String[] days;
            if ("N".equals(pushItem.getUseSale()) || StringUtils.isEmpty(pushItem.getSchedule()) || (days = pushItem.getSchedule().split(",")).length == 0) continue;
            ArrayList<String> daysList = new ArrayList<String>();
            String[] stringArray = days;
            int n = days.length;
            int n2 = 0;
            while (n2 < n) {
                String day = stringArray[n2];
                daysList.add(day.trim());
                ++n2;
            }
            Calendar c = Calendar.getInstance();
            if (!daysList.contains(String.valueOf(c.get(5)))) continue;
            String applyerId = pushItem.getApplyerId();
            String supplierId = pushItem.getSupplierId();
            Partner partner = Cache.getPartner(applyerId);
            Customer customer = this.clientService.getCustomer(supplierId, applyerId);
            if ("N".equals(customer.getIsAdditionalCal()) || (list = this.baseDao.findEntity(" from OrderApply o where o.applyerId = ? and o.supplierId = ? and  o.source = ? and o.state = '0'", new Object[]{applyerId, supplierId, "\u81ea\u52a8\u8865\u8d27"}, OrderApply.class)) != null && list.size() > 0) continue;
            Map<Object, Object> resultMap = new HashMap<String, Double>();
            List<PartnerProduct> ppList = this.productService.getProductStock(applyerId);
            PactMain contract = this.pactMainService.getPactMain(applyerId, supplierId, new Date());
            List<Object> products = this.productService.getPartnerProducts(applyerId, supplierId);
            HashMap<String, Product> myProduct = new HashMap<String, Product>();
            for (Object objects : products) {
                objs = (Object[])objects;
                product = (Product)objs[0];
                myProduct.put(product.getId(), product);
            }
            if ("Y".equals(pushItem.getUseSale())) {
                Double additionalRatio = Double.parseDouble(customer.getAdditionalRatio().toString());
                Double saleMonths = pushItem.getSaleMonths();
                Date endDate = new Date();
                Date startDate = DateUtils.getDateBeforeMonth((Date)endDate, (int)saleMonths.intValue());
                resultMap = this.orderApplyService.findProductApplyQuantitys(applyerId, supplierId, startDate, endDate, null);
                Set<Object> productIdSet = resultMap.keySet();
                for (String string : productIdSet) {
                    Double d = (Double)resultMap.get(string);
                    d = MathUtils.m2((Double)MathUtils.mul((Double)(d / saleMonths), (Double)additionalRatio), (int)0);
                    resultMap.put(string, d);
                }
            } else {
                for (Object objects : products) {
                    objs = (Object[])objects;
                    product = (Product)objs[0];
                    resultMap.put(product.getId(), 0.0);
                }
            }
            if ("Y".equals(pushItem.getUseApplyerStock())) {
                Map<String, Double> stockMap = this.stockService.getQuantityByPartner(applyerId);
                for (PartnerProduct pp : ppList) {
                    void var22_30;
                    Double resultCount = (Double)resultMap.get(pp.getProductId());
                    if (resultCount == null) {
                        resultCount = 0.0;
                    }
                    Double currentCount = 0.0;
                    if ("Y".equals(pushItem.getUseSupplierStock()) && (currentCount = stockMap.get(pp.getProductId())) == null) {
                        currentCount = 0.0;
                    }
                    resultCount = pp.getStockMax() != null && resultCount - currentCount > pp.getStockMax() ? Double.valueOf(pp.getStockMax() - currentCount) : Double.valueOf(resultCount - currentCount);
                    resultCount = resultCount < 0.0 ? 0.0 : resultCount;
                    resultMap.put(pp.getProductId(), resultCount);
                    Double d = 0.0;
                    if (pp.getStockMin() != null) {
                        Double d2 = pp.getStockMin();
                    }
                    if (!(resultCount + currentCount < var22_30.doubleValue())) continue;
                    resultCount = var22_30.doubleValue() - currentCount;
                }
            }
            OrderApply order = new OrderApply(null, applyerId, supplierId, TCBJEnum.OrderNature.buy.getValue(), TCBJEnum.AuditState.draft.getValue());
            order.setCurrencyCode("CNY");
            order.setSource("\u81ea\u52a8\u8865\u8d27");
            order.setOrgId(partner.getMasterOuId());
            order.setAreaCode(customer.getAreaCode());
            order.setTaxCode(customer.getSaleTax());
            order.setCreateDt(new Date());
            order.setIsReport(partner.getIsReport());
            order.setSettlementModeCode(customer.getSettlementModeCode());
            order.setDeliveryLevelCode(customer.getDeliveryLevelCode());
            order.setOrderTypeCode(customer.getOrderTypeCode());
            order.setIsDeliveryFreezed(customer.getIsDeliveryFreezed());
            order.setDeliveryCode(customer.getDeliveryCode());
            order.setIsCreditManaged(customer.getIsCreditManaged());
            order.setContractNo(contract.getPactNo());
            order.setSalesman(customer.getCityManagerId());
            order.setRelatedApplyerId(customer.getRelatedDelearId());
            if (customer.getReceiptAddresses() != null && customer.getReceiptAddresses().size() > 0) {
                PartnerAddress address = customer.getReceiptAddresses().get(0);
                order.setContacts(address.getContactCode());
                order.setPhone(address.getContactPhone());
                order.setShippingAddress(address.getAddress());
                order.setHarvestWarehouse(address.getHarvestWarehouse());
                order.setDisApplyerId(address.getDisDelearId());
            }
            if ((addressList = customer.getReceiptAddresses()) != null && addressList.size() > 0) {
                PartnerAddress pa = addressList.get(0);
                order.setShippingAddress(pa.getAddress());
                order.setContacts(pa.getContactCode());
                order.setPhone(pa.getContactPhone());
            }
            this.baseDao.save((Object)order);
            Set<Object> productIdSet = resultMap.keySet();
            double allQuantity = 0.0;
            boolean bl2 = false;
            for (String string : productIdSet) {
                Double quantity = (Double)resultMap.get(string);
                if (quantity == 0.0 || myProduct.get(string) == null || !"PRODUCT".equals(Cache.getProduct(string).getOrderProdType().toUpperCase())) continue;
                allQuantity += quantity.doubleValue();
                OrderApplyItem item = new OrderApplyItem();
                item.setProductId(string);
                item.setQuantity(quantity);
                item.setOrderApplyId(order.getId());
                item.setCreateDt(new Date());
                item.setCreatorId("0-2");
                item.setLastUpdateDt(new Date());
                item.setLastUpdatorId("0-2");
                Product product2 = Cache.getProduct(string);
                item.setUnitCode(product2.getUnitCode() == null ? " " : product2.getUnitCode());
                this.baseDao.save((Object)item);
                bl = true;
            }
            if (!bl) {
                this.baseDao.delete((Object)order);
                continue;
            }
            order.setQuantity(allQuantity);
            this.baseDao.update((Object)order);
        }
    }
}

