/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.region;

import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.region.RegionCondition;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="regionService")
public class RegionService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ChannelTypeService channelTypeService;

    public Region get(String id) {
        return (Region)this.baseDao.get(Region.class, (Serializable)((Object)id));
    }

    public void save(Region obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, RegionCondition condition, String orgId, String parentId) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Region o where 1=1");
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(condition.getRegionName())) {
            HQL.append(" and o.regionName like ? ");
            args.add("%" + condition.getRegionName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getRegionCode())) {
            HQL.append(" and o.regionCode like ? ");
            args.add("%" + condition.getRegionCode() + "%");
        }
        if (StringUtils.isNotEmpty(orgId)) {
            HQL.append(" and o.orgId = ? ");
            args.add(orgId);
        }
        if (StringUtils.isNotEmpty(parentId)) {
            HQL.append(" and o.parentId = ? ");
            args.add(parentId);
        }
        HQL.append("order by o.createDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void update(Region obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Region.class, (Serializable)((Object)id));
    }

    public String getChildNodeTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by createDt desc ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pts) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)pn.getId());
            node.put("pId", (Object)pn.getParentId());
            node.put("name", (Object)pn.getRegionName());
            node.put("url", (Object)"/region/list");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
        }
        return nodes.toString();
    }

    public String orgTree(String orgId, Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u533a\u57df\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("nocheck", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by created  ", new Object[]{p.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)p.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("url", (Object)"/region/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public boolean isCode(String code, String id) throws Exception {
        List list;
        boolean isexist = false;
        String hql = "from Region a where 1=1 ";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(code)) {
            hql = String.valueOf(hql) + "and a.regionCode = ?";
            args.add(code);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and a.id != ?";
            args.add(id);
        }
        if ((list = this.baseDao.findEntity(hql, args.toArray(), Region.class)).size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    public boolean isName(String name, String orgId, String id) throws Exception {
        List list;
        boolean isexist = false;
        String hql = "from Region a where 1=1";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(name)) {
            hql = String.valueOf(hql) + "and a.regionName = ?";
            args.add(name);
        }
        if (StringUtils.isNotEmpty(orgId)) {
            hql = String.valueOf(hql) + "and a.orgId = ?";
            args.add(orgId);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and a.id != ?";
            args.add(id);
        }
        if ((list = this.baseDao.findEntity(hql, args.toArray(), Region.class)).size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    public List<Region> getParentAreas(String parentId, String partnerId) {
        ArrayList<Object> args = new ArrayList<Object>();
        String hql = " from Region r where r.parentId = ? ";
        args.add(parentId);
        if (StringUtils.isNotEmpty(partnerId)) {
            hql = String.valueOf(hql) + " and orgId = ? ";
            args.add(partnerId);
        }
        hql = String.valueOf(hql) + " and startDate <= ? and nvl(endDate,?) >= ? ";
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        return this.baseDao.findEntity(hql, args.toArray(), Region.class);
    }

    public List<Region> getBigAreas(String partnerId) {
        String hql = "select r from Region r,ChannelType c where c.id = r.parentId and r.orgId = ? and r.startDate <= ? and nvl(r.endDate,?) >= ? ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId, DateUtils.now(), DateUtils.getEndTime(), DateUtils.now()}, Region.class);
    }

    public List<Region> getBigAreas(String partnerId, String name) {
        String hql = "select r from Region r,ChannelType c where c.id = r.parentId and c.name = ? and r.orgId = ? and r.startDate <= ? and nvl(r.endDate,?) >= ? ";
        return this.baseDao.findEntity(hql, new Object[]{name, partnerId, DateUtils.now(), DateUtils.getEndTime(), DateUtils.now()}, Region.class);
    }

    public List<Region> getAreas(String partnerId) {
        String hql = "from Region m where m.parentId in (select r.id from ChannelType t,Region r where t.id = r.parentId and t.partnerId = ? and r.startDate <= ? and nvl(r.endDate,?) >= ? and t.startDt <= ? and nvl(t.endDt,?) >= ? ) and m.startDate <= ? and nvl(m.endDate,?) >= ? ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId, DateUtils.now(), DateUtils.getEndTime(), DateUtils.now(), DateUtils.now(), DateUtils.getEndTime(), DateUtils.now(), DateUtils.now(), DateUtils.getEndTime(), DateUtils.now()}, Region.class);
    }
}

