/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.reply;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.Reply;
import com.tcbj.crm.entity.ReplyDetails;
import com.tcbj.crm.reply.ReplyCondition;
import com.tcbj.crm.reply.ReplyService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reply"})
public class ReplyController
extends BaseController {
    @Autowired
    ReplyService replyservice;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String add_post(@Valid Reply reply, Model model, ReplyDetails rd) {
        Employee e = this.getCurrentEmployee();
        reply.setFlag("0");
        reply.setApplyerId(e.getCurrentPartner().getId());
        reply.fillInitData(e);
        this.replyservice.save(reply);
        if (!"".equals(rd.getContent()) && rd.getContent() != null) {
            rd.setReplyId(reply.getId());
            rd.fillInitData(e);
            this.replyservice.saveReplyDetails(rd);
        }
        return "true";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String edit_post(@Valid Reply reply, Model model, HttpServletRequest request, ReplyDetails rd, String name) {
        Employee e;
        block4: {
            try {
                e = this.getCurrentEmployee();
                reply = this.replyservice.get(reply.getId());
                if (!"2".equals(reply.getFlag())) break block4;
                return "false2";
            }
            catch (Exception exception) {
                return "false";
            }
        }
        if (!name.equals(e.getName())) {
            reply.setFlag("1");
        }
        reply.updateLastData(e);
        this.replyservice.update(reply);
        rd.setReplyId(reply.getId());
        rd.fillInitData(e);
        this.replyservice.saveReplyDetails(rd);
        return "true";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("name", (Object)e.getName());
        model.addAttribute("sysdate", (Object)DateUtils.now());
        List<Partner> list = this.clientService.getSuppliers(e.getCurrentPartner().getId());
        if (list.size() == 1) {
            model.addAttribute("partner", (Object)list.get(0));
        }
        return "reply/add.ftl";
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ReplyCondition condition, Model model, HttpServletRequest request) {
        model.addAttribute("page", (Object)this.replyservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "reply/list.ftl";
    }

    @RequestMapping(value={"/mylist.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String mylist(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ReplyCondition condition, Model model, HttpServletRequest request) {
        model.addAttribute("page", (Object)this.replyservice.getMyList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "reply/mylist.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee e = this.getCurrentEmployee();
        Reply reply = this.replyservice.get(id);
        List<ReplyDetails> rds = this.replyservice.getReplyDetails(id);
        model.addAttribute("reply", (Object)reply);
        model.addAttribute("rds", rds);
        model.addAttribute("name", (Object)e.getName());
        return "reply/edit.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model, HttpServletRequest request, String flag) {
        this.replyservice.delete(id);
        if (StringUtils.isNotEmpty(flag)) {
            return "redirect:/reply/mylist.do";
        }
        return "redirect:/reply/list.do";
    }

    @RequestMapping(value={"/deleteDetails.do"}, method={RequestMethod.GET})
    public String deleteReplyDetails(String id, String replyId, Model model, HttpServletRequest request) {
        if ("2".equals(this.replyservice.get(replyId).getFlag())) {
            return "redirect:/reply/edit.do?&id=" + replyId;
        }
        this.replyservice.deleteReplyDetails(id);
        return "redirect:/reply/edit.do?&id=" + replyId;
    }

    @RequestMapping(value={"/editDetails.do"}, method={RequestMethod.GET})
    public String editDetails(String id, String flag, Model model) {
        Reply reply = this.replyservice.get(id);
        reply.setFlag("2");
        reply.updateLastData(this.getCurrentEmployee());
        this.replyservice.update(reply);
        if ("1".equals(flag)) {
            return "redirect:/reply/list.do";
        }
        return "redirect:/reply/mylist.do";
    }
}

