/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.entity.ContactPartner;
import com.tcbj.crm.entity.ContactPosition;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.report.EmployeeReportCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="employeeReportService")
public class EmployeeReportService {
    @Autowired
    private BaseDao baseDao;

    public Page getReportEmployeePage(EmployeeReportCondition condition, int pageno, Employee e) {
        EmployeePartner partner = (EmployeePartner)this.baseDao.findFirstEntity("from EmployeePartner where personId=?", new Object[]{e.getId()}, EmployeePartner.class);
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select capc ");
        sb.append(" from PartnerContact capc,Partner p ");
        sb.append(" where capc.partnerId = p.id and personType is not null and capc.pOrgId = ?");
        args.add(partner.getOrganizationid());
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            sb.append(" and capc.partnerId = ? ");
            args.add(condition.getPartnerId());
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            sb.append(" and capc.dutyTypeCode = ? ");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            sb.append(" and capc.contactName like ? ");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPostId())) {
            sb.append(" and( exists (select 1 ");
            sb.append(" from ContactPosition csp ");
            sb.append(" where csp.userId = capc.id ");
            sb.append(" and csp.postId = ? )) ");
            args.add(condition.getPostId());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            sb.append(" and (exists ");
            sb.append(" (select 1 ");
            sb.append(" from ContactRegion csr ");
            sb.append(" where csr.userId = capc.id ");
            sb.append(" and csr.regionId = ? )) ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            sb.append(" and (exists ");
            sb.append(" (select 1 ");
            sb.append(" from ContactRegion csr ");
            sb.append(" where csr.userId = capc.id ");
            sb.append(" and csr.regionId = ? )) ");
            args.add(condition.getAreaCode());
        }
        return this.baseDao.search(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<PartnerContact> getReportEmployeeList(EmployeeReportCondition condition) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select capc ");
        sb.append(" from PartnerContact capc,Partner p ");
        sb.append(" where capc.partnerId = p.id and personType is not null ");
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            sb.append(" and capc.partnerId = ? ");
            args.add(condition.getPartnerId());
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            sb.append(" and capc.dutyTypeCode = ? ");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            sb.append(" and capc.contactName like ? ");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPostId())) {
            sb.append(" and( exists (select 1 ");
            sb.append(" from ContactPosition csp ");
            sb.append(" where csp.userId = capc.id ");
            sb.append(" and csp.postId = ? )) ");
            args.add(condition.getPostId());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            sb.append(" and (exists ");
            sb.append(" (select 1 ");
            sb.append(" from ContactRegion csr ");
            sb.append(" where csr.userId = capc.id ");
            sb.append(" and csr.regionId = ? )) ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            sb.append(" and (exists ");
            sb.append(" (select 1 ");
            sb.append(" from ContactRegion csr ");
            sb.append(" where csr.userId = capc.id ");
            sb.append(" and csr.regionId = ? )) ");
            args.add(condition.getAreaCode());
        }
        return this.baseDao.findEntity(sb.toString(), args.toArray(), PartnerContact.class);
    }

    public List<ContactPosition> getContactPositionList(String partnerId) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select csp from Position cpm,ContactPosition csp where cpm.orgId = ? and cpm.id = csp.postId ");
        args.add(partnerId);
        return this.baseDao.findEntity(sb.toString(), args.toArray(), ContactPosition.class);
    }

    public Map<String, String> getContactPositionMap(String partnerId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<ContactPosition> list = this.getContactPositionList(partnerId);
        Date n = DateUtils.now();
        int listSize = list.size();
        int i = 0;
        while (i < listSize) {
            String value;
            if (map.get(list.get(i).getUserId()) == null) {
                value = list.get(i).getPostName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            } else {
                value = String.valueOf((String)map.get(list.get(i).getUserId())) + "," + list.get(i).getPostName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            }
            ++i;
        }
        return map;
    }

    public List<ContactRegion> getContactRegionList(String partnerId) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select csr from Region crm,ContactRegion csr where crm.id = csr.regionId and crm.orgId = ? ");
        args.add(partnerId);
        return this.baseDao.findEntity(sb.toString(), args.toArray(), ContactRegion.class);
    }

    public Map<String, String> getContactRegionMap(String partnerId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<ContactRegion> list = this.getContactRegionList(partnerId);
        Date n = DateUtils.now();
        int listSize = list.size();
        int i = 0;
        while (i < listSize) {
            String value;
            if (map.get(list.get(i).getUserId()) == null) {
                value = list.get(i).getRegionName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            } else {
                value = String.valueOf((String)map.get(list.get(i).getUserId())) + "," + list.get(i).getRegionName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            }
            ++i;
        }
        return map;
    }

    public List<ContactPartner> getContactPartnerList(String partnerId) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select csr from Customer crm,ContactPartner csr where crm.applyerId = csr.applyerId and crm.supplierId = ? ");
        args.add(partnerId);
        return this.baseDao.findEntity(sb.toString(), args.toArray(), ContactPartner.class);
    }

    public Map<String, String> getContactPartnerMap(String partnerId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<ContactPartner> list = this.getContactPartnerList(partnerId);
        Date n = DateUtils.now();
        int listSize = list.size();
        int i = 0;
        while (i < listSize) {
            String value;
            if (map.get(list.get(i).getUserId()) == null) {
                value = list.get(i).getApplyerName();
                if (DateUtils.compare((Date)list.get(i).getStartdate(), (Date)n) && list.get(i).getEnddate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEnddate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            } else {
                value = String.valueOf((String)map.get(list.get(i).getUserId())) + "," + list.get(i).getApplyerName();
                if (DateUtils.compare((Date)list.get(i).getStartdate(), (Date)n) && list.get(i).getEnddate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEnddate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            }
            ++i;
        }
        return map;
    }

    public List<ContactShop> getContactShopList(String partnerId) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("from PartnerContact p, ContactShop csr,ShopView sv where csr.shopId = sv.id and p.id = csr.userId and p.partnerId = ? ");
        args.add(partnerId);
        List objs = this.baseDao.findEntity(sb.toString(), args.toArray(), Object[].class);
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        int i = 0;
        while (i < objs.size()) {
            ContactShop contactShop = (ContactShop)((Object[])objs.get(i))[1];
            ShopView shopView = (ShopView)((Object[])objs.get(i))[2];
            contactShop.setShopId(shopView.getId());
            contactShop.setShopName(shopView.getShopName());
            contactShop.setShopNo(shopView.getShopNumber());
            list.add(contactShop);
            ++i;
        }
        return list;
    }

    public Map<String, String> getContactShopMap(String partnerId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<ContactShop> list = this.getContactShopList(partnerId);
        Date n = DateUtils.now();
        int listSize = list.size();
        int i = 0;
        while (i < listSize) {
            String value;
            if (map.get(list.get(i).getUserId()) == null) {
                value = list.get(i).getShopName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            } else {
                value = String.valueOf((String)map.get(list.get(i).getUserId())) + "," + list.get(i).getShopName();
                if (DateUtils.compare((Date)list.get(i).getStartDate(), (Date)n) && list.get(i).getEndDate() != null && !DateUtils.compare((Date)n, (Date)list.get(i).getEndDate())) {
                    value = String.valueOf(value) + "(\u5931\u6548)";
                }
                map.put(list.get(i).getUserId(), value);
            }
            ++i;
        }
        return map;
    }
}

