/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.entity.Target;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetService;
import com.tcbj.crm.target.TargetWrap;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TargetMonthService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private TargetService targetService;

    public List<TargetWrap> queryTargetAndTargetDataByArgs(TargetCondition con, Employee emp) {
        TargetWrap tw;
        String bigareaId;
        List<Target> targetList = this.queryTargetByCustomer(con, emp);
        List<TargetData> targetDataList = this.queryTargetDataByCustomer(con, emp);
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        for (Target target : targetList) {
            bigareaId = this.getBigareaId(target);
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(bigareaId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            bigareaId = String.valueOf(targetData.getUnionId()) + targetData.getBigareaId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    private List<Target> queryTargetByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Customer c where t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    private List<TargetData> queryTargetDataByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t,Partner p,Customer c where t.userId is null and p.id = t.supplierId and c.supplierId = t.supplierId and c.applyerId = t.applyerId ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.applyerId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), TargetData.class);
        return list;
    }

    private String getBigareaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getBigareaId();
        }
        return null;
    }
}

