/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.role;

import com.tcbj.crm.entity.RoleC;
import com.tcbj.crm.entity.RoleUse;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="roleService")
public class RoleService {
    @Autowired
    private BaseDao baseDao;

    public Page getList(String personId, String name, int pageNo) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from RoleUse where organizationId=?");
        args.add(personId);
        if (StringUtils.isNotEmpty(name)) {
            hql.append(" and ");
            hql.append(" ( ");
            hql.append(" roleName like ? ");
            hql.append(" ) ");
            args.add("%" + name + "%");
        }
        hql.append(" order by to_number(showId)");
        Page list = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageNo);
        return list;
    }

    public List<RoleUse> getRole(String partnerId) throws Exception {
        String hql = " from RoleUse r where r.organizationId = ? order by showId";
        return this.baseDao.findEntity(hql, new Object[]{partnerId}, RoleUse.class);
    }

    public List<RoleUse> getByOrgId(String partnerId) {
        String hql = "from RoleUse r where r.roleType ='External' and r.organizationId = ?";
        return this.baseDao.findEntity(hql, new Object[]{partnerId}, RoleUse.class);
    }

    public void save(RoleUse role) {
        this.baseDao.save((Object)role);
    }

    public RoleUse findById(String id) {
        return (RoleUse)this.baseDao.get(RoleUse.class, (Serializable)((Object)id));
    }

    public void update(RoleUse form) {
        RoleUse roleUse = (RoleUse)this.baseDao.get(RoleUse.class, (Serializable)((Object)form.getId()));
        roleUse.setLastUpd(form.getLastUpd());
        roleUse.setLastUpdBy(form.getLastUpdBy());
        roleUse.setRoleName(form.getRoleName());
        roleUse.setRoleType(form.getRoleType());
        roleUse.setRoleDes(form.getRoleDes());
        roleUse.setShowId(form.getShowId());
        this.baseDao.update((Object)roleUse);
    }

    public void delete(RoleUse form) {
        this.baseDao.deleteById(RoleUse.class, (Serializable)((Object)form.getId()));
    }

    public List<RoleC> getRoleByUser(String roleId) {
        String hql = "from RoleC r where roleId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{roleId}, RoleC.class);
    }

    public boolean isExist(String roleId) {
        List<RoleC> list = this.getRoleByUser(roleId);
        if (list == null) {
            return false;
        }
        return list.size() > 0;
    }
}

