/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.score;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.score.ScoreCondition;
import com.tcbj.crm.siebel.service.ScoreSiebelService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.MemberPoints;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scoreService")
@Transactional
public class ScoreService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ScoreSiebelService siebelService;
    @Autowired
    StockService stockService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    ProductService productService;

    public MemberPoints getMemberPoints(String partnerId) {
        return (MemberPoints)this.baseDao.findFirstEntity("from MemberPoints where partnerId = ? ", new Object[]{partnerId}, MemberPoints.class);
    }

    public ExchangeOrder getExchangeOrder(String id) {
        return (ExchangeOrder)this.baseDao.get(ExchangeOrder.class, (Serializable)((Object)id));
    }

    public ExchangeOrder getExchangeOrderWithDetails(String id) {
        ExchangeOrder order = (ExchangeOrder)this.baseDao.get(ExchangeOrder.class, (Serializable)((Object)id));
        List<ExchangeDetail> details = this.getExchangeDetails(id, null);
        Double orderTotalScore = 0.0;
        Double orderTotalQuantity = 0.0;
        for (ExchangeDetail item : details) {
            Double totalScore = item.getQuantity() * item.getPoints();
            item.setTotalScore(totalScore);
            orderTotalScore = orderTotalScore + totalScore;
            orderTotalQuantity = orderTotalQuantity + item.getQuantity();
        }
        order.setOrderQuantity(orderTotalQuantity);
        order.setOrderScore(orderTotalScore);
        order.setDetails(details);
        return order;
    }

    public Page getExchangeOrders(ScoreCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExchangeOrder where 1=1 ");
        if (condition.isDetail()) {
            if ("1".equals(condition.getOf()) && StringUtils.isNotEmpty(condition.getSupplierId())) {
                hql.append(" and supplierId = ? ");
                args.add(condition.getSupplierId());
                hql.append(" and state in ('Signed') ");
            } else if ("2".equals(condition.getOf()) && StringUtils.isNotEmpty(condition.getApplyerId())) {
                hql.append(" and shopId = ? ");
                args.add(condition.getApplyerId());
                hql.append(" and state in ('Sended','Signed','Approved') ");
            } else if (StringUtils.isNotEmpty(condition.getSupplierId()) && StringUtils.isNotEmpty(condition.getApplyerId())) {
                hql.append(" and ((supplierId = ? and state in ('Signed')) or (shopId = ? and state in ('Sended','Signed','Approved'))) ");
                args.add(condition.getSupplierId());
                args.add(condition.getApplyerId());
            }
        } else {
            if (StringUtils.isNotEmpty(condition.getSupplierId())) {
                hql.append(" and supplierId = ? ");
                args.add(condition.getSupplierId());
            }
            if (StringUtils.isNotEmpty(condition.getApplyerId())) {
                hql.append(" and shopId = ? ");
                args.add(condition.getApplyerId());
            }
            if (StringUtils.isNotEmpty(condition.getOrderStatus())) {
                hql.append(" and state = ? ");
                args.add(condition.getOrderStatus());
            }
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            hql.append(" and no like ? ");
            args.add("%" + condition.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and shopName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getRedeemType())) {
            hql.append(" and redeemType = ? ");
            args.add(condition.getRedeemType());
        }
        if (StringUtils.isNotEmpty(condition.getExchangeStatus())) {
            hql.append(" and exchangeStatus = ? ");
            args.add(condition.getExchangeStatus());
        }
        if (StringUtils.isNotNull(condition.getCreateDtS())) {
            hql.append(" and createDt >= ? ");
            args.add(condition.getCreateDtS());
        }
        if (StringUtils.isNotNull(condition.getCreateDtEHQL())) {
            hql.append(" and createDt <= ? ");
            args.add(condition.getCreateDtEHQL());
        }
        if (StringUtils.isNotEmpty(condition.getOrderType())) {
            hql.append(" and orderType = ? ");
            args.add(condition.getOrderType());
        }
        hql.append(" order by created desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        if (page.getList() == null || page.getList().size() == 0) {
            return page;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (page.getList() != null && page.getList().size() > 0) {
            sb.append(" and t.OrderId in (");
            for (Object obj : page.getList()) {
                ExchangeOrder order = (ExchangeOrder)obj;
                sb.append("'");
                sb.append(order.getId());
                sb.append("'");
                if (i++ >= page.getList().size() - 1) continue;
                sb.append(",");
            }
            sb.append(" ) ");
        }
        String sql = "select t.OrderId,t.giftsubtype,sum(t.Quality) quantity,sum(t.Quality * t.Points) score from CX_AWK_EXCORDER_DETAIL_VIEW t where 1=1 " + sb.toString() + "group by t.OrderId, t.giftsubtype";
        List list = this.baseDao.findBySql(sql);
        block1: for (Object[] obj : list) {
            String orderId = (String)obj[0];
            String type = (String)obj[1];
            Double quantity = 0.0;
            if (obj[2] != null) {
                quantity = ((BigDecimal)obj[2]).doubleValue();
            }
            Double score = 0.0;
            if (obj[3] != null) {
                score = ((BigDecimal)obj[3]).doubleValue();
            }
            for (Object temp : page.getList()) {
                ExchangeOrder order = (ExchangeOrder)temp;
                if (!order.getId().equals(orderId)) continue;
                if ("\u8d60\u54c1".equals(type)) {
                    order.setGiftQuantity(quantity);
                    order.setGiftScore(score);
                    continue block1;
                }
                if (!"\u4ea7\u54c1".equals(type)) continue block1;
                order.setProductQuantity(quantity);
                order.setProductScore(score);
                continue block1;
            }
        }
        return page;
    }

    public List<ExchangeOrder> getMyExchangeOrders(String applyerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ExchangeOrder where shopId = ? and (state='Submitted' or state = 'Approved' ) order by createDt ");
        args.add(applyerId);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), ExchangeOrder.class);
    }

    public List<ExchangeOrder> getExchangeOrdersByIds(String[] ids) {
        if (ids == null) {
            return new ArrayList<ExchangeOrder>();
        }
        StringBuffer hql = new StringBuffer();
        hql.append(" from ExchangeOrder where (");
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (!StringUtils.isEmpty(id)) {
                hql.append("id='" + id + "'");
                if (i < ids.length - 1) {
                    hql.append(" or ");
                }
            }
            ++i;
        }
        hql.append(" )");
        return this.baseDao.findEntity(hql.toString(), ExchangeOrder.class);
    }

    public List<ExchangeDetail> getExchangeDetailsByIds(String[] ids) {
        if (ids == null) {
            return new ArrayList<ExchangeDetail>();
        }
        StringBuffer hql = new StringBuffer();
        hql.append(" from ExchangeDetail where (");
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (!StringUtils.isEmpty(id)) {
                hql.append("orderId='" + id + "'");
                if (i < ids.length - 1) {
                    hql.append(" or ");
                }
            }
            ++i;
        }
        hql.append(" )");
        return this.baseDao.findEntity(hql.toString(), ExchangeDetail.class);
    }

    public List<ExchangeDetail> getExchangeDetails(String id, String type) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ExchangeDetail where orderId = ? ");
        args.add(id);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), ExchangeDetail.class);
    }

    public List<ExchangeDetail> getShopExchangeOrders(String supplierId, Date startDt, Date endDt) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select new ExchangeDetail(detail.productId,detail.productNo,sum(detail.quantity)) from ExchangeOrder _order,ExchangeDetail detail where 1=1 ");
        hql.append(" and _order.supplierId = ? ");
        hql.append(" and detail.orderId=_order.id ");
        hql.append(" and _order.dlvDate >= ? ");
        hql.append(" and _order.dlvDate <= ? ");
        hql.append(" and ( _order.state = 'Signed') ");
        hql.append(" group by detail.productId,detail.productNo order by detail.productNo ");
        args.add(supplierId);
        args.add(startDt);
        args.add(endDt);
        List details = this.baseDao.findEntity(hql.toString(), args.toArray(), ExchangeDetail.class);
        for (ExchangeDetail detail : details) {
            String productId = detail.getProductId();
            ProductGiftView product = Cache.getGift(productId);
            if (product == null) continue;
            detail.setProductName(product.getName());
            detail.setProductNo(product.getNo());
            detail.setSpec(product.getSpec());
            detail.setTransactionSubType(product.getCategory());
        }
        return details;
    }

    public List<ProductGiftView> getProducts(String orgId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ProductGiftView where orgId = ? and easNo is not null order by no ");
        Object[] args = new Object[]{orgId};
        return this.baseDao.findEntity(hql.toString(), args, ProductGiftView.class);
    }

    public List<ProductGiftView> getActiveProducts(String applyId, String supplierId) {
        List<ProductGiftView> productGiftList = this.getGiftProductsByOrg(applyId, supplierId);
        this.calculateGiftProductQuantitys(productGiftList, supplierId);
        return productGiftList;
    }

    private void calculateGiftProductQuantitys(List<ProductGiftView> productGiftList, String orgId) {
        Map<String, Double> easMap = this.stockService.getQuantityByPartner(orgId);
        Map<String, Double> orderMap = this.orderApplyService.findProductApplyedQuantitysForOrg(orgId, null);
        Map<String, Double> scoreMap = this.findProductGiftQuantity(orgId);
        for (ProductGiftView productGift : productGiftList) {
            String productId = productGift.getProductId();
            Double eas = easMap.get(productId) == null ? 0.0 : easMap.get(productId);
            Double order = orderMap.get(productId) == null ? 0.0 : orderMap.get(productId);
            Double score = scoreMap.get(productId) == null ? 0.0 : scoreMap.get(productId);
            Double quantity = eas - order - score;
            productGift.setStockQuantity(quantity);
        }
    }

    public List<ProductGiftView> getGiftProductsByOrg(String applyId, String orgId) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from ProductGiftView p , PartnerProductREL pl where pl.productId = p.productId ");
        hql.append(" and p.orgId = ? and pl.partnerId = ? ");
        hql.append(" and nvl(pl.invalidDt,sysdate + 1) > sysdate ");
        hql.append(" and p.status!='Inactive' and p.easNo is not null order by p.no ");
        Object[] args = new Object[]{orgId, applyId};
        List list = this.baseDao.findEntity(hql.toString(), args);
        ArrayList<ProductGiftView> listGift = new ArrayList<ProductGiftView>();
        for (Object obj : list) {
            Object[] objArr = (Object[])obj;
            ProductGiftView productGift = (ProductGiftView)objArr[0];
            PartnerProductREL productRel = (PartnerProductREL)objArr[1];
            String isDisplay = productRel.getIsDisplay();
            productGift.setIsDisplay(isDisplay == null || !"N".equals(isDisplay) ? "Y" : "N");
            listGift.add(productGift);
        }
        return listGift;
    }

    public Map<String, Double> findProductGiftQuantity(String orgId) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        StringBuilder hql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        hql.append(" select item.productId,sum(item.quantity) ");
        hql.append(" from ExchangeDetailTotal item,ExchangeOrder eOrder ");
        hql.append(" where item.orderId = eOrder.id ");
        if (orgId != null) {
            hql.append(" and eOrder.supplierId = ? ");
            params.add(orgId);
        }
        hql.append(" and (eOrder.state = 'Submitted' or eOrder.state = 'Approved' ) ");
        hql.append(" group by item.productId ");
        List itemOrders = this.baseDao.findEntity(hql.toString(), params.toArray());
        for (Object item : itemOrders) {
            Object[] obj = (Object[])item;
            map.put((String)obj[0], (Double)obj[1]);
        }
        return map;
    }

    public void addExchangeOrder(ExchangeOrder order, Employee me) {
        this.siebelService.addScoreToSiebel(order, me);
    }

    public void updateExchangeOrder(ExchangeOrder order, Employee me) {
        for (ExchangeDetail detail : order.getDetails()) {
            if (!StringUtils.isEmpty(detail.getId())) continue;
            detail.setId(String.valueOf(Math.random()));
        }
        this.siebelService.updateScoreToSiebel(order);
    }

    public void delExchangeOrder(String orderId) {
        this.siebelService.delScoreToSiebel(orderId);
    }

    public void submitExchangeOrder(String orderId) {
        ExchangeOrder order = this.getExchangeOrderWithDetails(orderId);
        if (order == null) {
            return;
        }
        ExchangeOrder clone = order.clone();
        clone.setState("Submitted");
        this.siebelService.updateScoreToSiebel(clone);
    }

    public void unApproveExchangeOrder(String orderId) {
        ExchangeOrder order = this.getExchangeOrderWithDetails(orderId);
        if (order == null) {
            return;
        }
        String hql = " delete OrderApplyItem where orderApplyId=? and isScore='Y' ";
        Object[] args = new Object[]{orderId};
        this.baseDao.executeSQL(hql, args);
        ExchangeOrder clone = order.clone();
        clone.setState("Submitted");
        this.siebelService.updateScoreToSiebel(clone);
    }

    public void approveExchangeOrder(String orderId) {
        ExchangeOrder order = this.getExchangeOrderWithDetails(orderId);
        if (order == null) {
            return;
        }
        ExchangeOrder clone = order.clone();
        clone.setState("Approved");
        if (!order.getState().equals("Approved")) {
            this.siebelService.updateScoreToSiebel(clone);
        }
    }

    public void approveNotPassExchangeOrder(String orderId) {
        ExchangeOrder order = this.getExchangeOrderWithDetails(orderId);
        if (order == null) {
            return;
        }
        ExchangeOrder clone = order.clone();
        clone.setState("Declined");
        this.siebelService.updateScoreToSiebel(clone);
    }

    public int getExchangeOrdersNumber(String supplierId, String orderStatus) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from ExchangeOrder where 1=1 ");
        if (StringUtils.isNotEmpty(supplierId)) {
            hql.append(" and supplierId = ? ");
            args.add(supplierId);
        }
        if (StringUtils.isNotEmpty(orderStatus)) {
            hql.append(" and state = ? ");
            args.add(orderStatus);
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), ExchangeOrder.class);
        return list.size();
    }

    public Page getDetailed(ScoreCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExchangeOrder eco,ExchangeDetail ecd where eco.id = ecd.orderId ");
        if (StringUtils.isNotEmpty(condition.getRedeemType())) {
            hql.append(" and eco.redeemType = ? ");
            args.add(condition.getRedeemType());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            hql.append(" and eco.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getOrderStatus())) {
            hql.append(" and eco.state = ? ");
            args.add(condition.getOrderStatus());
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            hql.append(" and eco.no like ? ");
            args.add("%" + condition.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and eco.shopName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        if (StringUtils.isNotNull(condition.getCreateDtS())) {
            hql.append(" and eco.createDt >= ? ");
            args.add(condition.getCreateDtS());
        }
        if (StringUtils.isNotNull(condition.getCreateDtEHQL())) {
            hql.append(" and eco.createDt <= ? ");
            args.add(condition.getCreateDtEHQL());
        }
        if (StringUtils.isNotNull(condition.getProductNo())) {
            hql.append(" and ecd.productNo like ? ");
            args.add("%" + condition.getProductNo() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        List list = page.getList();
        int size = list.size();
        ArrayList<ExchangeDetail> details = new ArrayList<ExchangeDetail>();
        int i = 0;
        while (i < size) {
            ExchangeDetail detail = new ExchangeDetail();
            ExchangeOrder order = new ExchangeOrder();
            Object[] obj = (Object[])list.get(i);
            detail = (ExchangeDetail)obj[1];
            order = (ExchangeOrder)obj[0];
            detail.setNo(order.getNo());
            detail.setCreateDt(order.getCreateDt());
            detail.setShopName(order.getShopName());
            detail.setRedeemType(order.getRedeemType());
            detail.setOrderType(order.getOrderType());
            detail.setState(order.getState());
            detail.setChannelType(order.getChannelType());
            details.add(detail);
            ++i;
        }
        page.setList(details);
        return page;
    }

    public List<ExchangeDetail> getDetailedOrList(ScoreCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from ExchangeOrder eco,ExchangeDetail ecd where eco.id = ecd.orderId ");
        if (StringUtils.isNotEmpty(condition.getRedeemType())) {
            hql.append(" and eco.redeemType = ? ");
            args.add(condition.getRedeemType());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            hql.append(" and eco.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getOrderStatus())) {
            hql.append(" and eco.state = ? ");
            args.add(condition.getOrderStatus());
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            hql.append(" and eco.no like ? ");
            args.add("%" + condition.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and eco.shopName like ? ");
            args.add("%" + condition.getName() + "%");
        }
        if (StringUtils.isNotNull(condition.getCreateDtS())) {
            hql.append(" and eco.createDt >= ? ");
            args.add(condition.getCreateDtS());
        }
        if (StringUtils.isNotNull(condition.getCreateDtEHQL())) {
            hql.append(" and eco.createDt <= ? ");
            args.add(condition.getCreateDtEHQL());
        }
        if (StringUtils.isNotNull(condition.getProductNo())) {
            hql.append(" and ecd.productNo like ? ");
            args.add("%" + condition.getProductNo() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        int size = list.size();
        ArrayList<ExchangeDetail> details = new ArrayList<ExchangeDetail>();
        int i = 0;
        while (i < size) {
            ExchangeDetail detail = new ExchangeDetail();
            ExchangeOrder order = new ExchangeOrder();
            Object[] obj = (Object[])list.get(i);
            detail = (ExchangeDetail)obj[1];
            order = (ExchangeOrder)obj[0];
            detail.setNo(order.getNo());
            detail.setCreateDt(order.getCreateDt());
            detail.setShopName(order.getShopName());
            detail.setRedeemType(order.getRedeemType());
            detail.setOrderType(order.getOrderType());
            detail.setState(order.getState());
            detail.setChannelType(order.getChannelType());
            details.add(detail);
            ++i;
        }
        return details;
    }

    public boolean excels(List<ExchangeDetail> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u5355\u636e\u53f7", "\u4ea4\u6613\u65f6\u95f4", "\u4ea4\u6613\u65b9", "\u4ea4\u6613\u7c7b\u578b", "\u8ba2\u5355\u72b6\u6001", "\u4ea7\u54c1\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u89c4\u683c", "\u6570\u91cf", "\u4f7f\u7528\u79ef\u5206"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            ExchangeDetail stu = list.get(i);
            row.createCell(0).setCellValue(stu.getNo());
            row.createCell(1).setCellValue(stu.getCreateDt());
            row.createCell(2).setCellValue(stu.getShopName());
            row.createCell(3).setCellValue(stu.getOrderTypeName());
            row.createCell(4).setCellValue(stu.getOrderStatusName());
            row.createCell(5).setCellValue(stu.getProductNo());
            row.createCell(6).setCellValue(stu.getProductName());
            row.createCell(7).setCellValue(stu.getSpec());
            row.createCell(8).setCellValue(stu.getQuantity().doubleValue());
            row.createCell(9).setCellValue(stu.getRowPoints().doubleValue());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public List<ExchangeDetail> getDetailsQuantityByOrderIds(OrderApply orderApply, String[] scoreOrderIds) {
        if (scoreOrderIds == null) {
            return new ArrayList<ExchangeDetail>();
        }
        String orderNos = this.getOrderNosByIds(scoreOrderIds);
        StringBuffer hql = new StringBuffer();
        hql.append(" select productId , sum(quantity) ");
        hql.append(" from ExchangeDetail where (");
        int i = 0;
        while (i < scoreOrderIds.length) {
            String id = scoreOrderIds[i];
            if (!StringUtils.isEmpty(id)) {
                hql.append("orderId='" + id + "'");
                if (i < scoreOrderIds.length - 1) {
                    hql.append(" or ");
                }
            }
            ++i;
        }
        hql.append(" )");
        hql.append("group by productId,productNo ");
        List lists = this.baseDao.findEntity(hql.toString());
        ArrayList<ExchangeDetail> details = new ArrayList<ExchangeDetail>();
        Double totalScore = 0.0;
        Double totalQuantity = 0.0;
        for (Object obj : lists) {
            Object[] objArr = (Object[])obj;
            if (objArr[0] == null) continue;
            ExchangeDetail detail = (ExchangeDetail)this.baseDao.findFirstEntity("from ExchangeDetail where productId = ? ", new Object[]{objArr[0]}, ExchangeDetail.class);
            detail.setQuantity(objArr[1] == null ? 0.0 : (Double)objArr[1]);
            Double useScore = detail.getQuantity() * detail.getPoints();
            detail.setTotalScore(useScore);
            totalScore = totalScore + useScore;
            totalQuantity = totalQuantity + detail.getQuantity();
            details.add(detail);
        }
        orderApply.setTotalScore(totalScore);
        orderApply.setTotalScoreQuantity(totalQuantity);
        orderApply.setExchangeOrderIds(orderNos);
        return details;
    }

    private String getOrderNosByIds(String[] scoreOrderIds) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" select orderNo from ExchangeDetail where orderId in ( ");
        int i = 0;
        while (i < scoreOrderIds.length) {
            hql.append(i == 0 ? "?" : ",?");
            args.add(scoreOrderIds[i]);
            ++i;
        }
        hql.append(" )");
        List detailNos = this.baseDao.findEntity(hql.toString(), args.toArray());
        String orderNos = "";
        int i2 = 0;
        while (i2 < detailNos.size()) {
            orderNos = String.valueOf(orderNos) + (i2 == 0 ? detailNos.get(i2) : "," + detailNos.get(i2));
            ++i2;
        }
        return orderNos;
    }
}

